/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.objects.machines.blastfurnace;

import com.ancient.thaumicgadgets.init.ModBlocks;
import com.ancient.thaumicgadgets.init.ModItems;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.items.ItemsTC;

public class BlastFurnaceRecipes {
    public static final BlastFurnaceRecipes INSTANCE = new BlastFurnaceRecipes();
    private final ArrayList<smeltRecipe> list = new ArrayList();

    public static BlastFurnaceRecipes getInstance() {
        return INSTANCE;
    }

    private BlastFurnaceRecipes() {
        this.addBlastFurnaceRecipe(new ItemStack(ItemsTC.clusters, 1, 0), 5.0f, new ItemStack(Items.field_151042_j, 3), new ItemStack(Items.field_191525_da));
        this.addBlastFurnaceRecipe(new ItemStack(ItemsTC.clusters, 1, 1), 5.0f, new ItemStack(Items.field_151043_k, 3), new ItemStack(Items.field_151074_bl));
        this.addBlastFurnaceRecipe(new ItemStack(ItemsTC.clusters, 1, 6), 5.0f, new ItemStack(ItemsTC.quicksilver, 3), new ItemStack(ItemsTC.nuggets, 1, 5));
        this.addBlastFurnaceRecipe(new ItemStack(ItemsTC.clusters, 1, 7), 5.0f, new ItemStack(Items.field_151128_bU, 3), new ItemStack(ItemsTC.nuggets, 1, 9));
        if (OreDictionary.getOres((String)"ingotCopper").size() > 0) {
            for (ItemStack stack : OreDictionary.getOres((String)"ingotCopper")) {
                this.addBlastFurnaceRecipe(new ItemStack(ItemsTC.clusters, 1, 2), 5.0f, new ItemStack(stack.func_77973_b(), 3, stack.func_77960_j()), new ItemStack(ItemsTC.nuggets, 1, 1));
            }
        }
        if (OreDictionary.getOres((String)"ingotTin").size() > 0) {
            for (ItemStack stack : OreDictionary.getOres((String)"ingotTin")) {
                this.addBlastFurnaceRecipe(new ItemStack(ItemsTC.clusters, 1, 3), 5.0f, new ItemStack(stack.func_77973_b(), 3, stack.func_77960_j()), new ItemStack(ItemsTC.nuggets, 1, 2));
            }
        }
        if (OreDictionary.getOres((String)"ingotSilver").size() > 0) {
            for (ItemStack stack : OreDictionary.getOres((String)"ingotSilver")) {
                this.addBlastFurnaceRecipe(new ItemStack(ItemsTC.clusters, 1, 4), 5.0f, new ItemStack(stack.func_77973_b(), 3, stack.func_77960_j()), new ItemStack(ItemsTC.nuggets, 1, 3));
            }
        }
        if (OreDictionary.getOres((String)"ingotLead").size() > 0) {
            for (ItemStack stack : OreDictionary.getOres((String)"ingotLead")) {
                this.addBlastFurnaceRecipe(new ItemStack(ItemsTC.clusters, 1, 5), 5.0f, new ItemStack(stack.func_77973_b(), 3, stack.func_77960_j()), new ItemStack(ItemsTC.nuggets, 1, 4));
            }
        }
        this.addBlastFurnaceRecipe(new ItemStack(Item.func_150898_a((Block)ModBlocks.ORE_LIGHT)), 5.0f, new ItemStack(ModItems.INGOT_LIGHT));
        this.addBlastFurnaceRecipe(new ItemStack(Item.func_150898_a((Block)ModBlocks.ORE_SHADE)), 5.0f, new ItemStack(ModItems.INGOT_SHADE));
    }

    public void addBlastFurnaceRecipe(ItemStack input, float experience, ItemStack ... output) {
        if (output.length > 0 && !input.func_190926_b()) {
            smeltRecipe r = new smeltRecipe(input, experience, output);
            this.list.add(r);
        }
    }

    public ArrayList<outPut> getWorkResult(ItemStack stack) {
        for (smeltRecipe r : this.list) {
            if (!r.input.func_77969_a(stack)) continue;
            return r.output;
        }
        return null;
    }

    public boolean hasWorkResult(ItemStack stack) {
        for (smeltRecipe r : this.list) {
            if (!stack.func_77969_a(r.input)) continue;
            return true;
        }
        return false;
    }

    private boolean compareItemStacks(ItemStack item1, ItemStack item2) {
        return item2.func_77973_b() == item1.func_77973_b() && (item2.func_77960_j() == Short.MAX_VALUE || item2.func_77960_j() == item1.func_77960_j());
    }

    public ArrayList<smeltRecipe> getWorkingList() {
        return this.list;
    }

    public float getWorkExperience(ItemStack input) {
        for (smeltRecipe r : this.list) {
            if (!input.func_77969_a(r.input)) continue;
            return r.experience;
        }
        return 0.0f;
    }

    public final class outPut {
        public Item item;
        public int meta;
        public int count;

        public outPut(Item item, int meta, int count) {
            this.item = item;
            this.meta = meta;
            this.count = count;
        }
    }

    public final class smeltRecipe {
        public ItemStack input;
        public ArrayList<outPut> output = new ArrayList();
        public float experience;

        public smeltRecipe(ItemStack input, float experience, ItemStack ... output) {
            this.input = input;
            this.experience = experience;
            for (ItemStack s : output) {
                if (!(s instanceof ItemStack)) continue;
                this.output.add(new outPut(s.func_77973_b(), s.func_77960_j(), s.func_190916_E()));
            }
        }
    }
}

