/*
 * Decompiled with CFR 0.152.
 */
package com.ancient.thaumicgadgets.network.gemcutter;

import com.ancient.thaumicgadgets.objects.machines.gemcutter.TileEntityGemCutter;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class MessageServerChoosedAspects
implements IMessage {
    private int id;
    private int x;
    private int y;
    private int z;
    private AspectList aspects = new AspectList();

    public MessageServerChoosedAspects() {
    }

    public MessageServerChoosedAspects(TileEntityGemCutter ent, AspectList aspects) {
        this.id = ent.func_145831_w().field_73011_w.getDimension();
        this.x = ent.func_174877_v().func_177958_n();
        this.y = ent.func_174877_v().func_177956_o();
        this.z = ent.func_174877_v().func_177952_p();
        this.aspects = aspects;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        int q = buf.readInt();
        this.aspects.aspects.clear();
        for (int i = 0; i < q; ++i) {
            this.aspects.add(Aspect.getAspect(ByteBufUtils.readUTF8String((ByteBuf)buf)), buf.readInt());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.aspects.size());
        for (Aspect s : this.aspects.getAspects()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s.getTag());
            buf.writeInt(this.aspects.getAmount(s));
        }
    }

    public static class handler
    implements IMessageHandler<MessageServerChoosedAspects, IMessage> {
        public IMessage onMessage(final MessageServerChoosedAspects message, MessageContext ctx) {
            EntityPlayerMP pl = ctx.getServerHandler().field_147369_b;
            pl.func_71121_q().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    WorldServer world = DimensionManager.getWorld((int)message.id);
                    if (world == null) {
                        return;
                    }
                    TileEntityGemCutter tile = (TileEntityGemCutter)world.func_175625_s(new BlockPos(message.x, message.y, message.z));
                    if (tile != null) {
                        tile.setChoosedAspects(message.aspects);
                    }
                }
            });
            return null;
        }
    }
}

