/*
 * Decompiled with CFR 0.152.
 */
package com.zxc74171.thaumicpotatoes.items;

import com.zxc74171.thaumicpotatoes.entities.EntityAmmo;
import com.zxc74171.thaumicpotatoes.entities.EntityAmmoBaked;
import com.zxc74171.thaumicpotatoes.entities.EntityAmmoNormal;
import com.zxc74171.thaumicpotatoes.entities.EntityAmmoPoisonous;
import com.zxc74171.thaumicpotatoes.items.ItemAmmo;
import com.zxc74171.thaumicpotatoes.potatolauncher.Ammos;
import com.zxc74171.thaumicpotatoes.potatolauncher.LauncherProperties;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLauncher
extends Item {
    public float strength;
    final LauncherProperties material;
    float multiplier;
    Ammos ammo;
    boolean fromStorage;
    int slot;

    public ItemLauncher(String name, CreativeTabs creativeTab, final LauncherProperties material, final float multiplier) {
        this.material = material;
        this.multiplier = multiplier;
        this.ammo = material.ammo;
        this.field_77777_bU = 1;
        this.strength = material.strength * multiplier;
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_77656_e((int)((float)material.durability * multiplier));
        this.func_77637_a(creativeTab);
        this.fromStorage = false;
        this.slot = 0;
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn == null ? 0.0f : (entityIn.func_184607_cu().func_77973_b() instanceof ItemLauncher ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / (material.drawbackSpeed * multiplier) : 0.0f);
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    private ItemStack findAmmo(EntityPlayer player) {
        if (this.isAmmo(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isAmmo(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            this.fromStorage = false;
            if (!this.isAmmo(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    protected boolean isAmmo(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemAmmo) {
            this.ammo = ((ItemAmmo)stack.func_77973_b()).getAmmo();
            return this.ammo.tier <= this.material.tier;
        }
        return false;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            boolean flag = entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack itemstack = this.findAmmo(entityplayer);
            if (this == this) {
                return;
            }
            int i = this.func_77626_a(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)entityplayer, (int)i, (!itemstack.func_190926_b() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if ((!itemstack.func_190926_b() || flag) && itemstack == ItemStack.field_190927_a) {
                itemstack = new ItemStack(this.material.ammo.ammo);
            }
            this.fireAmmo(stack, worldIn, entityplayer, i);
        }
    }

    public float getAmmoVelocity(int charge) {
        float f = (float)charge / (this.material.drawbackSpeed * this.multiplier);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int func_77626_a(ItemStack stack) {
        return 0;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public EntityAmmo selectAmmo(World worldIn, EntityPlayer entityplayer) {
        switch (this.ammo) {
            case NORMAL: {
                return new EntityAmmoNormal(worldIn, (EntityLivingBase)entityplayer, this.ammo);
            }
            case POISONOUS: {
                return new EntityAmmoPoisonous(worldIn, (EntityLivingBase)entityplayer, this.ammo);
            }
            case BAKED: {
                return new EntityAmmoBaked(worldIn, (EntityLivingBase)entityplayer, this.ammo);
            }
        }
        return new EntityAmmoNormal(worldIn, (EntityLivingBase)entityplayer, this.ammo);
    }

    public void fireAmmo(ItemStack stack, World worldIn, EntityPlayer entityplayer, int i) {
        float f;
        ItemStack itemstack = this.findAmmo(entityplayer);
        if (this.fromStorage) {
            ((ItemLauncher)stack.func_77973_b()).writeToNBT(stack.func_77978_p(), this.slot);
        }
        if ((double)(f = this.getAmmoVelocity(i)) >= 0.1) {
            boolean flag1;
            boolean bl = flag1 = entityplayer.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ItemAmmo && ((ItemAmmo)itemstack.func_77973_b()).isInfinite(itemstack, stack, entityplayer);
            if (!worldIn.field_72995_K) {
                int k;
                int j;
                EntityAmmo entityAmmo = this.selectAmmo(worldIn, entityplayer);
                if (f == 1.0f) {
                    entityAmmo.func_70243_d(true);
                }
                if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                    entityAmmo.func_70239_b(entityAmmo.func_70242_d() + (double)j * 0.5 + 0.5);
                }
                if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                    entityAmmo.func_70240_a(k);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                    entityAmmo.func_70015_d(100);
                }
                if (flag1 || entityplayer.field_71075_bZ.field_75098_d) {
                    entityAmmo.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                }
                if (this == this) {
                    entityAmmo.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, f * this.material.strength, 1.0f);
                    worldIn.func_72838_d((Entity)entityAmmo);
                }
            }
            worldIn.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187606_E, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            if (!flag1 && !entityplayer.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
                if (itemstack.func_190926_b()) {
                    entityplayer.field_71071_by.func_184437_d(itemstack);
                }
            }
            entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack crossbow = playerIn.func_184586_b(handIn);
        if (crossbow.func_77973_b() instanceof ItemLauncher) {
            int invSize = 0;
            switch (this.material) {
                default: 
            }
            for (int j = 0; j < invSize; ++j) {
                ItemStack itemStack = ((ItemLauncher)crossbow.func_77973_b()).readFromNBT(crossbow.func_77978_p(), j);
            }
        }
        boolean flag = !this.findAmmo(playerIn).func_190926_b();
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)crossbow, (World)worldIn, (EntityPlayer)playerIn, (EnumHand)handIn, (boolean)flag);
        if (!playerIn.field_71075_bZ.field_75098_d && !flag) {
            return flag ? new ActionResult(EnumActionResult.PASS, (Object)crossbow) : new ActionResult(EnumActionResult.FAIL, (Object)crossbow);
        }
        playerIn.func_184598_c(handIn);
        this.fireAmmo(crossbow, worldIn, playerIn, 72000);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)crossbow);
    }

    public int func_77619_b() {
        return 1;
    }

    public ItemStack readFromNBT(NBTTagCompound compound, int index) {
        if (compound == null) {
            return ItemStack.field_190927_a;
        }
        NBTTagList items = compound.func_150295_c("InventoryCrossbow", 10);
        NBTTagCompound item = items.func_150305_b(index);
        return new ItemStack(item);
    }

    public void writeToNBT(NBTTagCompound tagcompound, int index) {
        NBTTagList items = tagcompound.func_150295_c("InventoryCrossbow", 10);
        NBTTagCompound item = items.func_150305_b(index);
        int currentCount = item.func_74762_e("Count");
        if (currentCount == 1) {
            items.func_74744_a(index);
        } else {
            item.func_74768_a("Count", currentCount - 1);
        }
    }
}

