/*
 * Decompiled with CFR 0.152.
 */
package com.zxc74171.thaumicpotatoes.entities;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.zxc74171.thaumicpotatoes.entities.EntityPotatoMobProjectile;
import com.zxc74171.thaumicpotatoes.init.ModItems;
import com.zxc74171.thaumicpotatoes.sounds.ModSoundEvents;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityZiemniak
extends EntityMob
implements IRangedAttackMob {
    private static final DataParameter<Integer> FIRST_HEAD_TARGET = EntityDataManager.func_187226_a(EntityZiemniak.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SECOND_HEAD_TARGET = EntityDataManager.func_187226_a(EntityZiemniak.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> THIRD_HEAD_TARGET = EntityDataManager.func_187226_a(EntityZiemniak.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer>[] HEAD_TARGETS = new DataParameter[]{FIRST_HEAD_TARGET, SECOND_HEAD_TARGET, THIRD_HEAD_TARGET};
    private static final DataParameter<Integer> INVULNERABILITY_TIME = EntityDataManager.func_187226_a(EntityZiemniak.class, (DataSerializer)DataSerializers.field_187192_b);
    private final float[] xRotationHeads = new float[2];
    private final float[] yRotationHeads = new float[2];
    private final float[] xRotOHeads = new float[2];
    private final float[] yRotOHeads = new float[2];
    private final int[] nextHeadUpdate = new int[2];
    private final int[] idleHeadUpdates = new int[2];
    public int deathTicks;
    private int blockBreakCounter;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);

    public EntityZiemniak(World worldIn) {
        super(worldIn);
        this.func_70606_j(this.func_110138_aP());
        this.field_70178_ae = true;
        this.func_70105_a(0.9f, 3.5f);
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70728_aV = 500;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIDoNothing());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 40, 20.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FIRST_HEAD_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(SECOND_HEAD_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(THIRD_HEAD_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(INVULNERABILITY_TIME, (Object)0);
    }

    public static void registerFixesWither(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityZiemniak.class);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Invul", this.getInvulTime());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setInvulTime(compound.func_74762_e("Invul"));
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    protected SoundEvent func_184639_G() {
        return ModSoundEvents.ENTITY_ZIEMNIAK_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ModSoundEvents.ENTITY_ZIEMNIAK_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSoundEvents.ENTITY_ZIEMNIAK_DEATH;
    }

    public void func_70636_d() {
        Entity entity;
        this.field_70181_x *= (double)0.6f;
        if (!this.field_70170_p.field_72995_K && this.getWatchedTargetId(0) > 0 && (entity = this.field_70170_p.func_73045_a(this.getWatchedTargetId(0))) != null) {
            double d1;
            double d0;
            double d3;
            if (this.field_70163_u < entity.field_70163_u || !this.isArmored() && this.field_70163_u < entity.field_70163_u + 5.0) {
                if (this.field_70181_x < 0.0) {
                    this.field_70181_x = 0.0;
                }
                this.field_70181_x += (0.5 - this.field_70181_x) * (double)0.6f;
            }
            if ((d3 = (d0 = entity.field_70165_t - this.field_70165_t) * d0 + (d1 = entity.field_70161_v - this.field_70161_v) * d1) > 9.0) {
                double d5 = MathHelper.func_76133_a((double)d3);
                this.field_70159_w += (d0 / d5 * 0.5 - this.field_70159_w) * (double)0.6f;
                this.field_70179_y += (d1 / d5 * 0.5 - this.field_70179_y) * (double)0.6f;
            }
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > (double)0.05f) {
            this.field_70177_z = (float)MathHelper.func_181159_b((double)this.field_70179_y, (double)this.field_70159_w) * 57.295776f - 90.0f;
        }
        super.func_70636_d();
        for (int i = 0; i < 2; ++i) {
            this.yRotOHeads[i] = this.yRotationHeads[i];
            this.xRotOHeads[i] = this.xRotationHeads[i];
        }
        for (int j = 0; j < 2; ++j) {
            int k = this.getWatchedTargetId(j + 1);
            Entity entity1 = null;
            if (k > 0) {
                entity1 = this.field_70170_p.func_73045_a(k);
            }
            if (entity1 != null) {
                double d11 = this.getHeadX(j + 1);
                double d12 = this.getHeadY(j + 1);
                double d13 = this.getHeadZ(j + 1);
                double d6 = entity1.field_70165_t - d11;
                double d7 = entity1.field_70163_u + (double)entity1.func_70047_e() - d12;
                double d8 = entity1.field_70161_v - d13;
                double d9 = MathHelper.func_76133_a((double)(d6 * d6 + d8 * d8));
                float f = (float)(MathHelper.func_181159_b((double)d8, (double)d6) * 57.29577951308232) - 90.0f;
                float f1 = (float)(-(MathHelper.func_181159_b((double)d7, (double)d9) * 57.29577951308232));
                this.xRotationHeads[j] = this.rotlerp(this.xRotationHeads[j], f1, 40.0f);
                this.yRotationHeads[j] = this.rotlerp(this.yRotationHeads[j], f, 10.0f);
                continue;
            }
            this.yRotationHeads[j] = this.rotlerp(this.yRotationHeads[j], this.field_70761_aq, 10.0f);
        }
        boolean flag = this.isArmored();
        for (int l = 0; l < 3; ++l) {
            double d10 = this.getHeadX(l);
            double d2 = this.getHeadY(l);
            double d4 = this.getHeadZ(l);
            this.field_70170_p.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * (double)0.3f, 0.0, 0.0, 0.0, new int[0]);
            if (!flag || this.field_70170_p.field_73012_v.nextInt(4) != 0) continue;
            this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * (double)0.3f, (double)0.7f, (double)0.7f, 0.5, new int[0]);
        }
        if (this.getInvulTime() > 0) {
            for (int i1 = 0; i1 < 3; ++i1) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + this.field_70146_Z.nextGaussian(), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian(), (double)0.7f, (double)0.7f, (double)0.9f, new int[0]);
            }
        }
    }

    protected void func_70619_bc() {
        if (this.getInvulTime() > 0) {
            int j1 = this.getInvulTime() - 1;
            if (j1 <= 0) {
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 7.0f, false, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                this.field_70170_p.func_175669_a(1023, new BlockPos((Entity)this), 0);
            }
            this.setInvulTime(j1);
            if (this.field_70173_aa % 10 == 0) {
                this.func_70691_i(10.0f);
            }
        } else {
            super.func_70619_bc();
            block0: for (int i = 1; i < 3; ++i) {
                int k1;
                if (this.field_70173_aa < this.nextHeadUpdate[i - 1]) continue;
                this.nextHeadUpdate[i - 1] = this.field_70173_aa + 10 + this.field_70146_Z.nextInt(10);
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    int j3 = i - 1;
                    int k3 = this.idleHeadUpdates[i - 1];
                    this.idleHeadUpdates[j3] = this.idleHeadUpdates[i - 1] + 1;
                    if (k3 > 15) {
                        float f = 10.0f;
                        float f1 = 5.0f;
                        double d0 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70165_t - 10.0), (double)(this.field_70165_t + 10.0));
                        double d1 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70163_u - 5.0), (double)(this.field_70163_u + 5.0));
                        double d2 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70161_v - 10.0), (double)(this.field_70161_v + 10.0));
                        this.launchPotatoToCoords(i + 1, d0, d1, d2, true);
                        this.idleHeadUpdates[i - 1] = 0;
                    }
                }
                if ((k1 = this.getWatchedTargetId(i)) > 0) {
                    Entity entity = this.field_70170_p.func_73045_a(k1);
                    if (entity != null && entity.func_70089_S() && this.func_70068_e(entity) <= 900.0 && this.func_70685_l(entity)) {
                        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75102_a) {
                            this.updateWatchedTargetId(i, 0);
                            continue;
                        }
                        this.launchPotatoToEntity(i + 1, (EntityLivingBase)entity);
                        this.nextHeadUpdate[i - 1] = this.field_70173_aa + 40 + this.field_70146_Z.nextInt(20);
                        this.idleHeadUpdates[i - 1] = 0;
                        continue;
                    }
                    this.updateWatchedTargetId(i, 0);
                    continue;
                }
                List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(20.0, 8.0, 20.0), Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d}));
                for (int j2 = 0; j2 < 10 && !list.isEmpty(); ++j2) {
                    EntityLivingBase entitylivingbase = (EntityLivingBase)list.get(this.field_70146_Z.nextInt(list.size()));
                    if (entitylivingbase != this && entitylivingbase.func_70089_S() && this.func_70685_l((Entity)entitylivingbase)) {
                        if (entitylivingbase instanceof EntityPlayer) {
                            if (((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) continue block0;
                            this.updateWatchedTargetId(i, entitylivingbase.func_145782_y());
                            continue block0;
                        }
                        this.updateWatchedTargetId(i, entitylivingbase.func_145782_y());
                        continue block0;
                    }
                    list.remove(entitylivingbase);
                }
            }
            if (this.func_70638_az() != null) {
                this.updateWatchedTargetId(0, this.func_70638_az().func_145782_y());
            } else {
                this.updateWatchedTargetId(0, 0);
            }
            if (this.blockBreakCounter > 0) {
                --this.blockBreakCounter;
                if (this.blockBreakCounter == 0 && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                    int i1 = MathHelper.func_76128_c((double)this.field_70163_u);
                    int l1 = MathHelper.func_76128_c((double)this.field_70165_t);
                    int i2 = MathHelper.func_76128_c((double)this.field_70161_v);
                    boolean flag = false;
                    for (int k2 = -1; k2 <= 1; ++k2) {
                        for (int l2 = -1; l2 <= 1; ++l2) {
                            for (int j = 0; j <= 3; ++j) {
                                int i3 = l1 + k2;
                                int k = i1 + j;
                                int l = i2 + l2;
                                BlockPos blockpos = new BlockPos(i3, k, l);
                                IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                                Block block = iblockstate.func_177230_c();
                                if (block.isAir(iblockstate, (IBlockAccess)this.field_70170_p, blockpos) || !block.canEntityDestroy(iblockstate, (IBlockAccess)this.field_70170_p, blockpos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this, (BlockPos)blockpos, (IBlockState)iblockstate)) continue;
                                flag = this.field_70170_p.func_175655_b(blockpos, true) || flag;
                            }
                        }
                    }
                    if (flag) {
                        this.field_70170_p.func_180498_a((EntityPlayer)null, 1022, new BlockPos((Entity)this), 0);
                    }
                }
            }
            if (this.field_70173_aa % 20 == 0) {
                this.func_70691_i(1.0f);
            }
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
    }

    public static boolean canDestroyBlock(Block blockIn) {
        return blockIn != Blocks.field_150357_h && blockIn != Blocks.field_150384_bq && blockIn != Blocks.field_150378_br && blockIn != Blocks.field_150483_bI && blockIn != Blocks.field_185776_dc && blockIn != Blocks.field_185777_dd && blockIn != Blocks.field_180401_cv && blockIn != Blocks.field_185779_df && blockIn != Blocks.field_189881_dj && blockIn != Blocks.field_180384_M && blockIn != Blocks.field_185775_db;
    }

    protected void func_70609_aI() {
        ++this.deathTicks;
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
        }
        boolean flag = this.field_70170_p.func_82736_K().func_82766_b("doMobLoot");
        int i = 500;
        if (!this.field_70170_p.field_72995_K) {
            if (this.deathTicks <= 150 || this.deathTicks % 5 != 0 || flag) {
                // empty if block
            }
            if (this.deathTicks == 1) {
                this.field_70170_p.func_175669_a(1023, new BlockPos((Entity)this), 0);
            }
        }
        this.func_70091_d(MoverType.SELF, 0.0, 0.1f, 0.0);
        this.field_70177_z += 20.0f;
        this.field_70761_aq = this.field_70177_z;
        if (this.deathTicks == 200 && !this.field_70170_p.field_72995_K) {
            if (flag) {
                // empty if block
            }
            this.func_70106_y();
        }
    }

    public void ignite() {
        this.setInvulTime(220);
        this.func_70606_j(this.func_110138_aP() / 3.0f);
    }

    public void func_70110_aj() {
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    private double getHeadX(int p_82214_1_) {
        if (p_82214_1_ <= 0) {
            return this.field_70165_t;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82214_1_ - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76134_b((float)f);
        return this.field_70165_t + (double)f1 * 1.3;
    }

    private double getHeadY(int p_82208_1_) {
        return p_82208_1_ <= 0 ? this.field_70163_u + 3.0 : this.field_70163_u + 2.2;
    }

    private double getHeadZ(int p_82213_1_) {
        if (p_82213_1_ <= 0) {
            return this.field_70161_v;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82213_1_ - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76126_a((float)f);
        return this.field_70161_v + (double)f1 * 1.3;
    }

    private float rotlerp(float p_82204_1_, float p_82204_2_, float p_82204_3_) {
        float f = MathHelper.func_76142_g((float)(p_82204_2_ - p_82204_1_));
        if (f > p_82204_3_) {
            f = p_82204_3_;
        }
        if (f < -p_82204_3_) {
            f = -p_82204_3_;
        }
        return p_82204_1_ + f;
    }

    private void launchPotatoToEntity(int p_82216_1_, EntityLivingBase p_82216_2_) {
        this.launchPotatoToCoords(p_82216_1_, p_82216_2_.field_70165_t, p_82216_2_.field_70163_u + (double)p_82216_2_.func_70047_e() * 0.5, p_82216_2_.field_70161_v, p_82216_1_ == 0 && this.field_70146_Z.nextFloat() < 0.001f);
    }

    private void launchPotatoToCoords(int p_82209_1_, double x, double y, double z, boolean invulnerable) {
        this.field_70170_p.func_180498_a((EntityPlayer)null, 1024, new BlockPos((Entity)this), 0);
        double d0 = this.getHeadX(p_82209_1_);
        double d1 = this.getHeadY(p_82209_1_);
        double d2 = this.getHeadZ(p_82209_1_);
        double d3 = x - d0;
        double d4 = y - d1;
        double d5 = z - d2;
        EntityPotatoMobProjectile entitypotatomobprojectile = new EntityPotatoMobProjectile(this.field_70170_p, (EntityLivingBase)this, d3, d4, d5);
        if (invulnerable) {
            entitypotatomobprojectile.setInvulnerable(true);
        }
        entitypotatomobprojectile.field_70163_u = d1;
        entitypotatomobprojectile.field_70165_t = d0;
        entitypotatomobprojectile.field_70161_v = d2;
        this.field_70170_p.func_72838_d((Entity)entitypotatomobprojectile);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        this.launchPotatoToEntity(0, target);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source != DamageSource.field_76369_e && !(source.func_76346_g() instanceof EntityZiemniak)) {
            Entity entity;
            if (this.getInvulTime() > 0 && source != DamageSource.field_76380_i) {
                return false;
            }
            if (this.isArmored() && (entity = source.func_76364_f()) instanceof EntityArrow) {
                return false;
            }
            Entity entity1 = source.func_76346_g();
            if (entity1 != null && !(entity1 instanceof EntityPlayer) && entity1 instanceof EntityLivingBase && ((EntityLivingBase)entity1).func_70668_bt() == this.func_70668_bt()) {
                return false;
            }
            if (this.blockBreakCounter <= 0) {
                this.blockBreakCounter = 20;
            }
            int i = 0;
            while (i < this.idleHeadUpdates.length) {
                int n = i++;
                this.idleHeadUpdates[n] = this.idleHeadUpdates[n] + 3;
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        EntityItem entityitem = this.func_145779_a(ModItems.ELDRITCH_BLOOD, 1);
        if (entityitem != null) {
            entityitem.func_174873_u();
        }
    }

    protected void func_70623_bb() {
        this.field_70708_bq = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70690_d(PotionEffect potioneffectIn) {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.7);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadYRotation(int p_82207_1_) {
        return this.yRotationHeads[p_82207_1_];
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadXRotation(int p_82210_1_) {
        return this.xRotationHeads[p_82210_1_];
    }

    public int getInvulTime() {
        return (Integer)this.field_70180_af.func_187225_a(INVULNERABILITY_TIME);
    }

    public void setInvulTime(int time) {
        this.field_70180_af.func_187227_b(INVULNERABILITY_TIME, (Object)time);
    }

    public int getWatchedTargetId(int head) {
        return (Integer)this.field_70180_af.func_187225_a(HEAD_TARGETS[head]);
    }

    public void updateWatchedTargetId(int targetOffset, int newId) {
        this.field_70180_af.func_187227_b(HEAD_TARGETS[targetOffset], (Object)newId);
    }

    public boolean isArmored() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 2.0f;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_184724_a(boolean swingingArms) {
    }

    class AIDoNothing
    extends EntityAIBase {
        public AIDoNothing() {
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            return EntityZiemniak.this.getInvulTime() > 0;
        }
    }
}

