/*
 * Decompiled with CFR 0.152.
 */
package com.zxc74171.thaumicpotatoes.entities;

import com.zxc74171.thaumicpotatoes.init.ModItems;
import com.zxc74171.thaumicpotatoes.sounds.ModSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFrenchFries
extends EntityMob {
    protected static final DataParameter<Byte> VEX_FLAGS = EntityDataManager.func_187226_a(EntityFrenchFries.class, (DataSerializer)DataSerializers.field_187191_a);
    private EntityLiving owner;
    @Nullable
    private BlockPos boundOrigin;
    private boolean limitedLifespan;
    private int limitedLifeTicks;

    public EntityFrenchFries(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
        this.field_70765_h = new AIMoveControl(this);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70728_aV = 3;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        this.func_145775_I();
    }

    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
        this.func_189654_d(true);
        if (this.limitedLifespan && --this.limitedLifeTicks <= 0) {
            this.limitedLifeTicks = 20;
            this.func_70097_a(DamageSource.field_76366_f, 1.0f);
        }
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIChargeAttack());
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityFrenchFries.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AICopyOwnerTarget((EntityCreature)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(14.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VEX_FLAGS, (Object)0);
    }

    public static void registerFixesVex(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityFrenchFries.class);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("BoundX")) {
            this.boundOrigin = new BlockPos(compound.func_74762_e("BoundX"), compound.func_74762_e("BoundY"), compound.func_74762_e("BoundZ"));
        }
        if (compound.func_74764_b("LifeTicks")) {
            this.setLimitedLife(compound.func_74762_e("LifeTicks"));
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.boundOrigin != null) {
            compound.func_74768_a("BoundX", this.boundOrigin.func_177958_n());
            compound.func_74768_a("BoundY", this.boundOrigin.func_177956_o());
            compound.func_74768_a("BoundZ", this.boundOrigin.func_177952_p());
        }
        if (this.limitedLifespan) {
            compound.func_74768_a("LifeTicks", this.limitedLifeTicks);
        }
    }

    public EntityLiving getOwner() {
        return this.owner;
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos boundOriginIn) {
        this.boundOrigin = boundOriginIn;
    }

    private boolean getVexFlag(int p_190656_1_) {
        byte i = (Byte)this.field_70180_af.func_187225_a(VEX_FLAGS);
        return (i & p_190656_1_) != 0;
    }

    private void setVexFlag(int p_190660_1_, boolean p_190660_2_) {
        int i = ((Byte)this.field_70180_af.func_187225_a(VEX_FLAGS)).byteValue();
        i = p_190660_2_ ? (i |= p_190660_1_) : (i &= ~p_190660_1_);
        this.field_70180_af.func_187227_b(VEX_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.getVexFlag(1);
    }

    public void setIsCharging(boolean p_190648_1_) {
        this.setVexFlag(1, p_190648_1_);
    }

    public void setOwner(EntityLiving ownerIn) {
        this.owner = ownerIn;
    }

    public void setLimitedLife(int limitedLifeTicksIn) {
        this.limitedLifespan = true;
        this.limitedLifeTicks = limitedLifeTicksIn;
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        EntityItem entityitem = this.func_145779_a(ModItems.FRENCHFRIES, 2);
        if (entityitem != null) {
            entityitem.func_174873_u();
        }
    }

    protected SoundEvent func_184639_G() {
        return ModSoundEvents.ENTITY_FRIES_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ModSoundEvents.ENTITY_FRIES_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSoundEvents.ENTITY_FRIES_DEATH;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        return super.func_180482_a(difficulty, livingdata);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
        this.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
    }

    class AIMoveRandom
    extends EntityAIBase {
        public AIMoveRandom() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !EntityFrenchFries.this.func_70605_aq().func_75640_a() && EntityFrenchFries.this.field_70146_Z.nextInt(7) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = EntityFrenchFries.this.getBoundOrigin();
            if (blockpos == null) {
                blockpos = new BlockPos((Entity)EntityFrenchFries.this);
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityFrenchFries.this.field_70146_Z.nextInt(15) - 7, EntityFrenchFries.this.field_70146_Z.nextInt(11) - 5, EntityFrenchFries.this.field_70146_Z.nextInt(15) - 7);
                if (!EntityFrenchFries.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityFrenchFries.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25);
                if (EntityFrenchFries.this.func_70638_az() != null) break;
                EntityFrenchFries.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityFrenchFries vex) {
            super((EntityLiving)vex);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityFrenchFries.this.field_70165_t;
                double d1 = this.field_75647_c - EntityFrenchFries.this.field_70163_u;
                double d2 = this.field_75644_d - EntityFrenchFries.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityFrenchFries.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityFrenchFries.this.field_70159_w *= 0.5;
                    EntityFrenchFries.this.field_70181_x *= 0.5;
                    EntityFrenchFries.this.field_70179_y *= 0.5;
                } else {
                    EntityFrenchFries.this.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    EntityFrenchFries.this.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    EntityFrenchFries.this.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (EntityFrenchFries.this.func_70638_az() == null) {
                        EntityFrenchFries.this.field_70761_aq = EntityFrenchFries.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityFrenchFries.this.field_70159_w, (double)EntityFrenchFries.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityFrenchFries.this.func_70638_az().field_70165_t - EntityFrenchFries.this.field_70165_t;
                        double d5 = EntityFrenchFries.this.func_70638_az().field_70161_v - EntityFrenchFries.this.field_70161_v;
                        EntityFrenchFries.this.field_70761_aq = EntityFrenchFries.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }

    class AICopyOwnerTarget
    extends EntityAITarget {
        public AICopyOwnerTarget(EntityCreature creature) {
            super(creature, false);
        }

        public boolean func_75250_a() {
            return EntityFrenchFries.this.owner != null && EntityFrenchFries.this.owner.func_70638_az() != null && this.func_75296_a(EntityFrenchFries.this.owner.func_70638_az(), false);
        }

        public void func_75249_e() {
            EntityFrenchFries.this.func_70624_b(EntityFrenchFries.this.owner.func_70638_az());
            super.func_75249_e();
        }
    }

    class AIChargeAttack
    extends EntityAIBase {
        public AIChargeAttack() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (EntityFrenchFries.this.func_70638_az() != null && !EntityFrenchFries.this.func_70605_aq().func_75640_a() && EntityFrenchFries.this.field_70146_Z.nextInt(7) == 0) {
                return EntityFrenchFries.this.func_70068_e((Entity)EntityFrenchFries.this.func_70638_az()) > 4.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return EntityFrenchFries.this.func_70605_aq().func_75640_a() && EntityFrenchFries.this.isCharging() && EntityFrenchFries.this.func_70638_az() != null && EntityFrenchFries.this.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            EntityLivingBase entitylivingbase = EntityFrenchFries.this.func_70638_az();
            Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
            EntityFrenchFries.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
            EntityFrenchFries.this.setIsCharging(true);
            EntityFrenchFries.this.func_184185_a(ModSoundEvents.MCDONALD, 1.0f, 1.0f);
        }

        public void func_75251_c() {
            EntityFrenchFries.this.setIsCharging(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = EntityFrenchFries.this.func_70638_az();
            if (EntityFrenchFries.this.func_174813_aQ().func_72326_a(entitylivingbase.func_174813_aQ())) {
                EntityFrenchFries.this.func_70652_k((Entity)entitylivingbase);
                EntityFrenchFries.this.setIsCharging(false);
            } else {
                double d0 = EntityFrenchFries.this.func_70068_e((Entity)entitylivingbase);
                if (d0 < 9.0) {
                    Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
                    EntityFrenchFries.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
                }
            }
        }
    }
}

