/*
 * Decompiled with CFR 0.152.
 */
package com.zxc74171.thaumicpotatoes.backpack;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class InventoryBackpack
implements IInventory {
    private ItemStack backpack;
    private EntityPlayer player;
    private ItemStack[] inventory;

    public InventoryBackpack(EntityPlayer player, ItemStack backpack) {
        this.backpack = backpack;
        this.player = player;
        this.inventory = new ItemStack[this.func_70302_i_()];
        this.readFromNBT();
    }

    public ItemStack getRucksack() {
        return this.backpack;
    }

    public void writeToNBT() {
        int i;
        if (this.player.field_70170_p.field_72995_K) {
            return;
        }
        NBTTagCompound nbtTagCompound = this.backpack.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
            this.backpack.func_77982_d(nbtTagCompound);
        }
        NBTTagList tagList = new NBTTagList();
        for (i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound itemStackTag = new NBTTagCompound();
            itemStackTag.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(itemStackTag);
            tagList.func_74742_a((NBTBase)itemStackTag);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)tagList);
        this.backpack.func_77982_d(nbtTagCompound);
        for (i = -1; i < this.player.field_71071_by.func_70302_i_(); ++i) {
            NBTTagCompound stackNBT;
            ItemStack currentStack = i == -1 ? this.player.field_71071_by.func_70445_o() : this.player.field_71071_by.func_70301_a(i);
            if (currentStack.func_190926_b() || (stackNBT = currentStack.func_77978_p()) == null || this.backpack.func_77978_p().func_74762_e("cid") != stackNBT.func_74762_e("cid")) continue;
            this.backpack.func_190920_e(1);
            if (i == -1) {
                this.player.field_71071_by.func_70437_b(this.backpack);
                break;
            }
            this.player.field_71071_by.func_70299_a(i, this.backpack);
            break;
        }
    }

    public void readFromNBT() {
        if (this.player.field_70170_p.field_72995_K) {
            return;
        }
        NBTTagCompound nbtTagCompound = this.backpack.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
            this.backpack.func_77982_d(nbtTagCompound);
        }
        if (!nbtTagCompound.func_74764_b("Items")) {
            nbtTagCompound.func_74782_a("Items", (NBTBase)new NBTTagList());
        }
        nbtTagCompound.func_74768_a("cid", new Random().nextInt());
        NBTTagList tagList = nbtTagCompound.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemStackTag = tagList.func_150305_b(i);
            byte itemSlot = itemStackTag.func_74771_c("Slot");
            if (itemSlot < 0 || itemSlot >= this.inventory.length) continue;
            this.inventory[itemSlot] = new ItemStack(itemStackTag);
        }
    }

    public int func_70302_i_() {
        return 27;
    }

    public boolean func_191420_l() {
        return false;
    }

    public ItemStack func_70301_a(int slotIndex) {
        return slotIndex < 0 || slotIndex >= this.func_70302_i_() ? ItemStack.field_190927_a : (this.inventory[slotIndex] == null ? ItemStack.field_190927_a : this.inventory[slotIndex]);
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        if (slotIndex < 0 || slotIndex >= this.func_70302_i_()) {
            return ItemStack.field_190927_a;
        }
        if (this.inventory[slotIndex] != null && !this.inventory[slotIndex].func_190926_b()) {
            if (this.inventory[slotIndex].func_190916_E() <= amount) {
                ItemStack output = this.inventory[slotIndex];
                this.inventory[slotIndex] = ItemStack.field_190927_a;
                return output;
            }
            ItemStack output = this.inventory[slotIndex].func_77979_a(amount);
            if (this.inventory[slotIndex].func_190926_b()) {
                this.inventory[slotIndex] = ItemStack.field_190927_a;
            }
            return output;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= this.func_70302_i_()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = null;
        if (this.inventory[slotIndex] != null && !this.inventory[slotIndex].func_190926_b()) {
            stack = this.inventory[slotIndex];
            this.inventory[slotIndex] = ItemStack.field_190927_a;
        }
        return stack == null ? ItemStack.field_190927_a : stack;
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        if (slotIndex < 0 || slotIndex >= this.func_70302_i_()) {
            return;
        }
        this.inventory[slotIndex] = itemStack;
        if (itemStack != null && itemStack != ItemStack.field_190927_a && itemStack.func_190916_E() > this.func_70297_j_()) {
            itemStack.func_190920_e(this.func_70297_j_());
        }
        if (itemStack != null && itemStack != ItemStack.field_190927_a && itemStack.func_190926_b()) {
            this.inventory[slotIndex] = ItemStack.field_190927_a;
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return true;
    }

    public void func_174889_b(EntityPlayer entityPlayer) {
    }

    public void func_174886_c(EntityPlayer entityPlayer) {
        this.writeToNBT();
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return itemStack != this.backpack;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = ItemStack.field_190927_a;
        }
    }

    public String func_70005_c_() {
        return this.backpack.func_77973_b().func_77653_i(this.backpack);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }
}

