/*
 * Decompiled with CFR 0.152.
 */
package com.zxc74171.thaumicpotatoes;

import com.zxc74171.thaumicpotatoes.handlers.FuelHandler;
import com.zxc74171.thaumicpotatoes.handlers.GuiHandler;
import com.zxc74171.thaumicpotatoes.handlers.SmeltingHandler;
import com.zxc74171.thaumicpotatoes.init.ModBlocks;
import com.zxc74171.thaumicpotatoes.init.ModItems;
import com.zxc74171.thaumicpotatoes.oredict.OreDict;
import com.zxc74171.thaumicpotatoes.proxy.CommonProxy;
import com.zxc74171.thaumicpotatoes.util.Utils;
import com.zxc74171.thaumicpotatoes.villager.InitVillager;
import com.zxc74171.thaumicpotatoes.worldgen.TP2WorldGen;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(dependencies="required-before:guideapi", modid="thaumicpotatoes", name="Thaumic Potatoes 2", version="1.4.1", acceptedMinecraftVersions="[1.12.2]")
public class ThaumicPotatoes2 {
    @Mod.Instance(value="thaumicpotatoes")
    public static ThaumicPotatoes2 instance;
    public static ModBlocks blocks;
    @SidedProxy(serverSide="com.zxc74171.thaumicpotatoes.proxy.CommonProxy", clientSide="com.zxc74171.thaumicpotatoes.proxy.ClientProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        new ModItems();
        SmeltingHandler.registerSmeltingRecipes();
        MinecraftForge.EVENT_BUS.register((Object)new EventBus());
        proxy.preInit(event);
        Utils.getLogger().info("TP2 PreInitialize");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerFuelHandler((IFuelHandler)new FuelHandler());
        GameRegistry.registerWorldGenerator((IWorldGenerator)new TP2WorldGen(), (int)0);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        OreDict.init();
        Utils.getLogger().info("TP2 Initialize");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Utils.getLogger().info("TP2 PostInitialize");
    }

    static {
        blocks = new ModBlocks();
    }

    @Mod.EventBusSubscriber
    public static class EventBus {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{ThaumicPotatoes2.blocks.POTATOORE, ThaumicPotatoes2.blocks.POTATOBRICK});
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{ThaumicPotatoes2.blocks.POTATOORE.createItemBlock(), ThaumicPotatoes2.blocks.POTATOBRICK.createItemBlock()});
            event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.ITEMS);
        }

        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            ThaumicPotatoes2.blocks.POTATOORE.initItemModel();
            ThaumicPotatoes2.blocks.POTATOBRICK.initItemModel();
            for (int i = 0; i < ModItems.ITEMS.length; ++i) {
                Item item = ModItems.ITEMS[i];
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
            }
        }

        @SubscribeEvent
        public void onVillagerRegistry(RegistryEvent.Register<VillagerRegistry.VillagerProfession> event) {
            InitVillager.init();
            event.getRegistry().register((IForgeRegistryEntry)InitVillager.potatoProfession);
        }
    }
}

