/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.common;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.function.BooleanSupplier;
import knightminer.tcomplement.TinkersComplement;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.common.crafting.JsonContext;
import slimeknights.mantle.pulsar.config.ForgeCFG;

@net.minecraftforge.common.config.Config(modid="tcomplement", category="")
public class Config {
    @Config.Ignore
    public static ForgeCFG pulseConfig = new ForgeCFG("TComplementModules", "Modules");
    @Config.Comment(value={"General configuration options"})
    @Config.LangKey(value="tcomplement.config.general")
    public static General general = new General();
    @Config.Comment(value={"Options to configure the melter"})
    @Config.LangKey(value="tcomplement.config.melter")
    public static Melter melter = new Melter();
    @Config.Comment(value={"Options to configure JEI integration"})
    @Config.LangKey(value="tcomplement.config.jei")
    public static JEI jei = new JEI();

    public static class PulseLoaded
    implements IConditionFactory {
        public BooleanSupplier parse(JsonContext context, JsonObject json) {
            String pulse = JsonUtils.func_151200_h((JsonObject)json, (String)"pulse");
            return () -> TinkersComplement.pulseManager.isPulseLoaded(pulse);
        }
    }

    public static class ConfigProperty
    implements IConditionFactory {
        public BooleanSupplier parse(JsonContext context, JsonObject json) {
            String option = JsonUtils.func_151200_h((JsonObject)json, (String)"option");
            return () -> {
                switch (option) {
                    case "bucket_cast": {
                        return Config.general.bucketCast;
                    }
                }
                throw new JsonSyntaxException("Config option '" + option + "' does not exist");
            };
        }
    }

    public static class JEI {
        @Config.RequiresMcRestart
        @Config.Comment(value={"If true, puts the melter in its own recipe tab in JEI to make the blacklist and overrides more clear.", "If false, the melter is just added to the normal Tinkers tab."})
        @Config.LangKey(value="tcomplement.config.jei.separateMelterTab")
        public boolean separateMelterTab = true;
    }

    public static class Melter {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Ratio of ore to material produced in the melter."})
        @Config.RangeDouble(min=0.0, max=16.0)
        @Config.LangKey(value="tcomplement.config.melter.oreToIngotRatio")
        public double oreToIngotRatio = 1.0;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Disallows creating seared stone in the melter using cobblestone or tool parts."})
        @Config.LangKey(value="tcomplement.config.melter.blacklistStone")
        public boolean blacklistStone = true;
    }

    public static class General {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Enables the bucket cast: allows casting buckets using a casting table."})
        @Config.LangKey(value="tcomplement.config.general.bucketCast")
        public boolean bucketCast = true;
    }
}

