/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.registry;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.projectintelligence.api.IGuiDocHandler;
import com.brandon3055.projectintelligence.api.IGuiDocRegistry;
import com.brandon3055.projectintelligence.api.IPageSupplier;
import com.brandon3055.projectintelligence.registry.DefaultHandlerImpl;
import com.brandon3055.projectintelligence.utils.LogHelper;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;

public class GuiDocRegistry
implements IGuiDocRegistry {
    public static final GuiDocRegistry INSTANCE = new GuiDocRegistry();
    private IGuiDocHandler<GuiScreen> DEFAULT_HANDLER = new DefaultHandlerImpl();
    private Map<Class<? extends GuiScreen>, IGuiDocHandler> guiHandlerMap = new HashMap<Class<? extends GuiScreen>, IGuiDocHandler>();
    private Map<Class<? extends GuiScreen>, List<IPageSupplier>> pageSupplierMap = new HashMap<Class<? extends GuiScreen>, List<IPageSupplier>>();

    @Override
    public boolean hasGuiHandler(Class<? extends GuiScreen> guiClass) {
        return this.guiHandlerMap.containsKey(guiClass);
    }

    @Override
    public <T extends GuiScreen> void registerGuiHandler(Class<T> guiClass, IGuiDocHandler<T> handler) {
        if (guiClass == GuiContainer.class || guiClass == GuiScreen.class) {
            throw new UnsupportedOperationException("You can not assign a gui handler to any of the base gui classes!");
        }
        if (this.guiHandlerMap.containsKey(guiClass)) {
            LogHelper.warn("Overwriting existing gui handler for " + guiClass.getName() + ". Old: " + this.guiHandlerMap.get(guiClass).getClass().getName() + " -> Replaced by: " + handler.getClass().getName());
        }
        this.guiHandlerMap.put(guiClass, handler);
    }

    @Override
    public <T extends GuiScreen> void registerGuiDocPages(Class<T> guiClass, String ... pageURI) {
        this.registerGuiDocPages(guiClass, Arrays.asList(pageURI));
    }

    @Override
    public <T extends GuiScreen> void registerGuiDocPages(Class<T> guiClass, Collection<String> pageURIs) {
        this.registerGuiDocPages(guiClass, new StrictPageSupplier(guiClass, pageURIs));
    }

    @Override
    public <T extends GuiScreen> void registerGuiDocPages(Class<T> guiClass, IPageSupplier<T> pageSupplier) {
        this.pageSupplierMap.computeIfAbsent(guiClass, c -> new ArrayList()).add(pageSupplier);
    }

    public boolean doesGuiHaveDoc(GuiScreen screen) {
        return !this.getPagesFor(screen).isEmpty();
    }

    public GuiDocHelper getDocHelper(GuiScreen screen) {
        IGuiDocHandler handler = this.getBestHandlerFor(screen);
        List<String> pages = this.getPagesFor(screen);
        return new GuiDocHelper(screen, pages, handler);
    }

    private IGuiDocHandler getBestHandlerFor(GuiScreen screen) {
        for (Class<?> clazz = screen.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            IGuiDocHandler handler = this.guiHandlerMap.get(clazz);
            if (handler == null) continue;
            return handler;
        }
        if (!(screen instanceof GuiContainer)) {
            LogHelper.warn("Using default IGuiDocHandler for GuiScreen: " + screen.getClass().getName() + ". Default handler works best with GuiContainer's please consider adding a custom IGuiDocHandler for your screen.");
        }
        return this.DEFAULT_HANDLER;
    }

    private List<String> getPagesFor(GuiScreen screen) {
        ArrayList<String> pages = new ArrayList<String>();
        for (Class<?> clazz = screen.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            List<IPageSupplier> list = this.pageSupplierMap.get(clazz);
            if (list == null) continue;
            for (IPageSupplier supplier : list) {
                if (!supplier.hasPages(screen)) continue;
                DataUtils.addIf(supplier.getPageURIs(screen), pages, s -> !pages.contains(s));
            }
        }
        return pages;
    }

    private static class StrictPageSupplier<T extends GuiScreen>
    implements IPageSupplier<T> {
        private Class<T> guiClass;
        private Collection<String> pageURIs;

        private StrictPageSupplier(Class<T> guiClass, Collection<String> pageURIs) {
            this.guiClass = guiClass;
            this.pageURIs = pageURIs;
        }

        @Override
        public Collection<String> getPageURIs(T gui) {
            return this.pageURIs;
        }

        @Override
        public boolean hasPages(T gui) {
            return gui.getClass() == this.guiClass;
        }
    }

    public static class GuiDocHelper {
        public final IGuiDocHandler docHandler;
        private GuiScreen gui;
        private List<String> pages;
        private static Map<Class<? extends GuiScreen>, Boolean> docVisible = new HashMap<Class<? extends GuiScreen>, Boolean>();
        private static Map<Class<? extends GuiScreen>, Integer> selectedPage = new HashMap<Class<? extends GuiScreen>, Integer>();

        public GuiDocHelper(GuiScreen gui, List<String> pages, IGuiDocHandler docHandler) {
            this.gui = gui;
            this.pages = pages;
            this.docHandler = docHandler;
        }

        public List<String> getPages() {
            return this.pages;
        }

        public void setSelected(int selected) {
            selectedPage.put(this.gui.getClass(), MathHelper.clip((int)selected, (int)0, (int)(this.pages.size() - 1)));
        }

        public void setSelected(String page) {
            if (this.pages.contains(page)) {
                selectedPage.put(this.gui.getClass(), this.pages.indexOf(page));
            }
        }

        public int getSelectedIndex() {
            return selectedPage.computeIfAbsent(this.gui.getClass(), c -> 0);
        }

        public String getSelected() {
            int selected = selectedPage.computeIfAbsent(this.gui.getClass(), c -> 0);
            selected = MathHelper.clip((int)selected, (int)0, (int)(this.pages.size() - 1));
            return this.pages.get(selected);
        }

        public void setDocVisible(boolean visible) {
            if (this.docHandler.docDisplayOverride(this.gui) == null) {
                docVisible.put(this.gui.getClass(), visible);
            }
        }

        public boolean isDocVisible() {
            Supplier<Boolean> enableSupplier = this.docHandler.docDisplayOverride(this.gui);
            return enableSupplier != null ? enableSupplier.get().booleanValue() : docVisible.computeIfAbsent(this.gui.getClass(), c -> false).booleanValue();
        }

        public Rectangle getCollapsedArea() {
            return this.docHandler.getCollapsedArea(this.gui);
        }

        public Rectangle getExpandedArea() {
            return this.docHandler.getExpandedArea(this.gui);
        }

        public boolean enableAnimation() {
            return this.docHandler.enableAnimation(this.gui);
        }

        public boolean enableButton() {
            return this.docHandler.enableButton(this.gui);
        }
    }
}

