/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.docmanagement;

import com.brandon3055.projectintelligence.client.PIGuiHelper;
import com.brandon3055.projectintelligence.client.gui.PIConfig;
import com.brandon3055.projectintelligence.docmanagement.DocumentationManager;
import com.brandon3055.projectintelligence.docmanagement.DocumentationPage;
import com.brandon3055.projectintelligence.docmanagement.ModStructurePage;
import com.brandon3055.projectintelligence.utils.LogHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.IOUtils;

public class LanguageManager {
    public static final String DEFAULT_LANG = "en_us";
    public static final HashSet<String> ALL_LANGUAGES;
    public static final Map<String, String> LANG_NAME_MAP;
    public static Map<String, Map<String, Map<String, PageLangData>>> modLangPageTranslationMap;
    public static Map<String, Map<String, PageLangData>> pageLangTranslationMap;

    public static boolean isLangUsedByMod(String lang, String mod) {
        if (lang.equals(DEFAULT_LANG) || lang.equals(LanguageManager.getUserLanguage())) {
            return true;
        }
        if (PIConfig.modLangOverrides.containsKey(mod) && PIConfig.modLangOverrides.get(mod).equals(lang)) {
            return true;
        }
        for (Map.Entry<String, String> entry : PIConfig.pageLangOverrides.entrySet()) {
            if (!entry.getKey().startsWith(mod + ":") || !entry.getValue().equals(lang)) continue;
            return true;
        }
        return false;
    }

    public static void clearTranslations() {
        modLangPageTranslationMap.clear();
    }

    public static void reloadLookupMap() {
        pageLangTranslationMap.clear();
        modLangPageTranslationMap.forEach((mod, langPageTransMap) -> langPageTransMap.forEach((lang, pageTransMap) -> pageTransMap.forEach((page, trans) -> pageLangTranslationMap.computeIfAbsent((String)page, s -> new HashMap()).put(lang, trans))));
    }

    public static void loadModLocalization(String modid, File structureFolder) {
        File langFolder = new File(structureFolder, "lang");
        File[] files = langFolder.listFiles((dir, name) -> dir.isDirectory());
        if (files == null) {
            PIGuiHelper.displayError("Error loading documentation localization for mod: " + modid + ", No localization files found!");
            return;
        }
        for (File langFile : files) {
            String lang = langFile.getName().replace(".json", "");
            if (!langFile.getName().endsWith(".json") || !ALL_LANGUAGES.contains(lang)) continue;
            if (!langFile.exists()) {
                PIGuiHelper.displayError("En error occurred while loading localization for mod with id \"" + modid + "\" Found language folder but no lang file for language: " + LANG_NAME_MAP.get(lang));
                continue;
            }
            LanguageManager.loadLangFile(modid, langFile, lang);
        }
        LanguageManager.saveModLocalization(modid, DEFAULT_LANG);
    }

    public static void loadLangFile(String modid, File langFile, String lang) {
        JsonArray translations;
        try {
            JsonParser parser = new JsonParser();
            FileReader reader = new FileReader(langFile);
            JsonElement element2 = parser.parse((Reader)reader);
            IOUtils.closeQuietly((Reader)reader);
            if (!element2.isJsonArray()) {
                PIGuiHelper.displayError("Failed to load lang file. Detected invalid json file: " + langFile);
                return;
            }
            translations = element2.getAsJsonArray();
        }
        catch (Exception e) {
            PIGuiHelper.displayError("Error loading lang file: " + e.getMessage());
            PIGuiHelper.displayError("File: " + langFile);
            LogHelper.error("Error loading lang file: " + langFile);
            e.printStackTrace();
            return;
        }
        HashMap localizations = new HashMap();
        translations.forEach(element -> {
            JsonObject obj = element.getAsJsonObject();
            PageLangData data = PageLangData.fromJson(obj, lang, modid);
            localizations.put(data.pageURI, data);
        });
        modLangPageTranslationMap.computeIfAbsent(modid, s -> new HashMap()).computeIfAbsent(lang, s -> new HashMap()).putAll(localizations);
    }

    private static void saveModLocalization(String modid, String lang) {
        if (!PIConfig.editMode()) {
            return;
        }
        ModStructurePage modPage = DocumentationManager.getModPage(modid);
        File langFolder = new File(modPage.getStructureDir(), "lang");
        if (!langFolder.exists() && !langFolder.mkdirs() || !langFolder.isDirectory()) {
            PIGuiHelper.displayError("En error occurred while saving localization file for mod with id \"" + modid + "The lang folder could not be created or is invalid: " + langFolder);
            return;
        }
        File langFile = new File(langFolder, lang + ".json");
        Map<String, Map<String, PageLangData>> langPageMap = modLangPageTranslationMap.get(modid);
        if (langPageMap != null && langPageMap.containsKey(lang)) {
            LanguageManager.saveLangFile(modid, langPageMap.get(lang), langFile);
        } else {
            LogHelper.dev("Error saving lang file: " + langFile + " No translations available for this language.");
        }
    }

    public static void saveLangFile(String modid, Map<String, PageLangData> langMap, File langFile) {
        JsonArray translations = new JsonArray();
        langMap.forEach((uri, langData) -> translations.add((JsonElement)langData.toObj()));
        try {
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(langFile));
            writer.setIndent("  ");
            Streams.write((JsonElement)translations, (JsonWriter)writer);
            writer.flush();
            IOUtils.closeQuietly((Closeable)writer);
        }
        catch (Exception e) {
            PIGuiHelper.displayError("Error saving lang file: " + e.getMessage());
            PIGuiHelper.displayError("File: " + langFile);
            LogHelper.error("Error saving lang file: " + langFile);
            e.printStackTrace();
        }
    }

    public static boolean isPageLocalized(String pageURI, String targetLang) {
        Map<String, PageLangData> langMap = pageLangTranslationMap.get(pageURI);
        return langMap != null && langMap.containsKey(targetLang);
    }

    public static String getPageName(String pageURI, String lang) {
        Map<String, PageLangData> langMap = pageLangTranslationMap.get(pageURI);
        if (langMap == null) {
            return "page." + pageURI + ".name";
        }
        if (langMap.containsKey(lang)) {
            return langMap.get((Object)lang).translation;
        }
        return langMap.containsKey(DEFAULT_LANG) ? langMap.get((Object)DEFAULT_LANG).translation : "page." + pageURI + ".name";
    }

    public static String getPageLangName(String pageURI, String lang) {
        Map<String, PageLangData> langMap = pageLangTranslationMap.get(pageURI);
        if (langMap != null && langMap.containsKey(lang)) {
            return langMap.get((Object)lang).translation;
        }
        return pageURI;
    }

    public static String getPageLangName(DocumentationPage page) {
        return LanguageManager.getPageLangName(page.pageURI, page.getLocalizationLang());
    }

    public static void setPageName(String modid, String pageURI, String name, String lang) {
        Map langMap = modLangPageTranslationMap.computeIfAbsent(modid, s -> new HashMap()).computeIfAbsent(lang, s -> new HashMap());
        langMap.computeIfAbsent(pageURI, (Function<String, PageLangData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setPageName$12(java.lang.String java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;)Lcom/brandon3055/projectintelligence/docmanagement/LanguageManager$PageLangData;)((String)modid, (String)lang, (String)name)).translation = name;
        LanguageManager.saveModLocalization(modid, lang);
        LanguageManager.reloadLookupMap();
    }

    public static String getPageLanguage(String pageURI) {
        if (PIConfig.editMode()) {
            return LanguageManager.getUserLanguage();
        }
        String defaultLang = !pageURI.contains(":") ? LanguageManager.getUserLanguage() : LanguageManager.getModLanguage(pageURI.substring(0, pageURI.indexOf(":")));
        return PIConfig.pageLangOverrides.getOrDefault(pageURI, defaultLang);
    }

    public static boolean isPageLangOverridden(String pageURI) {
        return PIConfig.pageLangOverrides.containsKey(pageURI) && !PIConfig.editMode();
    }

    public static String getModLanguage(String modid) {
        if (PIConfig.editMode()) {
            return LanguageManager.getUserLanguage();
        }
        return PIConfig.modLangOverrides.getOrDefault(modid, LanguageManager.getUserLanguage());
    }

    public static boolean isModLangOverridden(String modid) {
        return PIConfig.modLangOverrides.containsKey(modid) && !PIConfig.editMode();
    }

    public static void setPageLangOverride(String pageURI, @Nullable String lang) {
        if (lang == null) {
            PIConfig.pageLangOverrides.remove(pageURI);
        } else {
            PIConfig.pageLangOverrides.put(pageURI, lang);
        }
        PIConfig.save();
        DocumentationManager.checkAndReloadDocFiles();
    }

    public static void setModLangOverride(String modid, @Nullable String lang) {
        if (lang == null) {
            PIConfig.modLangOverrides.remove(modid);
        } else {
            PIConfig.modLangOverrides.put(modid, lang);
        }
        PIConfig.save();
        DocumentationManager.checkAndReloadDocFiles();
    }

    public static Collection<String> getAvailablePageLanguages(String pageURI) {
        Map<String, PageLangData> langTransMap = pageLangTranslationMap.get(pageURI);
        if (langTransMap == null) {
            return Collections.emptyList();
        }
        return langTransMap.keySet();
    }

    @Nullable
    public static PageLangData getLangData(String pageURI, String lang) {
        Map<String, PageLangData> langTransMap = pageLangTranslationMap.get(pageURI);
        return langTransMap == null ? null : langTransMap.get(lang);
    }

    public static String getUserLanguage() {
        if (!PIConfig.userLanguage.equals("[MINECRAFT-LANG]")) {
            return PIConfig.userLanguage;
        }
        return LanguageManager.mcLanguage();
    }

    public static boolean isCustomUserLanguageSet() {
        return !PIConfig.userLanguage.equals("[MINECRAFT-LANG]");
    }

    public static void setCustomUserLanguage(@Nullable String lang) {
        if (lang == null) {
            PIConfig.userLanguage = "[MINECRAFT-LANG]";
            PIConfig.save();
        } else {
            PIConfig.userLanguage = lang;
        }
        DocumentationManager.checkAndReloadDocFiles();
    }

    private static String mcLanguage() {
        net.minecraft.client.resources.LanguageManager langManager = Minecraft.func_71410_x().func_135016_M();
        return langManager.func_135041_c().func_135034_a();
    }

    private static /* synthetic */ PageLangData lambda$setPageName$12(String modid, String lang, String name, String uri) {
        return new PageLangData(modid, uri, lang, name, 0);
    }

    static {
        LANG_NAME_MAP = new HashMap<String, String>();
        LinkedList langs = new LinkedList();
        net.minecraft.client.resources.LanguageManager langManager = Minecraft.func_71410_x().func_135016_M();
        langManager.func_135040_d().forEach(language -> {
            langs.add(language.func_135034_a());
            LANG_NAME_MAP.put(language.func_135034_a(), language.toString());
        });
        Collections.sort(langs);
        ALL_LANGUAGES = new LinkedHashSet<String>(langs);
        modLangPageTranslationMap = new HashMap<String, Map<String, Map<String, PageLangData>>>();
        pageLangTranslationMap = new HashMap<String, Map<String, PageLangData>>();
    }

    public static class PageLangData {
        public String pageURI;
        public String lang;
        public String translation;
        public int pageRev;
        public String matchLang = null;
        public int matchRev = 0;
        public String modid;

        private PageLangData() {
        }

        public PageLangData(String modid, String pageURI, String lang, String translation, int pageRev) {
            this.modid = modid;
            this.pageURI = pageURI;
            this.lang = lang;
            this.translation = translation;
            this.pageRev = pageRev;
        }

        public JsonObject toObj() {
            JsonObject obj = new JsonObject();
            obj.addProperty("page_uri", this.pageURI);
            obj.addProperty("translation", this.translation);
            obj.addProperty("page_rev", (Number)this.pageRev);
            if (this.matchLang != null) {
                JsonObject ml = new JsonObject();
                ml.addProperty("lang", this.matchLang);
                ml.addProperty("rev", (Number)this.matchRev);
                obj.add("matches", (JsonElement)ml);
            }
            return obj;
        }

        public PageLangData readObj(JsonObject obj) {
            this.pageURI = obj.get("page_uri").getAsString();
            this.translation = obj.get("translation").getAsString();
            this.pageRev = obj.get("page_rev").getAsInt();
            if (obj.has("matches")) {
                JsonObject ml = obj.get("matches").getAsJsonObject();
                this.matchLang = ml.get("lang").getAsString();
                this.matchRev = ml.get("rev").getAsInt();
            }
            return this;
        }

        public void setMatchLang(String matchLang, int matchRev) {
            this.matchLang = matchLang;
            this.matchRev = matchRev;
            LanguageManager.saveModLocalization(this.modid, this.lang);
        }

        public static PageLangData fromJson(JsonObject obj, String lang, String modid) {
            PageLangData data = new PageLangData().readObj(obj);
            data.lang = lang;
            data.modid = modid;
            return data;
        }
    }
}

