/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client.gui.guielements;

import codechicken.lib.reflect.ObfMapping;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiEntityRenderer;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiSelectDialog;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiSlotRender;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiStackIcon;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTextField;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.lib.DLRSCache;
import com.brandon3055.brandonscore.lib.StackReference;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.projectintelligence.client.DisplayController;
import com.brandon3055.projectintelligence.client.PITextures;
import com.brandon3055.projectintelligence.client.StyleHandler;
import com.brandon3055.projectintelligence.client.gui.ContentInfo;
import com.brandon3055.projectintelligence.client.gui.PIConfig;
import com.brandon3055.projectintelligence.client.gui.PIPartRenderer;
import com.brandon3055.projectintelligence.client.gui.guielements.StyledSelectDialog;
import com.brandon3055.projectintelligence.docmanagement.DocumentationManager;
import com.brandon3055.projectintelligence.docmanagement.DocumentationPage;
import com.brandon3055.projectintelligence.docmanagement.LanguageManager;
import com.brandon3055.projectintelligence.docmanagement.ModStructurePage;
import com.brandon3055.projectintelligence.utils.LogHelper;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class PageButton
extends GuiButton {
    public static StyleHandler.PropertyGroup pageButtonProps = new StyleHandler.PropertyGroup("page_list.page_buttons");
    public PIPartRenderer buttonRender = new PIPartRenderer(pageButtonProps).setButtonRender(true);
    private DocumentationPage page;
    private DisplayController controller;
    private LinkedList<MGuiElementBase> icons = new LinkedList();
    private GuiLabel label;
    private GuiTexture versMissMatch;
    private GuiButton langButton;
    private GuiTexture langButtonTexture;
    private boolean invalidIcons = false;
    private int iconIndex = 0;

    public PageButton(DocumentationPage page, DisplayController controller) {
        this.page = page;
        this.controller = controller;
    }

    public void addChildElements() {
        this.loadIcons();
        boolean noIcon = this.icons.isEmpty();
        int textXPos = 0;
        int textXSize = noIcon ? this.xSize() : this.xSize() - 20;
        this.label = (GuiLabel)((GuiLabel)((GuiLabel)new GuiLabel(this.page.getDisplayName()){

            public boolean hasShadow() {
                return pageButtonProps.textShadow();
            }
        }.setXPos(textXPos)).setXSize(textXSize)).setInsets(3, noIcon ? 6 : 3, 3, 3);
        this.label.setHeightForText().setAlignment(GuiAlign.LEFT);
        this.label.setXPosMod((guiLabel, integer) -> noIcon ? this.xPos() : this.xPos() + 20);
        this.label.setTextColGetter(hovering -> pageButtonProps.textColour(hovering));
        this.label.setWrap(true);
        this.addChild((MGuiElementBase)this.label);
        this.setYSize(Math.max(this.label.ySize(), 22));
        this.label.setYPos(this.yPos() + this.ySize() / 2 - this.label.ySize() / 2);
        this.icons.forEach(icon -> icon.setXPosMod((o, o2) -> this.xPos() + 2).setYPos(this.yPos() + this.ySize() / 2 - icon.ySize() / 2));
        this.langButton = (GuiButton)((GuiButton)((GuiButton)new GuiButton().setSize(12, 12)).setXPosMod((guiButton, integer) -> this.label.maxXPos() - 14)).setYPos(this.yPos() + 1);
        this.langButton.setBorderColours(0, -16760704).setFillColour(0);
        this.langButton.zOffset += 10.0;
        String[] error = new String[]{I18n.func_135052_a((String)"pi.error.page_not_localized.info", (Object[])new Object[0]), I18n.func_135052_a((String)"pi.error.page_not_localized_click_here.info", (Object[])new Object[0])};
        this.langButton.setHoverTextArray(e -> {
            String[] stringArray;
            if (LanguageManager.isPageLangOverridden(this.page.getPageURI())) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = I18n.func_135052_a((String)"pi.button.language_override_enabled.info", (Object[])new Object[0]);
                stringArray = stringArray2;
                stringArray2[1] = TextFormatting.GOLD + LanguageManager.LANG_NAME_MAP.get(LanguageManager.getPageLanguage(this.page.getPageURI()));
            } else {
                stringArray = error;
            }
            return stringArray;
        });
        this.addChild((MGuiElementBase)this.langButton);
        this.langButton.setListener(() -> this.openLanguageSelector(false));
        this.langButtonTexture = (GuiTexture)((GuiTexture)new GuiTexture(10, 10, PITextures.PI_PARTS).setXPosMod((guiButton, integer) -> this.label.maxXPos() - 13)).setYPos(this.yPos() + 2);
        this.langButtonTexture.setTexSizeOverride(13, 14);
        this.langButtonTexture.zOffset += 10.0;
        this.langButton.addChild((MGuiElementBase)this.langButtonTexture);
        this.versMissMatch = (GuiTexture)((GuiTexture)new GuiTexture(8, 8, PITextures.PI_PARTS).setXPosMod((guiButton, integer) -> this.label.maxXPos() - 13)).setYPos(this.yPos() + 12);
        this.versMissMatch.setTexSizeOverride(8, 8);
        this.versMissMatch.setTexturePos(0, 24);
        this.versMissMatch.zOffset += 10.0;
        this.addChild((MGuiElementBase)this.versMissMatch);
        if (this.page instanceof ModStructurePage && ((ModStructurePage)this.page).verified) {
            GuiTexture verified = new GuiTexture(72, 16, 5, 5, PITextures.PI_PARTS);
            verified.setYPos(this.yPos() + 2);
            verified.setXPosMod(() -> this.maxXPos() - 8);
            verified.setHoverText(new String[]{TextFormatting.GREEN + I18n.func_135052_a((String)"pi.pagebtn.verified", (Object[])new Object[0]), TextFormatting.BLUE + I18n.func_135052_a((String)"pi.pagebtn.verified.info", (Object[])new Object[0])});
            this.addChild((MGuiElementBase)verified);
        }
        super.addChildElements();
    }

    private void loadIcons() {
        if (this.page.getIcons().isEmpty()) {
            return;
        }
        for (JsonObject iconObj : this.page.getIcons()) {
            GuiStackIcon icon;
            String type;
            if (!JsonUtils.func_151205_a((JsonObject)iconObj, (String)"type") || !JsonUtils.func_151205_a((JsonObject)iconObj, (String)"icon_string")) {
                this.invalidIcons = true;
                continue;
            }
            ContentInfo ci = ContentInfo.fromIconObj(iconObj);
            switch (type = JsonUtils.func_151200_h((JsonObject)iconObj, (String)"type")) {
                case "stack": {
                    StackReference stack = ci.stack;
                    if (stack != null && !stack.createStack().func_190926_b()) {
                        icon = new GuiStackIcon(stack);
                        icon.setToolTip(ci.drawHover);
                        break;
                    }
                    icon = null;
                    break;
                }
                case "entity": {
                    Object entity = null;
                    entity = ci.entity.startsWith("player:") ? GuiEntityRenderer.createRenderPlayer((World)this.mc.field_71441_e, (String)ci.entity.replaceFirst("player:", "")) : EntityList.func_188429_b((ResourceLocation)new ResourceLocation(ci.entity), (World)this.mc.field_71441_e);
                    if (entity != null) {
                        for (int i = 0; i < 6; ++i) {
                            entity.func_184201_a(EntityEquipmentSlot.values()[i], ci.entityInventory[i > 1 ? 7 - i : i]);
                        }
                    }
                    GuiEntityRenderer renderer = (GuiEntityRenderer)new GuiEntityRenderer().setEntity((Entity)entity).setInsets(1, 1, 1, 1);
                    renderer.setTrackMouse(ci.trackMouse);
                    renderer.setRotationSpeedMultiplier((float)ci.rotationSpeed);
                    if (ci.rotationSpeed == 0.0) {
                        renderer.setLockedRotation((float)ci.rotation);
                    }
                    if (!ci.hover_text.isEmpty()) {
                        renderer.setHoverText(ci.hover_text.split("\n"));
                    }
                    if (!renderer.isInvalidEntity()) {
                        icon = renderer;
                        break;
                    }
                    icon = null;
                    break;
                }
                case "image": {
                    icon = new GuiTexture(18, 18, (ResourceLocation)DLRSCache.getResource((String)ci.imageURL)).setTexSizeOverride(18, 18).setTexSheetSize(18);
                    break;
                }
                default: {
                    icon = null;
                }
            }
            if (icon == null) {
                this.invalidIcons = true;
                continue;
            }
            icon.setSize(18, 18);
            if (ci.drawSlot && !(icon instanceof GuiTexture)) {
                icon.addChild(((GuiSlotRender)((GuiSlotRender)new GuiSlotRender().setYPos(icon.yPos())).setXPosMod((arg_0, arg_1) -> PageButton.lambda$loadIcons$10((MGuiElementBase)icon, arg_0, arg_1))).setSize(18, 18));
            }
            this.icons.add((MGuiElementBase)icon);
        }
        if (this.icons.isEmpty() && this.invalidIcons) {
            this.icons.add((MGuiElementBase)new GuiStackIcon(new StackReference("error")));
        }
        if (!this.icons.isEmpty()) {
            if (this.page.cycle_icons()) {
                this.icons.forEach(child -> {
                    child.setEnabled(false);
                    this.addChild((MGuiElementBase)child);
                });
                this.updateIcons();
            } else {
                this.addChild(this.icons.getFirst());
            }
        }
    }

    public void reloadElement() {
        LanguageManager.PageLangData data;
        boolean overridden = LanguageManager.isPageLangOverridden(this.page.getPageURI());
        if (this.isElementInitialized() && this.langButtonTexture != null && this.langButton != null) {
            this.langButtonTexture.setTexturePos(overridden ? 82 : 66, 0);
            this.langButton.setEnabled(!PIConfig.editMode() && (overridden || !LanguageManager.isPageLocalized(this.page.getPageURI(), LanguageManager.getPageLanguage(this.page.getPageURI()))));
        }
        if ((data = LanguageManager.getLangData(this.page.getPageURI(), LanguageManager.getPageLanguage(this.page.getPageURI()))) != null && data.matchLang != null) {
            LanguageManager.PageLangData matches = LanguageManager.getLangData(this.page.getPageURI(), data.matchLang);
            if (matches != null && matches.pageRev > data.matchRev) {
                this.versMissMatch.setHoverText(I18n.func_135052_a((String)"pi.error.page_lang_outdated", (Object[])new Object[]{matches.lang}));
            } else {
                this.versMissMatch.setEnabled(false);
            }
        } else {
            this.versMissMatch.setEnabled(false);
        }
        super.reloadElement();
    }

    public void onPressed(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 1) {
            StyledSelectDialog context = new StyledSelectDialog((MGuiElementBase)this.langButton, "user_dialogs", I18n.func_135052_a((String)"pi.page.cm.page_options", (Object[])new Object[0]));
            context.setSelectionListener(ContextMenuItem::onClicked);
            ContextMenuItem menuItem = new ContextMenuItem(I18n.func_135052_a((String)"pi.page.cm.open_new_tab", (Object[])new Object[0]));
            menuItem.setAction(() -> this.controller.openPage(this.page.getPageURI(), true));
            context.addItem(menuItem);
            menuItem = new ContextMenuItem(I18n.func_135052_a((String)"pi.page.cm.override_lang", (Object[])new Object[0]));
            menuItem.setAction(() -> this.openLanguageSelector(false));
            context.addItem(menuItem);
            menuItem = new ContextMenuItem(I18n.func_135052_a((String)"pi.page.cm.override_mod_lang", (Object[])new Object[0]));
            menuItem.setAction(() -> this.openLanguageSelector(true));
            context.addItem(menuItem);
            menuItem = new ContextMenuItem(I18n.func_135052_a((String)"pi.page.cm.set_home_page", (Object[])new Object[0]));
            menuItem.setAction(() -> {
                PIConfig.setHomePage(this.page.getPageURI());
                this.controller.onActivePageChange();
            });
            context.addItem(menuItem);
            if (PIConfig.editMode() || !ObfMapping.obfuscated) {
                menuItem = new ContextMenuItem(I18n.func_135052_a((String)"Copy page URI", (Object[])new Object[0]));
                menuItem.setAction(() -> Utils.setClipboardString((String)this.page.getPageURI()));
                context.addItem(menuItem);
            }
            context.setYSize(16 + context.getItems().size() * 16);
            context.setCloseOnSelection(true);
            context.show(200);
            ((GuiSelectDialog)context.setPos(mouseX, mouseY)).normalizePosition();
        } else {
            boolean newTab;
            boolean bl = newTab = mouseButton == 2;
            if (!newTab && this.controller.getActiveTab().pageURI.equals(this.page.getPageURI())) {
                this.controller.openPage(this.page.getParent().getPageURI(), false);
            } else {
                this.controller.openPage(this.page.getPageURI(), newTab);
            }
        }
        super.onPressed(mouseX, mouseY, mouseButton);
    }

    public void renderElement(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        boolean highlighted = this.isMouseOver(mouseX, mouseY) || this.controller.getActiveTab().pageURI.equals(this.page.getPageURI());
        this.buttonRender.render((MGuiElementBase)this, highlighted);
        int texV = 48 + this.getRenderState(highlighted) * 20;
        if (this.page.isHidden() && PIConfig.editMode()) {
            this.drawColouredRect(this.xPos() + 1, this.yPos() + 1, this.xSize() - 2, this.ySize() - 2, -1610612736);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.xPos() + 1), (float)(this.yPos() + 1), (float)0.0f);
            GlStateManager.func_179139_a((double)0.62, (double)0.62, (double)0.5);
            this.drawString(this.fontRenderer, "Hidden button. (only visible in edit mode)", 0.0f, 0.0f, 0xFF5050, false);
            GlStateManager.func_179121_F();
        }
        super.renderElement(mc, mouseX, mouseY, partialTicks);
    }

    public boolean onUpdate() {
        if (this.page.cycle_icons() && !GuiScreen.func_146272_n()) {
            this.updateIcons();
        }
        return super.onUpdate();
    }

    private void updateIcons() {
        int i = this.iconIndex / 20 % this.icons.size();
        this.icons.forEach(elementBase -> elementBase.setEnabled(false));
        this.icons.get(i).setEnabled(true);
        ++this.iconIndex;
    }

    public void openLanguageSelector(boolean mod) {
        LogHelper.dev("Lang Selector");
        StyledSelectDialog langSelect = new StyledSelectDialog((MGuiElementBase)this.langButton, "user_dialogs", I18n.func_135052_a((String)"pi.popup.select_language", (Object[])new Object[0]));
        String doTrans = I18n.func_135052_a((String)"pi.lang.disable_override", (Object[])new Object[0]);
        GuiTextField filter = new GuiTextField();
        langSelect.addChild((MGuiElementBase)filter);
        ((GuiTextField)filter.setSize(langSelect.xSize() - 4, 14)).setPos(langSelect.xPos() + 2, langSelect.maxYPos() - 16);
        filter.setListener((event, eventSource) -> langSelect.reloadElement());
        langSelect.setSelectionFilter(item -> {
            String ft = filter.getText().toLowerCase();
            return ft.isEmpty() || item.toLowerCase().contains(ft) || LanguageManager.LANG_NAME_MAP.getOrDefault(item, "").toLowerCase().contains(ft);
        });
        if (mod) {
            ModStructurePage modPage = DocumentationManager.getModPage(this.page.getModid());
            if (modPage == null) {
                return;
            }
            if (LanguageManager.isModLangOverridden(modPage.getModid())) {
                langSelect.addItem(doTrans);
            }
            langSelect.setSelected(LanguageManager.getModLanguage(modPage.getModid()));
            LanguageManager.getAvailablePageLanguages(modPage.getPageURI()).forEach(arg_0 -> langSelect.addItem(arg_0));
        } else {
            if (LanguageManager.isPageLangOverridden(this.page.getPageURI())) {
                langSelect.addItem(doTrans);
            }
            langSelect.setSelected(LanguageManager.getPageLanguage(this.page.getPageURI()));
            LanguageManager.getAvailablePageLanguages(this.page.getPageURI()).forEach(arg_0 -> langSelect.addItem(arg_0));
        }
        langSelect.setSelectionListener(lang -> {
            this.langButton.playClickSound();
            if (mod) {
                LanguageManager.setPageLangOverride(this.page.getPageURI(), lang.equals(doTrans) ? null : lang);
            } else {
                LanguageManager.setPageLangOverride(this.page.getPageURI(), lang.equals(doTrans) ? null : lang);
            }
        });
        langSelect.setCloseOnSelection(true);
        langSelect.showCenter(200);
    }

    private static /* synthetic */ Integer lambda$loadIcons$10(MGuiElementBase icon, GuiSlotRender guiSlotRender, Integer integer) {
        return icon.xPos();
    }

    private static class ContextMenuItem {
        private String name;
        private Runnable action;

        private ContextMenuItem(String name) {
            this.name = name;
        }

        public void setAction(Runnable action) {
            this.action = action;
        }

        public void onClicked() {
            if (this.action != null) {
                this.action.run();
            }
        }

        public String toString() {
            return this.name;
        }
    }
}

