/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client.gui.guielements;

import codechicken.lib.colour.Colour;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiPopUpDialogBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiScrollElement;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiPickColourDialog;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiPopupDialogs;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTextField;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTextFieldDialog;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.utils.GuiHelper;
import com.brandon3055.brandonscore.handlers.FileHandler;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.projectintelligence.client.PIGuiHelper;
import com.brandon3055.projectintelligence.client.PITextures;
import com.brandon3055.projectintelligence.client.StyleHandler;
import com.brandon3055.projectintelligence.client.gui.guielements.StyledGuiButton;
import com.brandon3055.projectintelligence.client.gui.guielements.StyledGuiRect;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Mouse;

public class GuiStyleEditor
extends GuiPopUpDialogBase<GuiStyleEditor> {
    private GuiScrollElement editTree;
    private GuiScrollElement presetList;
    private String highlight = "";

    public GuiStyleEditor(MGuiElementBase parent) {
        super(parent);
        this.setSize(200, 250);
        this.setDragBar(12);
        this.setCloseOnOutsideClick(false);
    }

    public void addChildElements() {
        this.childElements.clear();
        StyleHandler.reloadStyleProperties();
        StyleHandler.loadStyle();
        this.addChild(new StyledGuiRect("user_dialogs").setPosAndSize((MGuiElementBase)this));
        this.addChild((MGuiElementBase)((GuiLabel)((GuiLabel)((GuiLabel)new GuiLabel(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"pi.style.edit_style_properties.txt", (Object[])new Object[0])).setPos((MGuiElementBase)this)).setSize(this.xSize(), 10)).translate(4, 3)).setTextColGetter(hovering -> StyleHandler.getColour("user_dialogs." + StyleHandler.StyleType.TEXT_COLOUR.getName()).rgb()).setShadow(false).setAlignment(GuiAlign.CENTER));
        GuiButton close = (GuiButton)((GuiButton)((GuiButton)new StyledGuiButton("user_dialogs.button_style").setPos((MGuiElementBase)this)).translate(this.xSize() - 14, 3)).setSize(11, 11);
        close.setListener(() -> ((GuiStyleEditor)this).close());
        close.setHoverText(I18n.func_135052_a((String)"pi.button.close", (Object[])new Object[0]));
        close.addChild(new GuiTexture(64, 16, 5, 5, PITextures.PI_PARTS).setRelPos(3, 3));
        this.addChild((MGuiElementBase)close);
        int selOffst = 20;
        this.addChild(((GuiLabel)((GuiLabel)((GuiLabel)new GuiLabel(I18n.func_135052_a((String)"pi.style.load_preset.txt", (Object[])new Object[0])).setPos((MGuiElementBase)this)).setSize(this.xSize(), 10)).translate(4, selOffst)).setTextColGetter(hovering -> StyleHandler.getColour("user_dialogs." + StyleHandler.StyleType.TEXT_COLOUR.getName()).rgb()).setShadow(false).setAlignment(GuiAlign.LEFT).addToGroup("PRESETS"));
        GuiBorderedRect presetBackground = (GuiBorderedRect)((GuiBorderedRect)((GuiBorderedRect)((GuiBorderedRect)new GuiBorderedRect().setPos((MGuiElementBase)this)).translate(4, selOffst += 10)).setSize(this.xSize() - 8, this.ySize() - 48 - selOffst)).addToGroup("PRESETS");
        this.addChild((MGuiElementBase)presetBackground);
        presetBackground.setFillColourGetter(hovering -> StyleHandler.getInt("user_dialogs.sub_elements." + StyleHandler.StyleType.COLOUR.getName()));
        presetBackground.setBorderColourGetter(hovering -> StyleHandler.getInt("user_dialogs.sub_elements." + StyleHandler.StyleType.BORDER.getName()));
        this.addChild(((GuiLabel)((GuiLabel)new GuiLabel(I18n.func_135052_a((String)"pi.style.save_overwrite_preset.txt", (Object[])new Object[0])).setPos(this.xPos() + 4, presetBackground.maxYPos() + 3)).setSize(this.xSize() - 10, 10)).setTextColGetter(hovering -> StyleHandler.getColour("user_dialogs." + StyleHandler.StyleType.TEXT_COLOUR.getName()).rgb()).setShadow(false).setAlignment(GuiAlign.LEFT).addToGroup("PRESETS"));
        GuiTextField saveName = (GuiTextField)((GuiTextField)((GuiTextField)new GuiTextField().setPos(this.xPos() + 4, presetBackground.maxYPos() + 13)).setSize(this.xSize() - 50, 14)).addToGroup("PRESETS");
        saveName.setValidator(FileHandler.FILE_NAME_VALIDATOR.or(s -> s == null || s.isEmpty()));
        GuiButton savePreset = (GuiButton)((GuiButton)((GuiButton)new StyledGuiButton("user_dialogs.button_style").setText(I18n.func_135052_a((String)"pi.button.save", (Object[])new Object[0])).setPos(saveName.maxXPos() + 1, saveName.yPos())).setSize(41, 14)).addToGroup("PRESETS");
        savePreset.setHoverText(I18n.func_135052_a((String)"pi.style.save_preset.info", (Object[])new Object[0]));
        savePreset.setListener(() -> {
            if (saveName.getText().isEmpty()) {
                GuiPopupDialogs.createDialog((MGuiElementBase)this, (GuiPopupDialogs.DialogType)GuiPopupDialogs.DialogType.OK_OPTION, (String)I18n.func_135052_a((String)"pi.style.save_no_name.txt", (Object[])new Object[0]), (String)"").showCenter(this.displayZLevel + 50);
                return;
            }
            if (StyleHandler.getCustomPresets().contains(saveName.getText())) {
                GuiPopupDialogs.createDialog((MGuiElementBase)this, (GuiPopupDialogs.DialogType)GuiPopupDialogs.DialogType.YES_NO_OPTION, (String)I18n.func_135052_a((String)"pi.style.save_overwrite.txt", (Object[])new Object[0]), (String)"").setYesListener((event1, eventSource1) -> {
                    StyleHandler.savePreset(saveName.getText());
                    saveName.forceSetText("");
                    this.reloadElement();
                }).showCenter(this.displayZLevel + 50);
                return;
            }
            StyleHandler.savePreset(saveName.getText());
            saveName.forceSetText("");
            this.reloadElement();
        });
        this.addChild((MGuiElementBase)savePreset);
        this.addChild((MGuiElementBase)saveName);
        GuiButton openEditor = (GuiButton)((GuiButton)new StyledGuiButton("user_dialogs.button_style").setText(I18n.func_135052_a((String)"pi.button.open_style_editor", (Object[])new Object[0])).setPos(this.xPos() + 4, this.maxYPos() - 18)).setSize(this.xSize() - 8, 14);
        openEditor.addToGroup("PRESETS");
        openEditor.setListener(() -> {
            GuiStyleEditor cfr_ignored_0 = (GuiStyleEditor)((GuiStyleEditor)this.setChildGroupEnabled("EDITOR_TREE", true)).setChildGroupEnabled("PRESETS", false);
        });
        this.addChild((MGuiElementBase)openEditor);
        this.presetList = new GuiScrollElement();
        this.presetList.addToGroup("PRESETS");
        ((GuiScrollElement)this.presetList.setRelPos((MGuiElementBase)presetBackground, 1, 1)).setSize(presetBackground.xSize() - 2, presetBackground.ySize() - 2);
        this.presetList.setStandardScrollBehavior();
        this.presetList.setListMode(GuiScrollElement.ListMode.VERT_LOCK_POS_WIDTH);
        this.presetList.getVerticalScrollBar().setHidden(true);
        this.presetList.setListSpacing(1);
        this.addChild((MGuiElementBase)this.presetList);
        this.editTree = new GuiScrollElement();
        this.editTree.addToGroup("EDITOR_TREE");
        ((GuiScrollElement)this.editTree.setRelPos(3, 14)).setSize(this.xSize() - 6, this.ySize() - 31);
        this.editTree.setStandardScrollBehavior();
        this.editTree.setListMode(GuiScrollElement.ListMode.VERT_LOCK_POS_WIDTH);
        this.editTree.getVerticalScrollBar().setHidden(true);
        this.editTree.clearElements();
        for (StyleHandler.StyleProperty prop : StyleHandler.getPropertyMap().values()) {
            this.editTree.addElement((MGuiElementBase)new StyleSetting(prop));
        }
        this.addChild((MGuiElementBase)this.editTree);
        GuiButton closeEditor = (GuiButton)((GuiButton)new StyledGuiButton("user_dialogs.button_style").setText(I18n.func_135052_a((String)"pi.button.close_style_editor", (Object[])new Object[0])).setPos(this.xPos() + 3, this.maxYPos() - 15)).setSize(this.xSize() - 6, 12);
        closeEditor.addToGroup("EDITOR_TREE");
        closeEditor.setListener(() -> {
            GuiStyleEditor cfr_ignored_0 = (GuiStyleEditor)((GuiStyleEditor)this.setChildGroupEnabled("EDITOR_TREE", false)).setChildGroupEnabled("PRESETS", true);
        });
        this.addChild((MGuiElementBase)closeEditor);
        this.setChildGroupEnabled("EDITOR_TREE", false);
        super.addChildElements();
    }

    public void reloadElement() {
        GuiButton button;
        this.presetList.clearElements();
        for (String preset : StyleHandler.getCustomPresets()) {
            button = ((GuiButton)new StyledGuiButton("user_dialogs.sub_elements.button_style").setShadow(false).setText(preset).setYSize(12)).setAlignment(GuiAlign.LEFT);
            button.setListener(() -> {
                if (StyleHandler.unsavedChanges) {
                    GuiPopupDialogs.createDialog((MGuiElementBase)this, (GuiPopupDialogs.DialogType)GuiPopupDialogs.DialogType.OK_CANCEL_OPTION, (String)(I18n.func_135052_a((String)"pi.style.confirm_load_unsaved.txt", (Object[])new Object[0]) + "\n" + preset), (String)"").setOkListener((event1, eventSource1) -> StyleHandler.loadPreset(preset, true)).showCenter(this.displayZLevel + 50);
                } else {
                    StyleHandler.loadPreset(preset, true);
                }
            });
            GuiButton delete = (GuiButton)new StyledGuiButton("user_dialogs.button_style").setSize(9, 9);
            delete.setListener(() -> GuiPopupDialogs.createDialog((MGuiElementBase)this, (GuiPopupDialogs.DialogType)GuiPopupDialogs.DialogType.YES_NO_OPTION, (String)(I18n.func_135052_a((String)"pi.style.delete_preset_confirm.txt", (Object[])new Object[0]) + "\n" + preset), (String)I18n.func_135052_a((String)"pi.style.confirm_delete.txt", (Object[])new Object[0])).setYesListener((event1, eventSource1) -> {
                StyleHandler.deletePreset(preset);
                this.reloadElement();
            }).showCenter(this.displayZLevel + 50));
            delete.setHoverText(I18n.func_135052_a((String)"pi.button.delete", (Object[])new Object[0]));
            delete.addChild(new GuiTexture(64, 16, 5, 5, PITextures.PI_PARTS).setRelPos(2, 2));
            button.addChild((MGuiElementBase)delete);
            this.presetList.addElement((MGuiElementBase)button);
            delete.setPos(button.maxXPos() - 11, button.yPos() + 1);
        }
        for (String preset : StyleHandler.getDefaultPresets()) {
            button = ((GuiButton)new StyledGuiButton("user_dialogs.sub_elements.button_style").setShadow(false).setText(I18n.func_135052_a((String)("pi.style.default." + preset), (Object[])new Object[0])).setYSize(12)).setAlignment(GuiAlign.LEFT);
            button.addChild((MGuiElementBase)((GuiLabel)((GuiLabel)new GuiLabel(I18n.func_135052_a((String)"pi.style.builtin", (Object[])new Object[0])).setShadow(false).setYSize(12)).bindSize((MGuiElementBase)button, false)).setAlignment(GuiAlign.RIGHT).setTextColGetter(hovering -> StyleHandler.getInt("user_dialogs.sub_elements.button_style.text_colour")));
            button.setListener(() -> {
                if (StyleHandler.unsavedChanges) {
                    GuiPopupDialogs.createDialog((MGuiElementBase)this, (GuiPopupDialogs.DialogType)GuiPopupDialogs.DialogType.OK_CANCEL_OPTION, (String)(I18n.func_135052_a((String)"pi.style.confirm_load_unsaved.txt", (Object[])new Object[0]) + "\n" + preset), (String)"").setOkListener((event1, eventSource1) -> StyleHandler.loadPreset(preset, true)).showCenter(this.displayZLevel + 50);
                } else {
                    StyleHandler.loadPreset(preset, false);
                }
            });
            this.presetList.addElement((MGuiElementBase)button);
        }
        super.reloadElement();
    }

    public boolean onUpdate() {
        StyleHandler.setHighlight(this.highlight);
        this.highlight = "";
        return super.onUpdate();
    }

    protected boolean keyTyped(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.close();
            return true;
        }
        return super.keyTyped(typedChar, keyCode);
    }

    public class StyleSetting
    extends MGuiElementBase<StyleSetting> {
        private StyleHandler.StyleProperty property;
        private List<StyleHandler.StyleProperty> subProps = new LinkedList<StyleHandler.StyleProperty>();
        private boolean hasSubs = false;
        private boolean subsShown = false;
        private int propSize = 12;
        private GuiButton showHide;

        public StyleSetting(StyleHandler.StyleProperty property) {
            this.property = property;
            if (property.subProps.size() > 0) {
                this.hasSubs = true;
                this.subProps.addAll(property.subProps.values());
            }
            this.propSize = 13;
            this.setYSize(this.propSize);
            this.reportYSizeChange = true;
            this.setHoverTextDelay(5);
        }

        public boolean isMouseOver(int mouseX, int mouseY) {
            return GuiHelper.isInRect((int)this.xPos(), (int)this.yPos(), (int)this.xSize(), (int)this.propSize, (int)mouseX, (int)mouseY) && super.isMouseOver(mouseX, mouseY);
        }

        public void addChildElements() {
            if (this.hasSubs) {
                this.showHide = (GuiButton)((GuiButton)((GuiButton)new GuiButton().setYPos(1)).setXPosMod((guiButton, integer) -> this.maxXPos() - 12)).setSize(11, 10);
                this.showHide.setListener(() -> {
                    if (this.subsShown) {
                        this.subsShown = false;
                        this.removeChildByGroup("SUB_PROPS");
                        this.setYSize(this.propSize);
                    } else {
                        this.subsShown = true;
                        for (StyleHandler.StyleProperty subProp : this.subProps) {
                            StyleSetting child = (StyleSetting)((StyleSetting)new StyleSetting(subProp).setXPos(this.xPos() + 10)).setXSize(this.xSize() - 10);
                            child.addToGroup("SUB_PROPS");
                            this.addChild(child);
                        }
                        this.sortSubs();
                    }
                });
                this.showHide.setHoverText(element -> I18n.func_135052_a((String)(this.subsShown ? "pi.style.hide_subs.txt" : "pi.style.show_subs.txt"), (Object[])new Object[0]));
                this.showHide.addChild((MGuiElementBase)((GuiTexture)((GuiTexture)new GuiTexture(0, 16, 7, 4, PITextures.PI_PARTS).setYPos(4)).setXPosMod((guiTexture, integer) -> this.showHide.xPos() + 2)).setTexXGetter(() -> this.subsShown ? 24 : 16));
                this.addChild((MGuiElementBase)this.showHide);
            }
            ArrayList<String> tt = new ArrayList<String>();
            if (this.property.isColour()) {
                tt.add(I18n.func_135052_a((String)"pi.style.set_colour.txt", (Object[])new Object[0]));
                tt.add(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.right_click_options.txt", (Object[])new Object[0]));
            } else if (this.property.isInteger()) {
                tt.add(I18n.func_135052_a((String)"pi.style.set_value.txt", (Object[])new Object[0]));
                tt.add(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pi.style.right_click_options.txt", (Object[])new Object[0]));
            } else if (this.property.isBoolean()) {
                tt.add(I18n.func_135052_a((String)"pi.style.set_boolean.txt", (Object[])new Object[0]));
            } else if (this.hasSubs) {
                tt.add(I18n.func_135052_a((String)"pi.style.set_edit_sub_values.txt", (Object[])new Object[0]));
            }
            if (this.property.tip != null) {
                tt.add(this.property.tip);
            }
            if (!tt.isEmpty()) {
                this.setHoverText(tt);
            }
            super.addChildElements();
        }

        private void sortSubs() {
            int y = this.yPos() + this.propSize;
            boolean hasSubs = false;
            for (MGuiElementBase elementBase : this.getChildGroup("SUB_PROPS")) {
                y += elementBase.setYPos(y).ySize();
                hasSubs = true;
            }
            if (hasSubs) {
                ++y;
            }
            this.setYSize(y - this.yPos());
        }

        public void ySizeChanged(MGuiElementBase elementChanged) {
            if (elementChanged != this) {
                this.sortSubs();
            }
            super.ySizeChanged(elementChanged);
        }

        public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
            GuiStyleEditor.this.editTree.setSmoothScroll(false, 20);
            if (super.mouseClicked(mouseX, mouseY, mouseButton)) {
                return true;
            }
            boolean mouseOver = GuiHelper.isInRect((int)this.xPos(), (int)this.yPos(), (int)this.xSize(), (int)this.propSize, (int)mouseX, (int)mouseY);
            if (mouseOver && mouseButton == 0) {
                if (this.property.isColour()) {
                    StyleHandler.setHighlight("");
                    GuiPickColourDialog pickColour = new GuiPickColourDialog((MGuiElementBase)this);
                    pickColour.setColour(((StyleHandler.ColourProperty)this.property).getColour());
                    pickColour.setIncludeAlpha(((StyleHandler.ColourProperty)this.property).alpha);
                    pickColour.setColourChangeListener(integer -> ((StyleHandler.ColourProperty)this.property).set(pickColour.getColour()));
                    pickColour.showCenter(this.displayZLevel + 100);
                    this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                } else if (this.property.isInteger()) {
                    GuiTextFieldDialog textDialog = new GuiTextFieldDialog((MGuiElementBase)this);
                    textDialog.setYSize(25);
                    textDialog.setDragBar(5);
                    textDialog.setText(String.valueOf(((StyleHandler.IntegerProperty)this.property).get()));
                    textDialog.setValidator(s -> s.isEmpty() || s.equals("-") || Utils.validInteger((String)s));
                    textDialog.addTextChangeCallback(s -> ((StyleHandler.IntegerProperty)this.property).set(s.isEmpty() || s.equals("-") ? 0 : Utils.parseInt((String)s)));
                    textDialog.addChild((MGuiElementBase)((GuiBorderedRect)new GuiBorderedRect().setPosAndSize((MGuiElementBase)textDialog)).setFillColour(-16777216));
                    textDialog.showCenter(this.displayZLevel + 100);
                    ((GuiTextField)textDialog.textField.setYSize(20)).translate(0, 5);
                    ((GuiButton)textDialog.okButton.setYSize(20)).translate(0, 5);
                    this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                } else if (this.property.isBoolean()) {
                    ((StyleHandler.BooleanProperty)this.property).set(!((StyleHandler.BooleanProperty)this.property).get());
                    this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                } else if (this.showHide != null) {
                    this.showHide.onPressed(mouseX, mouseY, mouseButton);
                }
            } else if (mouseOver && mouseButton == 1 && this.property.isInteger()) {
                GuiPopUpDialogBase context = new GuiPopUpDialogBase((MGuiElementBase)this);
                context.setPos(mouseX, mouseY).setSize(100, this.property.isColour() ? 79 : 27).normalizePosition();
                context.setCloseOnScroll(true);
                context.addChild((MGuiElementBase)((GuiBorderedRect)new GuiBorderedRect().setPosAndSize((MGuiElementBase)context)).setColours(-12566464, -7303024));
                int rely = 0;
                GuiButton copy = ((GuiButton)((GuiButton)new GuiButton(I18n.func_135052_a((String)"pi.button.copy_value", (Object[])new Object[0])).setAlignment(GuiAlign.LEFT).setRelPos(1, ++rely)).setSize(98, 12)).setBorderColours(0, -9408400);
                copy.setListener(() -> {
                    GuiScreen.func_146275_d((String)String.valueOf(((StyleHandler.IntegerProperty)this.property).get()));
                    context.close();
                });
                context.addChild((MGuiElementBase)copy);
                GuiButton paste = ((GuiButton)((GuiButton)new GuiButton(I18n.func_135052_a((String)"pi.button.paste_value", (Object[])new Object[0])).setAlignment(GuiAlign.LEFT).setRelPos(1, rely += 13)).setSize(98, 12)).setBorderColours(0, -9408400);
                paste.setListener(() -> {
                    try {
                        long value = Long.decode(GuiScreen.func_146277_j());
                        ((StyleHandler.IntegerProperty)this.property).set((int)value);
                    }
                    catch (NumberFormatException e) {
                        PIGuiHelper.displayError("Invalid value found in clipboard! " + GuiScreen.func_146277_j() + " Must be an integer");
                    }
                    context.close();
                });
                context.addChild((MGuiElementBase)paste);
                if (this.property.isColour()) {
                    GuiButton copyHex = ((GuiButton)((GuiButton)new GuiButton(I18n.func_135052_a((String)"pi.button.copy_hex_value", (Object[])new Object[0])).setAlignment(GuiAlign.LEFT).setRelPos(1, rely += 13)).setSize(98, 12)).setBorderColours(0, -9408400);
                    copyHex.setListener(() -> {
                        int value = ((StyleHandler.IntegerProperty)this.property).get();
                        GuiScreen.func_146275_d((String)Integer.toHexString(value));
                        context.close();
                    });
                    context.addChild((MGuiElementBase)copyHex);
                    GuiButton pasteHex = ((GuiButton)((GuiButton)new GuiButton(I18n.func_135052_a((String)"pi.button.paste_hex_value", (Object[])new Object[0])).setAlignment(GuiAlign.LEFT).setRelPos(1, rely += 13)).setSize(98, 12)).setBorderColours(0, -9408400);
                    pasteHex.setListener(() -> {
                        try {
                            String value = GuiScreen.func_146277_j();
                            if (value.startsWith("#") || value.toLowerCase().startsWith("0x")) {
                                ((StyleHandler.IntegerProperty)this.property).set((int)Long.decode(value).longValue());
                            } else {
                                ((StyleHandler.IntegerProperty)this.property).set((int)Long.parseLong(value, 16));
                            }
                        }
                        catch (NumberFormatException e) {
                            PIGuiHelper.displayError("Invalid value found in clipboard! " + GuiScreen.func_146277_j() + " Must be a hex value");
                        }
                        context.close();
                    });
                    context.addChild((MGuiElementBase)pasteHex);
                    GuiButton lighten = ((GuiButton)((GuiButton)new GuiButton(I18n.func_135052_a((String)"pi.button.lighten", (Object[])new Object[0])).setAlignment(GuiAlign.LEFT).setRelPos(1, rely += 13)).setSize(98, 12)).setBorderColours(0, -9408400);
                    lighten.setListener(() -> {
                        Colour colour = ((StyleHandler.ColourProperty)this.property).getColour();
                        ((StyleHandler.ColourProperty)this.property).set(this.changeShade(colour.argb(), 0.05));
                    });
                    context.addChild((MGuiElementBase)lighten);
                    GuiButton darken = ((GuiButton)((GuiButton)new GuiButton(I18n.func_135052_a((String)"pi.button.darken", (Object[])new Object[0])).setAlignment(GuiAlign.LEFT).setRelPos(1, rely + 13)).setSize(98, 12)).setBorderColours(0, -9408400);
                    darken.setListener(() -> {
                        Colour colour = ((StyleHandler.ColourProperty)this.property).getColour();
                        ((StyleHandler.ColourProperty)this.property).set(this.changeShade(colour.argb(), -0.05));
                    });
                    context.addChild((MGuiElementBase)darken);
                }
                context.show(this.displayZLevel + 100);
            }
            return false;
        }

        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            boolean mouseOver = GuiHelper.isInRect((int)this.xPos(), (int)this.yPos(), (int)this.xSize(), (int)this.propSize, (int)mouseX, (int)mouseY);
            int border = mouseOver ? -16711936 : -11184641;
            int fill = -3092272;
            if (this.subsShown) {
                int i = this.yPos();
                for (MGuiElementBase e : this.childElements) {
                    if (e.yPos() <= i) continue;
                    i = e.yPos();
                }
                this.drawBorderedRect(this.xPos() + 4, this.yPos() + this.propSize - 2, 3.0, i - this.yPos() - 4, 2.0, 0, -16777216);
            }
            this.drawBorderedRect(this.xPos() - 3, this.yPos() + 4, 3.0, 3.0, 2.0, 0, -16777216);
            this.drawBorderedRect(this.xPos(), this.yPos(), this.xSize(), this.propSize - 1, 1.0, fill, border);
            this.drawString(this.fontRenderer, I18n.func_135052_a((String)("pi.style." + this.property.getType().getName() + ".prop"), (Object[])new Object[0]), this.xPos() + 12, this.yPos() + 2, 0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.bindTexture(PITextures.PI_PARTS);
            int xIndex = this.property.isColour() ? 32 : (this.property.isInteger() ? 40 : (this.property.isBoolean() ? 48 : 56));
            this.drawTexturedModalRect(this.xPos() + 3, this.yPos() + 3, xIndex, 16, 5, 7);
            if (this.property.isColour()) {
                this.drawString(this.fontRenderer, "T", (float)this.maxXPos() - 19.5f, (float)this.yPos() + 2.5f, 0);
                this.zOffset += 10.0;
                this.drawBorderedRect(this.maxXPos() - 22, this.yPos() + 1, 10.0, 10.0, 1.0, ((StyleHandler.ColourProperty)this.property).getColour().argb(), -16777216);
                this.zOffset -= 10.0;
            } else if (this.property.isInteger()) {
                this.drawCustomString(this.fontRenderer, String.valueOf(((StyleHandler.IntegerProperty)this.property).get()), this.maxXPos() - 45, (float)this.yPos() + 2.5f, 33, 0xFFAA00, GuiAlign.RIGHT, GuiAlign.TextRotation.NORMAL, false, true, true);
            } else if (this.property.isBoolean()) {
                this.drawString(this.fontRenderer, String.valueOf(((StyleHandler.BooleanProperty)this.property).get()), this.maxXPos() - 38, (float)this.yPos() + 2.5f, ((StyleHandler.BooleanProperty)this.property).get() ? 65280 : 0xFF0000, ((StyleHandler.BooleanProperty)this.property).get());
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }

        public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            ArrayList<String> tt = new ArrayList<String>();
            if (this.property.isColour() && GuiHelper.isInRect((int)(this.maxXPos() - 22), (int)(this.yPos() + 1), (int)10, (int)10, (int)mouseX, (int)mouseY)) {
                Colour colour = ((StyleHandler.ColourProperty)this.property).getColour();
                tt.add(I18n.func_135052_a((String)"pi.style.colour_value.txt", (Object[])new Object[0]));
                tt.add(TextFormatting.RED + "R: " + (colour.r & 0xFF));
                tt.add(TextFormatting.GREEN + "G: " + (colour.g & 0xFF));
                tt.add(TextFormatting.BLUE + "B: " + (colour.b & 0xFF));
                tt.add(I18n.func_135052_a((String)("pi.style." + ((colour.a & 0xFF) < 255 ? ((colour.a & 0xFF) == 0 ? "transparent" : "semi_transparent") : "opaque") + ".txt"), (Object[])new Object[0]));
            } else if (this.property.isInteger() && !this.property.isColour() && GuiHelper.isInRect((int)(this.maxXPos() - 45), (int)(this.yPos() + 1), (int)33, (int)10, (int)mouseX, (int)mouseY)) {
                tt.add(I18n.func_135052_a((String)"pi.style.integer_value.txt", (Object[])new Object[0]));
                tt.add(((StyleHandler.IntegerProperty)this.property).get() + "");
            }
            if (!tt.isEmpty()) {
                this.drawHoveringText(tt, mouseX, mouseY, this.fontRenderer, this.screenWidth, this.screenHeight);
                return true;
            }
            return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
        }

        public boolean onUpdate() {
            if (GuiStyleEditor.this.editTree.isEnabled() && GuiHelper.isInRect((int)this.xPos(), (int)this.yPos(), (int)(this.xSize() / 2), (int)this.propSize, (int)this.getMouseX(), (int)this.getMouseY())) {
                GuiStyleEditor.this.highlight = this.property.getPath();
            }
            return super.onUpdate();
        }

        private int getMouseX() {
            return Mouse.getEventX() * this.screenWidth / this.mc.field_71443_c;
        }

        private int getMouseY() {
            return this.screenHeight - Mouse.getEventY() * this.screenHeight / this.mc.field_71440_d - 1;
        }
    }
}

