/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client.gui;

import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiDraggable;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiPopupDialogs;
import com.brandon3055.projectintelligence.client.DisplayController;
import com.brandon3055.projectintelligence.client.PIGuiHelper;
import com.brandon3055.projectintelligence.client.gui.PIConfig;
import com.brandon3055.projectintelligence.client.gui.PIGuiContainer;
import com.brandon3055.projectintelligence.client.gui.guielements.GuiActiveDownloads;
import com.brandon3055.projectintelligence.client.gui.guielements.GuiErrorDialog;
import com.brandon3055.projectintelligence.client.gui.guielements.GuiNotifications;
import com.brandon3055.projectintelligence.client.gui.guielements.GuiPIIntroduction;
import com.brandon3055.projectintelligence.client.gui.guielements.GuiPartMenu;
import com.brandon3055.projectintelligence.client.keybinding.KeyInputHandler;
import com.brandon3055.projectintelligence.docmanagement.PIUpdateManager;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;

public class GuiProjectIntelligence
extends GuiScreen {
    private GuiScreen parent;
    private PIGuiContainer container = new PIGuiContainer(this, DisplayController.MASTER_CONTROLLER);
    public static boolean requiresEditReload = false;
    public static volatile boolean updateErrorDialog = false;
    private GuiErrorDialog errorDialog;

    public GuiProjectIntelligence() {
        this(null);
    }

    public GuiProjectIntelligence(GuiScreen parent) {
        this.parent = parent;
        this.container.setMenuElement(new GuiPartMenu(this.container, () -> this.updateSizeAndPos(true)));
        this.container.initContainer();
        this.container.setCloseHandler(this::closeGui);
        this.container.setListMaxWidth(() -> Math.min(150, this.container.xSize() / 3));
        this.container.setPositionRestraint(this::validatePosition);
        this.container.setCanDrag(() -> PIConfig.screenMode != 0);
        this.container.setOnMoved(this::savePosition);
        GuiActiveDownloads downloadsUI = new GuiActiveDownloads(this.container);
        GuiNotifications notificationUI = new GuiNotifications(this.container, downloadsUI);
        this.errorDialog = new GuiErrorDialog((MGuiElementBase)this.container.getPartContainer());
        this.container.getManager().add((MGuiElementBase)downloadsUI, 800);
        this.container.getManager().add((MGuiElementBase)notificationUI, 810);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.container.onGuiInit();
        this.updateSizeAndPos(false);
        if (!PIConfig.downloadsAllowed) {
            GuiPopupDialogs dialog = GuiPopupDialogs.createDialog((MGuiElementBase)this.container.getPartContainer(), (GuiPopupDialogs.DialogType)GuiPopupDialogs.DialogType.OK_CANCEL_OPTION, (String)I18n.func_135052_a((String)"pi.internet_access_info.txt", (Object[])new Object[0]));
            dialog.setCloseOnOutsideClick(false);
            dialog.cancelButton.setText(I18n.func_135052_a((String)"pi.button.more_information", (Object[])new Object[0]));
            dialog.setOkListener((guiButton, pressed) -> {
                PIConfig.downloadsAllowed = true;
                PIConfig.save();
                PIUpdateManager.performFullUpdateCheck();
                this.checkFirstLaunch();
            });
            dialog.setCancelListener((guiButton, pressed) -> {
                GuiPopupDialogs dialog2 = GuiPopupDialogs.createDialog((MGuiElementBase)this.container.getPartContainer(), (GuiPopupDialogs.DialogType)GuiPopupDialogs.DialogType.OK_CANCEL_OPTION, (String)I18n.func_135052_a((String)"pi.internet_access_more_info.txt", (Object[])new Object[0]));
                dialog2.setCloseOnOutsideClick(false);
                dialog2.cancelButton.setText(I18n.func_135052_a((String)"pi.button.deny_access", (Object[])new Object[0]));
                dialog2.setOkListener((guiButton2, pressed2) -> {
                    PIConfig.downloadsAllowed = true;
                    PIConfig.save();
                    PIUpdateManager.performFullUpdateCheck();
                    this.checkFirstLaunch();
                });
                dialog2.setCancelListener((guiButton2, pressed2) -> {
                    GuiPopupDialogs dialog3 = GuiPopupDialogs.createDialog((MGuiElementBase)this.container.getPartContainer(), (GuiPopupDialogs.DialogType)GuiPopupDialogs.DialogType.OK_OPTION, (String)I18n.func_135052_a((String)"pi.internet_access_denied.txt", (Object[])new Object[0]));
                    dialog3.setCloseOnOutsideClick(false);
                    dialog3.setOkListener((guiButton3, pressed3) -> this.closeGui());
                    dialog3.showCenter(850);
                });
                dialog2.showCenter(850);
            });
            dialog.setEscapeCallback(this::closeGui);
            dialog.setBlockOutsideClicks(true);
            dialog.showCenter(850);
        } else {
            this.checkFirstLaunch();
        }
    }

    private void checkFirstLaunch() {
        if (!PIConfig.showTutorialLater && !PIConfig.tutorialDisplayed) {
            GuiPIIntroduction guiIntro = new GuiPIIntroduction(this.container);
            this.container.getManager().add((MGuiElementBase)guiIntro, 820);
        }
    }

    private void closeGui() {
        this.field_146297_k.func_147108_a(this.parent);
        if (this.field_146297_k.field_71462_r == null) {
            this.field_146297_k.func_71381_h();
        }
    }

    private void updateSizeAndPos(boolean userChangedSize) {
        int mode = PIConfig.screenMode;
        if (mode == 0) {
            this.container.updateSize(this.field_146294_l, this.field_146295_m);
        } else {
            double s = mode == 1 ? 0.1 : (mode == 2 ? 0.2 : (mode == 3 ? 0.3 : (mode == 4 ? 0.4 : (mode == 5 ? 0.5 : 0.6))));
            this.container.updateSize((int)((double)this.field_146294_l - (double)this.field_146294_l * s), (int)((double)this.field_146295_m - (double)this.field_146295_m * s));
        }
        if (userChangedSize) {
            PIConfig.screenPosOverride = false;
            PIConfig.save();
        }
        if (PIConfig.screenPosOverride) {
            this.container.updatePos(PIConfig.screenPosX, PIConfig.screenPosY);
        } else {
            this.container.updatePos(this.field_146294_l / 2 - this.container.xSize() / 2, this.field_146295_m / 2 - this.container.ySize() / 2);
        }
    }

    private void savePosition(GuiDraggable draggable) {
        PIConfig.screenPosOverride = true;
        PIConfig.screenPosX = draggable.xPos();
        PIConfig.screenPosY = draggable.yPos();
        PIConfig.save();
    }

    private void validatePosition(GuiDraggable draggable) {
        boolean invalid = false;
        if (PIConfig.screenMode == 0) {
            draggable.setPos(0, 0);
        }
        if (draggable.xPos() + 100 > draggable.screenWidth) {
            draggable.setXPos(draggable.screenWidth - 100);
            invalid = true;
        }
        if (draggable.maxXPos() - 100 < 0) {
            draggable.setXPos(-draggable.xSize() + 100);
            invalid = true;
        }
        if (draggable.yPos() < 0) {
            draggable.setYPos(0);
            invalid = true;
        }
        if (draggable.yPos() + 100 > draggable.screenHeight) {
            draggable.setYPos(draggable.screenHeight - 100);
            invalid = true;
        }
        if (invalid) {
            this.savePosition(draggable);
        }
    }

    public PIGuiContainer getContainer() {
        return this.container;
    }

    public static GuiPartMenu getMenuPart() {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof GuiProjectIntelligence) {
            return ((GuiProjectIntelligence)screen).container.getMenu();
        }
        return null;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.container.mouseClicked(mouseX, mouseY, mouseButton)) {
            return;
        }
        if (!this.container.getPartContainer().isMouseOver(mouseX, mouseY)) {
            this.closeGui();
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (this.container.mouseReleased(mouseX, mouseY, state)) {
            return;
        }
        super.func_146286_b(mouseX, mouseY, state);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.container.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) {
            return;
        }
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        boolean captured = this.container.keyTyped(typedChar, keyCode);
        if (!captured && KeyInputHandler.openPI.isActiveAndMatches(keyCode)) {
            this.closeGui();
        } else if (!captured && keyCode == 59) {
            GuiPIIntroduction guiIntro = new GuiPIIntroduction(this.container);
            this.container.getManager().add((MGuiElementBase)guiIntro, 820);
        }
    }

    public void func_146274_d() throws IOException {
        if (this.container.handleMouseInput()) {
            return;
        }
        super.func_146274_d();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.container.renderElements(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.container.renderOverlayLayer(mouseX, mouseY, partialTicks);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.container.updateScreen();
        if (requiresEditReload) {
            this.container.getManager().reloadElements();
            requiresEditReload = false;
            return;
        }
        if (!PIGuiHelper.errorCache.isEmpty() && !this.container.getManager().getElements().contains((Object)this.errorDialog)) {
            this.errorDialog.showCenter(900);
            updateErrorDialog = false;
            return;
        }
        if (updateErrorDialog) {
            this.errorDialog.reloadElement();
            updateErrorDialog = false;
        }
    }
}

