/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client;

import com.brandon3055.brandonscore.integration.JeiHelper;
import com.brandon3055.projectintelligence.api.PiAPI;
import com.brandon3055.projectintelligence.client.gui.GuiInGuiRenderer;
import com.brandon3055.projectintelligence.client.keybinding.KeyInputHandler;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Keyboard;

public class GuiEventHandler {
    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        GuiScreen gui = event.getGui();
        GuiInGuiRenderer.instance.guiOpened(gui);
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen gui = event.getGui();
        GuiInGuiRenderer.instance.guiInit(gui);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onDrawForground(GuiContainerEvent.DrawForeground event) {
        if (event.isCanceled()) {
            return;
        }
        GuiContainer gui = event.getGuiContainer();
        GlStateManager.func_179140_f();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-gui.getGuiLeft()), (float)(-gui.getGuiTop()), (float)0.0f);
        GuiInGuiRenderer.instance.drawScreen((GuiScreen)gui);
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onDrawScreenEventPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.isCanceled()) {
            return;
        }
        GuiScreen gui = event.getGui();
        GlStateManager.func_179140_f();
        if (!(gui instanceof GuiContainer)) {
            GuiInGuiRenderer.instance.drawScreen(gui);
        }
        GuiInGuiRenderer.instance.drawScreenPost(gui);
    }

    @SubscribeEvent
    public void onToolTip(RenderTooltipEvent.Pre event) {
        if (GuiInGuiRenderer.instance.blockToolTip(Minecraft.func_71410_x().field_71462_r)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        GuiInGuiRenderer.instance.updateScreen();
    }

    @SubscribeEvent
    public void onMouseInput(GuiScreenEvent.MouseInputEvent.Pre event) {
        GuiScreen gui = event.getGui();
        try {
            if (GuiInGuiRenderer.instance.handleMouseInput(gui)) {
                event.setCanceled(true);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onKeyboardInput(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        GuiScreen gui = event.getGui();
        if (Keyboard.getEventKeyState() && this.handleKeyPress(gui, Keyboard.getEventKey())) {
            event.setCanceled(true);
            return;
        }
        try {
            if (GuiInGuiRenderer.instance.handleKeyboardInput(gui)) {
                event.setCanceled(true);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean handleKeyPress(GuiScreen gui, int key) {
        List<String> pages;
        GuiContainer container;
        Slot slot;
        ItemStack stack;
        if (KeyInputHandler.etGUI.isActiveAndMatches(key) && gui instanceof GuiContainer && (stack = (slot = (container = (GuiContainer)gui).getSlotUnderMouse()) != null ? slot.func_75211_c() : JeiHelper.getPanelItemUnderMouse()) != null && !stack.func_190926_b() && !(pages = PiAPI.getRelatedPages(stack)).isEmpty()) {
            PiAPI.openGui(gui, pages);
            return true;
        }
        return false;
    }
}

