/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client;

import com.brandon3055.projectintelligence.client.PIGuiHelper;
import com.brandon3055.projectintelligence.client.gui.PIConfig;
import com.brandon3055.projectintelligence.docmanagement.DocumentationManager;
import com.brandon3055.projectintelligence.docmanagement.DocumentationPage;
import com.brandon3055.projectintelligence.docmanagement.PIUpdateManager;
import com.brandon3055.projectintelligence.docmanagement.RootPage;
import java.util.LinkedList;
import java.util.WeakHashMap;
import javax.annotation.Nullable;

public class DisplayController {
    public static DisplayController MASTER_CONTROLLER = new DisplayController();
    private LinkedList<TabData> openTabs = new LinkedList();
    private TabData activeTab = null;
    private WeakHashMap<Object, Runnable> pageChangeListeners = new WeakHashMap();

    public LinkedList<TabData> getOpenTabs() {
        this.openTabs.removeIf(tabData -> !DocumentationManager.doesPageExist(tabData.pageURI));
        if (this.openTabs.isEmpty()) {
            this.openTabs.add(new TabData("[pi_root_page]"));
        }
        return this.openTabs;
    }

    public TabData getActiveTab() {
        if (this.activeTab == null || !this.getOpenTabs().contains(this.activeTab)) {
            this.activeTab = this.getOpenTabs().getFirst();
        }
        return this.activeTab;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean openPage(@Nullable String pageURI, boolean newTab) {
        if (pageURI == null) {
            pageURI = "[pi_root_page]";
        }
        this.getActiveTab();
        if (newTab) {
            if (this.openTabs.size() >= PIConfig.maxTabs) return false;
            this.activeTab = new TabData(pageURI);
            this.openTabs.add(this.activeTab);
        } else {
            this.activeTab.changePage(pageURI);
        }
        this.onActivePageChange();
        return true;
    }

    public void dragTab(TabData page, int dir) {
        if (!this.openTabs.contains(page)) {
            return;
        }
        int currentIndex = this.openTabs.indexOf(page);
        int newIndex = currentIndex + dir;
        if (newIndex >= this.openTabs.size() || newIndex < 0) {
            return;
        }
        TabData pageToReplace = this.openTabs.get(newIndex);
        this.openTabs.set(newIndex, page);
        this.openTabs.set(currentIndex, pageToReplace);
    }

    public LinkedList<DocumentationPage> getSubPages() {
        LinkedList<DocumentationPage> list = new LinkedList<DocumentationPage>();
        DocumentationPage page = this.getActiveTab().getDocPage();
        if (page.getSubPages().isEmpty()) {
            if (page.getParent() != null) {
                list.addAll(page.getParent().getSubPages());
            } else if (PIConfig.downloadsAllowed && !PIUpdateManager.downloadManager.running) {
                PIGuiHelper.displayError("No documentation pages were found! This most likely means the documentation failed to download for some reason.", true);
            }
        } else {
            list.addAll(page.getSubPages());
        }
        return list;
    }

    public String getButtonController() {
        DocumentationPage page = this.getActiveTab().getDocPage();
        if (page instanceof RootPage) {
            return page.getPageURI();
        }
        if (page.getSubPages().isEmpty()) {
            return page.getParent().getPageURI();
        }
        return page.getPageURI();
    }

    public void switchTab(TabData tab) {
        if (!this.getOpenTabs().contains(tab)) {
            PIGuiHelper.displayError("Attempted to open an un-tracked/invalid tab. This should not be possible! Try re opening the gui.");
            return;
        }
        this.activeTab = tab;
        this.onActivePageChange();
    }

    public void closeTab(TabData tab) {
        if (this.getOpenTabs().size() == 1 || !this.openTabs.contains(tab)) {
            return;
        }
        if (this.activeTab == tab) {
            int index = this.openTabs.indexOf(tab);
            index = index > 0 ? --index : ++index;
            this.switchTab(this.openTabs.get(index));
        }
        this.openTabs.remove(tab);
        this.onActivePageChange();
    }

    public void onActivePageChange() {
        this.pageChangeListeners.values().forEach(Runnable::run);
    }

    public void clear() {
        this.openTabs.clear();
    }

    public void goBack() {
        this.getActiveTab().back();
    }

    public void goForward() {
        this.getActiveTab().forward();
    }

    public void addChangeListener(Object listenerObject, Runnable changeCallback) {
        this.pageChangeListeners.put(listenerObject, changeCallback);
    }

    public static class TabData {
        public String pageURI;
        public double scrollPosition = 0.0;
        private LinkedList<String> pageHistory = new LinkedList();
        private LinkedList<String> forwardHistory = new LinkedList();
        public boolean requiresEditReload = false;

        public TabData(String pageURI) {
            this.pageURI = pageURI;
        }

        public String toString() {
            return "Tab: " + this.pageURI;
        }

        public void changePage(String newPageURI) {
            this.pageHistory.add(this.pageURI);
            this.pageURI = newPageURI;
            if (this.pageHistory.size() > 64) {
                this.pageHistory.removeFirst();
            }
            this.forwardHistory.clear();
            this.scrollPosition = 0.0;
        }

        public void back() {
            if (!this.pageHistory.isEmpty()) {
                this.forwardHistory.add(this.pageURI);
                this.pageURI = this.pageHistory.removeLast();
                this.scrollPosition = 0.0;
            }
        }

        public void forward() {
            if (!this.forwardHistory.isEmpty()) {
                this.pageHistory.add(this.pageURI);
                this.pageURI = this.forwardHistory.removeLast();
                this.scrollPosition = 0.0;
            }
        }

        public boolean canGoBack() {
            return !this.pageHistory.isEmpty();
        }

        public boolean canGoForward() {
            return !this.forwardHistory.isEmpty();
        }

        public DocumentationPage getDocPage() {
            return DocumentationManager.getPage(this.pageURI);
        }

        public void reloadTab() {
            this.requiresEditReload = true;
        }

        public void updateScroll(double scrollPosition) {
            this.scrollPosition = scrollPosition;
        }
    }
}

