/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.block;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTorchLever
extends BlockTorch {
    public static final PropertyBool POWERED = BlockLever.field_176359_b;
    public static final PropertyDirection SIDE = PropertyDirection.func_177712_a((String)"side", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockTorchLever() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176596_a, (Comparable)EnumFacing.UP).func_177226_a((IProperty)SIDE, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.func_149715_a(0.9375f);
        this.func_149647_a(CreativeTabs.field_78028_d);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176596_a, POWERED, SIDE});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_176596_a);
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.7;
        double z = (double)pos.func_177952_p() + 0.5;
        if (facing.func_176740_k().func_176722_c()) {
            EnumFacing opposite = facing.func_176734_d();
            int offsetX = opposite.func_82601_c();
            int offsetZ = opposite.func_82599_e();
            if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + 0.1 * (double)offsetX, y + 0.08, z + 0.1 * (double)offsetZ, 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, x + 0.1 * (double)offsetX, y + 0.08, z + 0.1 * (double)offsetZ, 0.0, 0.0, 0.0, new int[0]);
            } else {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + 0.27 * (double)offsetX, y + 0.22, z + 0.27 * (double)offsetZ, 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, x + 0.27 * (double)offsetX, y + 0.22, z + 0.27 * (double)offsetZ, 0.0, 0.0, 0.0, new int[0]);
            }
        } else if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            EnumFacing side = ((EnumFacing)state.func_177229_b((IProperty)SIDE)).func_176734_d();
            int offsetX = side.func_82601_c();
            int offsetZ = side.func_82599_e();
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x - 0.23 * (double)offsetX, y - 0.05, z - 0.23 * (double)offsetZ, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, x - 0.23 * (double)offsetX, y - 0.05, z - 0.23 * (double)offsetZ, 0.0, 0.0, 0.0, new int[0]);
        } else {
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing sideHit, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        sideHit = sideHit.func_176740_k().func_176720_b() ? playerIn.func_174811_aO() : sideHit.func_176734_d();
        state = state.func_177231_a((IProperty)POWERED).func_177226_a((IProperty)SIDE, (Comparable)sideHit);
        world.func_180501_a(pos, state, 3);
        float pitch = (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 0.6f : 0.5f;
        world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, pitch);
        world.func_175685_c(pos, (Block)this, false);
        world.func_175685_c(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)field_176596_a)).func_176734_d()), (Block)this, false);
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            world.func_175685_c(pos, (Block)this, false);
            world.func_175685_c(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)field_176596_a)).func_176734_d()), (Block)this, false);
        }
        super.func_180663_b(world, pos, state);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 0;
        }
        return state.func_177229_b((IProperty)field_176596_a) == side ? 15 : 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)(meta & 3));
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) > 1)).func_177226_a((IProperty)SIDE, (Comparable)facing);
        if ((meta & 4) > 0) {
            facing = EnumFacing.UP;
        }
        return state.func_177226_a((IProperty)field_176596_a, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_176596_a);
        i = facing == EnumFacing.UP ? (i |= 4 + ((EnumFacing)state.func_177229_b((IProperty)SIDE)).func_176736_b()) : (i |= facing.func_176736_b());
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }
}

