/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.utility.InspirationsUtility;
import knightminer.inspirations.utility.tileentity.TilePipe;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockDropper;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import slimeknights.mantle.block.BlockInventory;

public class BlockPipe
extends BlockInventory {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool HOPPER = PropertyBool.func_177716_a((String)"hopper");
    private static final AxisAlignedBB[] FULL_BOUNDS = new AxisAlignedBB[64];
    private static final AxisAlignedBB BOUNDS_CENTER;
    private static final AxisAlignedBB BOUNDS_DOWN;
    private static final AxisAlignedBB BOUNDS_UP;
    private static final AxisAlignedBB BOUNDS_NORTH;
    private static final AxisAlignedBB BOUNDS_SOUTH;
    private static final AxisAlignedBB BOUNDS_WEST;
    private static final AxisAlignedBB BOUNDS_EAST;
    private static final AxisAlignedBB BOUNDS_DOWN_CONNECT;
    private static final AxisAlignedBB BOUNDS_UP_CONNECT;
    private static final AxisAlignedBB BOUNDS_NORTH_CONNECT;
    private static final AxisAlignedBB BOUNDS_SOUTH_CONNECT;
    private static final AxisAlignedBB BOUNDS_WEST_CONNECT;
    private static final AxisAlignedBB BOUNDS_EAST_CONNECT;
    private static final AxisAlignedBB[] BOUNDS_SIDES;

    public BlockPipe() {
        super(Material.field_151573_f);
        this.func_149711_c(3.0f);
        this.func_149752_b(8.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)HOPPER, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(CreativeTabs.field_78028_d);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, NORTH, EAST, SOUTH, WEST, UP, DOWN, HOPPER});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        facing = facing.func_176734_d();
        if (!Config.pipeUpwards && facing == EnumFacing.UP) {
            facing = EnumFacing.DOWN;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float clickX, float clickY, float clickZ) {
        Item item = player.func_184586_b(hand).func_77973_b();
        if (item == Item.func_150898_a((Block)InspirationsUtility.pipe) || Block.func_149634_a((Item)item) instanceof BlockHopper) {
            return false;
        }
        return super.func_180639_a(world, pos, state, player, hand, side, clickX, clickY, clickZ);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        IBlockState offsetState = world.func_180495_p(pos.func_177972_a(facing));
        return state.func_177226_a((IProperty)HOPPER, (Comparable)Boolean.valueOf(offsetState.func_177230_c() instanceof BlockHopper && offsetState.func_177229_b((IProperty)BlockHopper.field_176430_a) != facing.func_176734_d())).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(BlockPipe.canConnectTo(world, pos, facing, EnumFacing.UP))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(BlockPipe.canConnectTo(world, pos, facing, EnumFacing.DOWN))).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(BlockPipe.canConnectTo(world, pos, facing, EnumFacing.NORTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(BlockPipe.canConnectTo(world, pos, facing, EnumFacing.EAST))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(BlockPipe.canConnectTo(world, pos, facing, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(BlockPipe.canConnectTo(world, pos, facing, EnumFacing.WEST)));
    }

    private static boolean canConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing, EnumFacing side) {
        if (facing == side) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos.func_177972_a(side));
        Block block = state.func_177230_c();
        EnumFacing opposite = side.func_176734_d();
        if ((block instanceof BlockPipe || block instanceof BlockDropper) && state.func_177229_b((IProperty)FACING) == opposite) {
            return true;
        }
        return side != EnumFacing.DOWN && block instanceof BlockHopper && state.func_177229_b((IProperty)BlockHopper.field_176430_a) == opposite;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TilePipe();
    }

    protected boolean openGui(EntityPlayer player, World world, BlockPos pos) {
        player.openGui((Object)Inspirations.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        int index = 1 << ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() | ((Boolean)state.func_177229_b((IProperty)EAST) != false ? 32 : 0) | ((Boolean)state.func_177229_b((IProperty)WEST) != false ? 16 : 0) | ((Boolean)state.func_177229_b((IProperty)SOUTH) != false ? 8 : 0) | ((Boolean)state.func_177229_b((IProperty)NORTH) != false ? 4 : 0) | ((Boolean)state.func_177229_b((IProperty)UP) != false ? 2 : 0) | ((Boolean)state.func_177229_b((IProperty)DOWN) != false ? 1 : 0);
        return FULL_BOUNDS[index];
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean p_185477_7_) {
        state = state.func_185899_b((IBlockAccess)world, pos);
        BlockPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDS_CENTER);
        BlockPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDS_SIDES[((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a()]);
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            BlockPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDS_UP);
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            BlockPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDS_DOWN);
        }
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            BlockPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDS_NORTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            BlockPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDS_SOUTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            BlockPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDS_WEST);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            BlockPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDS_EAST);
        }
    }

    @Deprecated
    public RayTraceResult func_180636_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        state = state.func_185899_b((IBlockAccess)world, pos);
        ArrayList<RayTraceResult> list = new ArrayList<RayTraceResult>(8);
        list.add(this.func_185503_a(pos, start, end, BOUNDS_CENTER));
        list.add(this.func_185503_a(pos, start, end, BOUNDS_SIDES[((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a()]));
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            list.add(this.func_185503_a(pos, start, end, BOUNDS_UP));
            list.add(this.func_185503_a(pos, start, end, BOUNDS_UP_CONNECT));
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            list.add(this.func_185503_a(pos, start, end, BOUNDS_DOWN));
            list.add(this.func_185503_a(pos, start, end, BOUNDS_DOWN_CONNECT));
        }
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            list.add(this.func_185503_a(pos, start, end, BOUNDS_NORTH));
            list.add(this.func_185503_a(pos, start, end, BOUNDS_NORTH_CONNECT));
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            list.add(this.func_185503_a(pos, start, end, BOUNDS_SOUTH));
            list.add(this.func_185503_a(pos, start, end, BOUNDS_SOUTH_CONNECT));
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            list.add(this.func_185503_a(pos, start, end, BOUNDS_WEST));
            list.add(this.func_185503_a(pos, start, end, BOUNDS_WEST_CONNECT));
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            list.add(this.func_185503_a(pos, start, end, BOUNDS_EAST));
            list.add(this.func_185503_a(pos, start, end, BOUNDS_EAST_CONNECT));
        }
        RayTraceResult result = null;
        double max = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double distance;
            if (raytraceresult == null || !((distance = raytraceresult.field_72307_f.func_72436_e(end)) > max)) continue;
            result = raytraceresult;
            max = distance;
        }
        return result;
    }

    static {
        for (int i = 0; i < 64; ++i) {
            BlockPipe.FULL_BOUNDS[i] = new AxisAlignedBB((i & 0x10) > 0 ? 0.0 : 0.34375, (i & 1) > 0 ? 0.0 : 0.21875, (i & 4) > 0 ? 0.0 : 0.34375, (i & 0x20) > 0 ? 1.0 : 0.65625, (i & 2) > 0 ? 1.0 : 0.53125, (i & 8) > 0 ? 1.0 : 0.65625);
        }
        BOUNDS_CENTER = new AxisAlignedBB(0.375, 0.25, 0.375, 0.625, 0.5, 0.625);
        BOUNDS_DOWN = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.25, 0.625);
        BOUNDS_UP = new AxisAlignedBB(0.375, 0.5, 0.375, 0.625, 1.0, 0.625);
        BOUNDS_NORTH = new AxisAlignedBB(0.375, 0.25, 0.0, 0.625, 0.5, 0.375);
        BOUNDS_SOUTH = new AxisAlignedBB(0.375, 0.25, 0.625, 0.625, 0.5, 1.0);
        BOUNDS_WEST = new AxisAlignedBB(0.0, 0.25, 0.375, 0.375, 0.5, 0.625);
        BOUNDS_EAST = new AxisAlignedBB(0.625, 0.25, 0.375, 1.0, 0.5, 0.625);
        BOUNDS_DOWN_CONNECT = new AxisAlignedBB(0.34375, 0.0, 0.34375, 0.65625, 0.0625, 0.65625);
        BOUNDS_UP_CONNECT = new AxisAlignedBB(0.34375, 0.9375, 0.34375, 0.59375, 1.0, 0.65625);
        BOUNDS_NORTH_CONNECT = new AxisAlignedBB(0.34375, 0.21875, 0.0, 0.65625, 0.53125, 0.0625);
        BOUNDS_SOUTH_CONNECT = new AxisAlignedBB(0.34375, 0.21875, 0.9375, 0.65625, 0.53125, 1.0);
        BOUNDS_WEST_CONNECT = new AxisAlignedBB(0.0, 0.21875, 0.34375, 0.0625, 0.53125, 0.65625);
        BOUNDS_EAST_CONNECT = new AxisAlignedBB(0.9375, 0.21875, 0.34375, 1.0, 0.53125, 0.65625);
        BOUNDS_SIDES = new AxisAlignedBB[]{BOUNDS_DOWN, BOUNDS_UP, BOUNDS_NORTH, BOUNDS_SOUTH, BOUNDS_WEST, BOUNDS_EAST};
    }
}

