/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockFittedCarpet
extends BlockCarpet {
    public static final PropertyBool NORTHWEST = PropertyBool.func_177716_a((String)"northwest");
    public static final PropertyBool NORTHEAST = PropertyBool.func_177716_a((String)"northeast");
    public static final PropertyBool SOUTHWEST = PropertyBool.func_177716_a((String)"southwest");
    public static final PropertyBool SOUTHEAST = PropertyBool.func_177716_a((String)"southeast");

    public BlockFittedCarpet() {
        this.func_149711_c(0.1f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149663_c("woolCarpet");
        this.func_149713_g(0);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)field_176330_a, (Comparable)EnumDyeColor.WHITE).func_177226_a((IProperty)NORTHWEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTHEAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTHWEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTHEAST, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176330_a, NORTHWEST, NORTHEAST, SOUTHWEST, SOUTHEAST});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        BlockPos down = pos.func_177977_b();
        IBlockState below = world.func_180495_p(down);
        Block block = below.func_177230_c();
        if (block instanceof BlockStairs && below.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.BOTTOM) {
            below = below.func_185899_b(world, down);
            state = this.setProperties(state, this.getStairShape(below));
        }
        return state;
    }

    private int getStairShape(IBlockState stairs) {
        BlockStairs.EnumShape shape = (BlockStairs.EnumShape)stairs.func_177229_b((IProperty)BlockStairs.field_176310_M);
        switch ((EnumFacing)stairs.func_177229_b((IProperty)BlockStairs.field_176309_a)) {
            case NORTH: {
                switch (shape) {
                    case STRAIGHT: {
                        return 3;
                    }
                    case INNER_LEFT: {
                        return 1;
                    }
                    case INNER_RIGHT: {
                        return 2;
                    }
                    case OUTER_LEFT: {
                        return 7;
                    }
                    case OUTER_RIGHT: {
                        return 11;
                    }
                }
            }
            case SOUTH: {
                switch (shape) {
                    case STRAIGHT: {
                        return 12;
                    }
                    case INNER_LEFT: {
                        return 8;
                    }
                    case INNER_RIGHT: {
                        return 4;
                    }
                    case OUTER_LEFT: {
                        return 14;
                    }
                    case OUTER_RIGHT: {
                        return 13;
                    }
                }
            }
            case WEST: {
                switch (shape) {
                    case STRAIGHT: {
                        return 5;
                    }
                    case INNER_LEFT: {
                        return 4;
                    }
                    case INNER_RIGHT: {
                        return 1;
                    }
                    case OUTER_LEFT: {
                        return 13;
                    }
                    case OUTER_RIGHT: {
                        return 7;
                    }
                }
            }
            case EAST: {
                switch (shape) {
                    case STRAIGHT: {
                        return 10;
                    }
                    case INNER_LEFT: {
                        return 2;
                    }
                    case INNER_RIGHT: {
                        return 8;
                    }
                    case OUTER_LEFT: {
                        return 11;
                    }
                    case OUTER_RIGHT: {
                        return 14;
                    }
                }
            }
        }
        return 0;
    }

    private IBlockState setProperties(IBlockState state, int i) {
        return state.func_177226_a((IProperty)NORTHWEST, (Comparable)Boolean.valueOf((i & 8) > 0)).func_177226_a((IProperty)NORTHEAST, (Comparable)Boolean.valueOf((i & 4) > 0)).func_177226_a((IProperty)SOUTHWEST, (Comparable)Boolean.valueOf((i & 2) > 0)).func_177226_a((IProperty)SOUTHEAST, (Comparable)Boolean.valueOf((i & 1) > 0));
    }

    @Deprecated
    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((Boolean)(state = state.func_185899_b(world, pos)).func_177229_b((IProperty)NORTHWEST)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)NORTHEAST)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)SOUTHWEST)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)SOUTHEAST)).booleanValue()) {
            return field_185506_k;
        }
        return super.func_180646_a(state, world, pos);
    }
}

