/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks;

import java.util.List;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.network.InspirationsNetwork;
import knightminer.inspirations.common.network.MilkablePacket;
import knightminer.inspirations.library.ItemMetaKey;
import knightminer.inspirations.shared.InspirationsShared;
import knightminer.inspirations.tweaks.InspirationsTweaks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDeadBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.network.AbstractPacket;

public class TweaksEvents {
    @SubscribeEvent
    public static void unsaddlePig(PlayerInteractEvent.EntityInteract event) {
        EntityPig pig;
        Entity target;
        if (!Config.enablePigDesaddle) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184586_b(event.getHand());
        if (player.func_70093_af() && stack.func_190926_b() && (target = event.getTarget()) instanceof EntityPig && (pig = (EntityPig)target).func_70901_n()) {
            pig.func_70900_e(false);
            pig.field_70170_p.func_184148_a(player, pig.field_70165_t, pig.field_70163_u, pig.field_70161_v, SoundEvents.field_187706_dO, SoundCategory.NEUTRAL, 0.5f, 1.0f);
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(Items.field_151141_av), (int)player.field_71071_by.field_70461_c);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void extraBonemeal(BonemealEvent event) {
        boolean isMycelium;
        if (!Config.enableExtraBonemeal) {
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = event.getPos();
        Block block = world.func_180495_p(pos).func_177230_c();
        boolean bl = isMycelium = block == Blocks.field_150391_bh;
        if (!isMycelium && block != Blocks.field_150354_m) {
            return;
        }
        BlockPos up = pos.func_177984_a();
        BlockDeadBush bush = Blocks.field_150330_I;
        IBlockState state = bush.func_176223_P();
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos next = up;
            int j = 0;
            while (true) {
                if (j >= i / 16) {
                    if (!world.func_175623_d(next) || world.field_73012_v.nextInt(128) != 0) continue block0;
                    if (isMycelium) {
                        bush = world.field_73012_v.nextInt(2) == 0 ? Blocks.field_150337_Q : Blocks.field_150338_P;
                        state = bush.func_176223_P();
                    }
                    if (!bush.func_180671_f(world, next, state)) continue block0;
                    world.func_175656_a(next, state);
                    continue block0;
                }
                if (world.func_180495_p((next = next.func_177982_a(world.field_73012_v.nextInt(3) - 1, (world.field_73012_v.nextInt(3) - 1) * world.field_73012_v.nextInt(3) / 2, world.field_73012_v.nextInt(3) - 1)).func_177977_b()).func_177230_c() != block || world.func_180495_p(next).func_185915_l()) continue block0;
                ++j;
            }
        }
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent
    public static void dropHeartbeet(BlockEvent.HarvestDropsEvent event) {
        if (!Config.enableHeartbeet) {
            return;
        }
        IBlockState state = event.getState();
        Block block = state.func_177230_c();
        if (block != Blocks.field_185773_cZ || !(block instanceof BlockCrops) || !((BlockCrops)block).func_185525_y(state)) {
            return;
        }
        int rolls = event.getFortuneLevel() + 2;
        if (rolls > 6) {
            rolls = 6;
        }
        List drops = event.getDrops();
        block0: for (ItemStack stack : drops) {
            if (stack.func_77973_b() != Items.field_185164_cV) continue;
            for (int i = 0; i < rolls; ++i) {
                if (event.getWorld().field_73012_v.nextInt(Config.heartbeetChance) != 0) continue;
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    drops.remove(stack);
                }
                drops.add(InspirationsShared.heartbeet.func_77946_l());
                break block0;
            }
        }
    }

    @SubscribeEvent
    public static void dropCarrotsPotatos(BlockEvent.HarvestDropsEvent event) {
        if (!Config.nerfCarrotPotatoDrops) {
            return;
        }
        IBlockState state = event.getState();
        Block block = state.func_177230_c();
        if (block != Blocks.field_150459_bM && block != Blocks.field_150469_bN || !(block instanceof BlockCrops) || ((BlockCrops)block).func_185525_y(state)) {
            return;
        }
        event.getDrops().clear();
        event.getDrops().add(new ItemStack(block == Blocks.field_150459_bM ? InspirationsTweaks.carrotSeeds : InspirationsTweaks.potatoSeeds));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onFall(LivingFallEvent event) {
        double z;
        if (!Config.lilypadBreakFall) {
            return;
        }
        if (event.getDistance() < 4.0f) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        Vec3d vec = entity.func_174791_d();
        if (vec.field_72448_b % 1.0 > 0.09375) {
            return;
        }
        BlockPos blockPos = entity.func_180425_c();
        BlockPos[] posList = new BlockPos[4];
        int i = 0;
        posList[i++] = blockPos;
        double x = vec.field_72450_a % 1.0;
        if (x < 0.0) {
            x += 1.0;
        }
        if ((z = vec.field_72449_c % 1.0) < 0.0) {
            z += 1.0;
        }
        if (x > 0.7) {
            posList[i++] = blockPos.func_177974_f();
        } else if (x < 0.3) {
            posList[i++] = blockPos.func_177976_e();
        }
        if (z > 0.7) {
            posList[i++] = blockPos.func_177968_d();
            if (i == 3) {
                posList[i++] = posList[1].func_177968_d();
            }
        } else if (z < 0.3) {
            posList[i++] = blockPos.func_177978_c();
            if (i == 3) {
                posList[i++] = posList[1].func_177978_c();
            }
        }
        boolean safe = false;
        for (BlockPos pos : posList) {
            if (pos == null || world.func_180495_p(pos).func_177230_c() != Blocks.field_150392_bi) continue;
            world.func_175655_b(pos, true);
            safe = true;
        }
        if (safe) {
            event.setDistance(0.0f);
        }
    }

    @SubscribeEvent
    public static void milkCow(PlayerInteractEvent.EntityInteract event) {
        if (!Config.milkCooldown) {
            return;
        }
        Entity target = event.getTarget();
        if (!(target instanceof EntityCow) || ((EntityCow)target).func_70631_g_()) {
            return;
        }
        ItemStack stack = event.getEntityPlayer().func_184586_b(event.getHand());
        if (Config.milkContainers.contains(new ItemMetaKey(stack))) {
            NBTTagCompound tags = target.getEntityData();
            if (tags.func_74765_d("milk_cooldown") > 0) {
                event.setCancellationResult(EnumActionResult.PASS);
                event.setCanceled(true);
            } else {
                tags.func_74777_a("milk_cooldown", Config.milkCooldownTime);
                if (!event.getWorld().field_72995_K) {
                    InspirationsNetwork.sendToClients(event.getWorld(), target.func_180425_c(), (AbstractPacket)new MilkablePacket(target, false));
                }
            }
        }
    }
}

