/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import knightminer.inspirations.common.ClientProxy;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.PulseBase;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.client.ClientUtil;
import knightminer.inspirations.library.client.PropertyStateMapper;
import knightminer.inspirations.recipes.RecipesClientProxy;
import knightminer.inspirations.tweaks.InspirationsTweaks;
import knightminer.inspirations.tweaks.block.BlockBetterFlowerPot;
import knightminer.inspirations.tweaks.block.BlockFittedCarpet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TweaksClientProxy
extends ClientProxy {
    private static final ResourceLocation CARPET_MODEL = Util.getResource("carpet");
    private static final ResourceLocation CAULDRON_ITEM_MODEL = Util.getResource("cauldron_item");
    private static final ResourceLocation ENCHANTED_BOOK = Util.getResource("enchanted_book");
    private static final ResourceLocation FIREWORKS = Util.getResource("fireworks");
    private static final ModelResourceLocation FLOWER_POT_MODEL = new ModelResourceLocation(Util.getResource("flower_pot"), "normal");

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        TweaksClientProxy.setModelStateMapper(InspirationsTweaks.carpet, (IStateMapper)new PropertyStateMapper(CARPET_MODEL, BlockCarpet.field_176330_a, new IProperty[]{BlockFittedCarpet.NORTHWEST, BlockFittedCarpet.NORTHEAST, BlockFittedCarpet.SOUTHWEST, BlockFittedCarpet.SOUTHEAST}));
        TweaksClientProxy.setModelStateMapper(InspirationsTweaks.flowerPot, (IStateMapper)new FlowerPotStateMapper());
        TweaksClientProxy.registerItemModel(InspirationsTweaks.cactusSeeds);
        TweaksClientProxy.registerItemModel(InspirationsTweaks.carrotSeeds);
        TweaksClientProxy.registerItemModel(InspirationsTweaks.potatoSeeds);
        TweaksClientProxy.registerItemModel(InspirationsTweaks.sugarCaneSeeds);
        if (Config.betterCauldronItem) {
            ResourceLocation model = CAULDRON_ITEM_MODEL;
            if (PulseBase.isRecipesLoaded() && Config.enableExtendedCauldron) {
                model = RecipesClientProxy.CAULDRON_MODEL;
            }
            TweaksClientProxy.registerItemModel(Items.field_151066_bu, 0, model);
        }
        if (Config.coloredEnchantedRibbons) {
            TweaksClientProxy.registerItemModel(Items.field_151134_bR, ENCHANTED_BOOK);
        }
        if (Config.coloredFireworkItems) {
            TweaksClientProxy.registerItemModel(Items.field_151152_bP, 0, FIREWORKS);
        }
    }

    @SubscribeEvent
    public void registerBlockColors(ColorHandlerEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        if (Config.betterFlowerPot) {
            TweaksClientProxy.registerBlockColors(colors, (state, world, pos, index) -> {
                TileEntity tileentity;
                if (world != null && pos != null && (tileentity = world.func_175625_s(pos)) instanceof TileEntityFlowerPot) {
                    ItemStack stack = ((TileEntityFlowerPot)tileentity).func_184403_b();
                    return ClientUtil.getStackBlockColorsSafe(stack, world, pos, 0);
                }
                return -1;
            }, Blocks.field_150457_bL);
        }
        TweaksClientProxy.registerBlockColors(colors, (state, world, pos, index) -> {
            if (world == null || pos == null) {
                return -1;
            }
            return BiomeColorHelper.func_180286_a((IBlockAccess)world, (BlockPos)pos);
        }, new Block[]{InspirationsTweaks.sugarCaneCrop});
    }

    @SubscribeEvent
    public void registerItemColors(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        if (Config.coloredEnchantedRibbons) {
            TweaksClientProxy.registerItemColors(itemColors, (stack, tintIndex) -> {
                if (tintIndex == 0) {
                    Enchantment.Rarity rarity = Enchantment.Rarity.COMMON;
                    for (NBTBase tag : ItemEnchantedBook.func_92110_g((ItemStack)stack)) {
                        Enchantment.Rarity newRarity;
                        short id;
                        Enchantment enchantment;
                        if (tag.func_74732_a() != 10 || (enchantment = Enchantment.func_185262_c((int)(id = ((NBTTagCompound)tag).func_74765_d("id")))) == null || (newRarity = enchantment.func_77324_c()) == null || newRarity.func_185270_a() >= rarity.func_185270_a()) continue;
                        rarity = newRarity;
                    }
                    switch (rarity) {
                        case COMMON: {
                            return 16720209;
                        }
                        case UNCOMMON: {
                            return 14845997;
                        }
                        case RARE: {
                            return 65313;
                        }
                        case VERY_RARE: {
                            return 0x9F7FFF;
                        }
                    }
                }
                return -1;
            }, Items.field_151134_bR);
        }
        if (Config.coloredFireworkItems) {
            TweaksClientProxy.registerItemColors(itemColors, (stack, tintIndex) -> {
                NBTTagCompound nbt = stack.func_179543_a("Fireworks");
                if (tintIndex == 2) {
                    if (nbt != null && nbt.func_150297_b("Flight", 99)) {
                        byte flight = nbt.func_74771_c("Flight");
                        switch (flight) {
                            case 1: {
                                return 0x808080;
                            }
                            case 2: {
                                return 0x606060;
                            }
                            case 3: {
                                return 0x303030;
                            }
                        }
                        if (flight > 3) {
                            return 0;
                        }
                    }
                    return 0xA0A0A0;
                }
                if (tintIndex == 0 || tintIndex == 1) {
                    int missing;
                    int n = missing = tintIndex == 1 ? 13410704 : 0xC0C0C0;
                    if (nbt == null) {
                        return missing;
                    }
                    NBTTagList stars = nbt.func_150295_c("Explosions", 10);
                    if (tintIndex >= stars.func_74745_c()) {
                        return missing;
                    }
                    NBTTagCompound star = stars.func_150305_b(tintIndex);
                    int[] colors = star.func_74759_k("Colors");
                    if (colors.length > 0) {
                        return colors[0];
                    }
                    return missing;
                }
                return -1;
            }, Items.field_151152_bP);
        }
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        if (InspirationsTweaks.flowerPot != null) {
            TweaksClientProxy.replaceTexturedModel(event, FLOWER_POT_MODEL, "plant", false);
        }
    }

    private static class FlowerPotStateMapper
    extends StateMapperBase {
        private FlowerPotStateMapper() {
        }

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            if (((Boolean)state.func_177229_b((IProperty)BlockBetterFlowerPot.EXTRA)).booleanValue()) {
                return FLOWER_POT_MODEL;
            }
            LinkedHashMap map = Maps.newLinkedHashMap((Map)state.func_177228_b());
            map.remove(BlockBetterFlowerPot.EXTRA);
            map.remove(BlockBetterFlowerPot.field_176444_a);
            return new ModelResourceLocation(state.func_177230_c().getRegistryName(), this.func_178131_a(map));
        }
    }
}

