/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tools;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.shared.InspirationsShared;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.LockCode;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public class ToolsEvents {
    @SubscribeEvent
    public static void lockAndUnlock(PlayerInteractEvent.RightClickBlock event) {
        TileEntity te;
        boolean isLock;
        if (!Config.enableLock) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184586_b(event.getHand());
        if (stack.func_190926_b() || stack.func_77973_b() != InspirationsShared.materials) {
            return;
        }
        int meta = stack.func_77960_j();
        boolean bl = isLock = meta == InspirationsShared.lock.func_77952_i();
        if ((isLock || meta == InspirationsShared.key.func_77952_i()) && (te = event.getWorld().func_175625_s(event.getPos())) instanceof ILockableContainer) {
            ILockableContainer lockable = (ILockableContainer)te;
            if (isLock) {
                if (lockable.func_174893_q_()) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation(Util.prefix("lock.fail.locked"), new Object[0]), true);
                } else if (!stack.func_82837_s()) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation(Util.prefix("lock.fail.blank"), new Object[0]), true);
                } else {
                    lockable.func_174892_a(new LockCode(stack.func_82833_r()));
                    lockable.func_70296_d();
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    player.func_146105_b((ITextComponent)new TextComponentTranslation(Util.prefix("lock.success"), new Object[0]), true);
                }
                event.setCanceled(true);
                event.setCancellationResult(EnumActionResult.SUCCESS);
            } else if (player.func_70093_af()) {
                if (lockable.func_174893_q_()) {
                    if (stack.func_82837_s() && stack.func_82833_r().equals(lockable.func_174891_i().func_180159_b())) {
                        LockCode code = lockable.func_174891_i();
                        lockable.func_174892_a(LockCode.field_180162_a);
                        lockable.func_70296_d();
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)InspirationsShared.lock.func_77946_l().func_151001_c(code.func_180159_b()));
                        player.func_146105_b((ITextComponent)new TextComponentTranslation(Util.prefix("unlock.success"), new Object[0]), true);
                    } else {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation(Util.prefix("unlock.fail.no_match"), new Object[0]), true);
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation(Util.prefix("unlock.fail.unlocked"), new Object[0]), true);
                }
                event.setCanceled(true);
                event.setCancellationResult(EnumActionResult.SUCCESS);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void vineBreakEvent(BlockEvent.BreakEvent event) {
        if (!Config.harvestHangingVines) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        Block block = event.getState().func_177230_c();
        if (!(block instanceof BlockVine)) {
            return;
        }
        ItemStack shears = player.func_184614_ca();
        Item item = shears.func_77973_b();
        if (!(item instanceof ItemShears) && !item.getToolClasses(shears).contains("shears")) {
            return;
        }
        BlockPos pos = event.getPos().func_177977_b();
        BlockVine vine = (BlockVine)block;
        IBlockState state = world.func_180495_p(pos);
        int count = 0;
        while (state.func_177230_c() == block && vine.isShearable(shears, (IBlockAccess)world, pos) && !ToolsEvents.vineCanStay(vine, world, state, pos)) {
            ++count;
            for (ItemStack stack : vine.onSheared(shears, (IBlockAccess)world, pos, 0)) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
            pos = pos.func_177977_b();
            state = world.func_180495_p(pos);
        }
        for (int i = 0; i < count; ++i) {
            pos = pos.func_177984_a();
            world.func_175698_g(pos);
        }
    }

    private static boolean vineCanStay(BlockVine vine, World world, IBlockState state, BlockPos pos) {
        for (EnumFacing side : EnumFacing.Plane.HORIZONTAL) {
            if (!((Boolean)state.func_177229_b((IProperty)BlockVine.func_176267_a((EnumFacing)side))).booleanValue() || !vine.func_193395_a(world, pos, side.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void dropMelon(BlockEvent.HarvestDropsEvent event) {
        if (!Config.shearsReclaimMelons || event.getState().func_177230_c() != Blocks.field_150440_ba) {
            return;
        }
        EntityPlayer player = event.getHarvester();
        if (player == null || player.field_71075_bZ.field_75098_d) {
            return;
        }
        ItemStack shears = player.func_184614_ca();
        Item item = shears.func_77973_b();
        if (!(item instanceof ItemShears) && !item.getToolClasses(shears).contains("shears")) {
            return;
        }
        List drops = event.getDrops();
        Iterator iterator = drops.iterator();
        boolean foundMelon = false;
        while (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            if (stack.func_77973_b() != Items.field_151127_ba) continue;
            if (!foundMelon) {
                stack.func_190920_e(9);
                foundMelon = true;
                continue;
            }
            iterator.remove();
        }
    }

    @SubscribeEvent
    public static void dropExtraSapling(BlockEvent.HarvestDropsEvent event) {
        if (!Config.enableCrook) {
            return;
        }
        IBlockState state = event.getState();
        Block block = state.func_177230_c();
        if (!(block instanceof BlockLeaves)) {
            return;
        }
        EntityPlayer player = event.getHarvester();
        if (player == null || player.field_71075_bZ.field_75098_d) {
            return;
        }
        ItemStack crook = player.func_184614_ca();
        Item item = crook.func_77973_b();
        if (Config.hoeCrook ? !(item instanceof ItemHoe) && !item.getToolClasses(crook).contains("hoe") : !item.getToolClasses(crook).contains("crook")) {
            return;
        }
        World world = event.getWorld();
        if (!world.field_72995_K && Config.hoeCrook) {
            crook.func_77972_a(1, (EntityLivingBase)player);
        }
        Random rand = world.field_73012_v;
        ItemStack sapling = new ItemStack(block.func_180660_a(state, rand, event.getFortuneLevel()), 1, block.func_180651_a(state));
        List drops = event.getDrops();
        for (ItemStack stack : drops) {
            if (!OreDictionary.itemMatches((ItemStack)sapling, (ItemStack)stack, (boolean)false)) continue;
            return;
        }
        if (rand.nextInt(Config.crookChance) == 0) {
            drops.add(sapling);
        }
    }

    @SubscribeEvent
    public static void breakLeavesFast(PlayerEvent.BreakSpeed event) {
        if (!Config.hoeCrook || !(event.getState().func_177230_c() instanceof BlockLeaves)) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player == null || player.field_71075_bZ.field_75098_d) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        Item item = stack.func_77973_b();
        if (!(item instanceof ItemHoe) && !item.getToolClasses(stack).contains("hoe")) {
            return;
        }
        event.setNewSpeed(2.0f);
    }
}

