/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.util.TextureBlockUtil;
import knightminer.inspirations.recipes.client.BoilingParticle;
import knightminer.inspirations.recipes.tileentity.TileCauldron;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.property.PropertyString;

public class BlockEnhancedCauldron
extends BlockCauldron
implements ITileEntityProvider {
    public static final PropertyEnum<CauldronContents> CONTENTS = PropertyEnum.func_177709_a((String)"contents", CauldronContents.class);
    public static final PropertyInteger LEVELS = PropertyInteger.func_177719_a((String)"levels", (int)0, (int)4);
    public static final PropertyBool BOILING = PropertyBool.func_177716_a((String)"boiling");
    public static final PropertyString TEXTURE = TextureBlockUtil.TEXTURE_PROP;
    public static final AxisAlignedBB[] BOUNDS = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.1875, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.25, 0.1875, 0.125), new AxisAlignedBB(0.0, 0.0, 0.125, 0.125, 0.1875, 0.25), new AxisAlignedBB(0.75, 0.0, 0.0, 1.0, 0.1875, 0.125), new AxisAlignedBB(0.875, 0.0, 0.125, 1.0, 0.1875, 0.25), new AxisAlignedBB(0.0, 0.0, 0.875, 0.25, 0.1875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.75, 0.125, 0.1875, 0.875), new AxisAlignedBB(0.75, 0.0, 0.875, 1.0, 0.1875, 1.0), new AxisAlignedBB(0.875, 0.0, 0.75, 1.0, 0.1875, 0.875)};

    public BlockEnhancedCauldron() {
        IBlockState state = this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176591_a, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)BOILING, (Comparable)Boolean.valueOf(false)).func_177226_a(CONTENTS, (Comparable)((Object)CauldronContents.FLUID));
        if (Config.enableBiggerCauldron) {
            state = state.func_177226_a((IProperty)LEVELS, (Comparable)Integer.valueOf(0));
        }
        this.func_180632_j(state);
        this.func_149711_c(2.0f);
        this.func_149663_c("cauldron");
        this.field_149758_A = true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileCauldron();
    }

    public void func_176224_k(World world, BlockPos pos) {
        IBlockState state;
        int level;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileCauldron && !((TileCauldron)te).isWater()) {
            return;
        }
        if ((Config.fasterCauldronRain || world.field_73012_v.nextInt(20) == 0) && world.func_72959_q().func_76939_a(world.func_180494_b(pos).func_180626_a(pos), pos.func_177956_o()) >= 0.15f && (level = this.getLevel(state = world.func_180495_p(pos))) < (Config.enableBiggerCauldron ? 4 : 3)) {
            this.func_176590_a(world, pos, state, level + 1);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        int newLevel;
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileCauldron)) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        int level = this.getLevel(state);
        float f = (float)pos.func_177956_o() + ((Config.enableBiggerCauldron ? 2.5f : 5.5f) + (float)(3 * Math.max(level, 1))) / 16.0f;
        if (entity.func_174813_aQ().field_72338_b <= (double)f && level != (newLevel = ((TileCauldron)te).onEntityCollide(entity, level, state))) {
            this.func_176590_a(world, pos, state, newLevel);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        int level = this.getLevel(state);
        if (!Config.dropCauldronContents || level == 0) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileCauldron) {
            ((TileCauldron)te).onBreak(pos, level);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
        return world.func_180495_p(pos).func_177230_c() != Blocks.field_150383_bp;
    }

    protected ExtendedBlockState createBlockState() {
        if (Config.enableBiggerCauldron) {
            return new ExtendedBlockState((Block)this, new IProperty[]{field_176591_a, LEVELS, CONTENTS, BOILING}, new IUnlistedProperty[]{TEXTURE});
        }
        return new ExtendedBlockState((Block)this, new IProperty[]{field_176591_a, CONTENTS, BOILING}, new IUnlistedProperty[]{TEXTURE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileCauldron) {
            state = state.func_177226_a(CONTENTS, (Comparable)((Object)((TileCauldron)te).getContentType()));
        }
        return state;
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedState = (IExtendedBlockState)state;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileCauldron) {
            return ((TileCauldron)te).writeExtendedBlockState(extendedState);
        }
        return super.getExtendedState(state, world, pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        BlockEnhancedCauldron.setBoiling(world, pos, state);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        BlockEnhancedCauldron.setBoiling(world, pos, state);
    }

    private static void setBoiling(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)BOILING, (Comparable)Boolean.valueOf(InspirationsRegistry.isCauldronFire(world.func_180495_p(pos.func_177977_b())))));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (!((Boolean)state.func_177229_b((IProperty)BOILING)).booleanValue()) {
            return;
        }
        int level = this.getLevel(state);
        if (level == 0) {
            return;
        }
        ParticleManager manager = Minecraft.func_71410_x().field_71452_i;
        for (int i = 0; i < 2; ++i) {
            double x = (double)pos.func_177958_n() + 0.1875 + (double)rand.nextFloat() * 0.625;
            double y = (double)pos.func_177956_o() + (Config.enableBiggerCauldron ? 0.1875 : 0.375) + (double)level * 0.1875;
            double z = (double)pos.func_177952_p() + 0.1875 + (double)rand.nextFloat() * 0.625;
            manager.func_78873_a((Particle)new BoilingParticle(world, x, y, z, 0.0, 0.0, 0.0));
        }
    }

    public void func_176590_a(World worldIn, BlockPos pos, IBlockState state, int level) {
        if (Config.enableBiggerCauldron) {
            state = state.func_177226_a((IProperty)LEVELS, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)level, (int)0, (int)4)));
        }
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_176591_a, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)level, (int)0, (int)3))), 2);
        worldIn.func_175666_e(pos, (Block)this);
    }

    public static int getCauldronLevel(IBlockState state) {
        Block block = state.func_177230_c();
        if (state.func_177230_c() instanceof BlockEnhancedCauldron) {
            return ((BlockEnhancedCauldron)block).getLevel(state);
        }
        return (Integer)state.func_177229_b((IProperty)field_176591_a);
    }

    public int getLevel(IBlockState state) {
        if (Config.enableBiggerCauldron) {
            return (Integer)state.func_177229_b((IProperty)LEVELS);
        }
        return (Integer)state.func_177229_b((IProperty)field_176591_a);
    }

    public int func_180641_l(IBlockState state, World worldIn, BlockPos pos) {
        return this.getLevel(state);
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)field_176591_a, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)(meta & 7), (int)0, (int)3)));
        if (Config.enableBiggerCauldron) {
            state = state.func_177226_a((IProperty)LEVELS, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)(meta & 7), (int)0, (int)4)));
        }
        state = state.func_177226_a((IProperty)BOILING, (Comparable)Boolean.valueOf((meta & 8) > 0));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        return this.getLevel(state) | ((Boolean)state.func_177229_b((IProperty)BOILING) != false ? 8 : 0);
    }

    @Deprecated
    public RayTraceResult func_180636_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : BOUNDS) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult closest = null;
        double max = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double distance;
            if (raytraceresult == null || !((distance = raytraceresult.field_72307_f.func_72436_e(end)) > max)) continue;
            closest = raytraceresult;
            max = distance;
        }
        return closest;
    }

    public static enum CauldronContents implements IStringSerializable
    {
        FLUID,
        DYE,
        POTION;

        private int meta = this.ordinal();

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.US);
        }

        public int getMeta() {
            return this.meta;
        }

        public static CauldronContents fromMeta(int meta) {
            if (meta > CauldronContents.values().length) {
                meta = 0;
            }
            return CauldronContents.values()[meta];
        }
    }
}

