/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.plugins.jei.cauldron.ingredient;

import java.util.ArrayList;
import java.util.List;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.client.ClientUtil;
import knightminer.inspirations.plugins.jei.cauldron.CauldronRecipeCategory;
import knightminer.inspirations.plugins.jei.cauldron.ingredient.DyeIngredient;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.ResourceLocation;

public enum DyeIngredientRenderer implements IIngredientRenderer<DyeIngredient>
{
    INVENTORY,
    LEVEL_1,
    LEVEL_2,
    LEVEL_3,
    LEVEL_4,
    INVALID;

    private int level = this.ordinal();
    public static final ResourceLocation DYE_TEXTURE;

    public static DyeIngredientRenderer forLevel(int level) {
        if (level < 1 || level > 4 || level == 4 && !Config.enableBiggerCauldron) {
            level = 5;
        }
        return DyeIngredientRenderer.values()[level];
    }

    public void render(Minecraft minecraft, int x, int y, DyeIngredient dye) {
        if (dye == null || this.level == 4) {
            return;
        }
        GlStateManager.func_179147_l();
        minecraft.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        float[] color = dye.getDye().func_193349_f();
        GlStateManager.func_179124_c((float)color[0], (float)color[1], (float)color[2]);
        TextureAtlasSprite sprite = ClientUtil.getSprite(DYE_TEXTURE);
        if (this.level == 0) {
            ClientUtil.renderFilledSprite(sprite, x, y, 16, 16);
        } else {
            int height = 10 * this.level / InspirationsRegistry.getCauldronMax();
            ClientUtil.renderFilledSprite(sprite, x, y, 10, height);
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
    }

    public List<String> getTooltip(Minecraft minecraft, DyeIngredient ingredient, ITooltipFlag tooltipFlag) {
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add(Util.translateFormatted("gui.jei.cauldron.color", Util.translate("item.fireworksCharge.%s", ingredient.getDye().func_176762_d())));
        CauldronRecipeCategory.addLevelTooltip(this.level, tooltip);
        return tooltip;
    }

    static {
        DYE_TEXTURE = Util.getResource("blocks/fluid_colorless");
    }
}

