/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.client;

import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.library.ItemMetaKey;
import knightminer.inspirations.library.util.TextureBlockUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.math.NumberUtils;
import slimeknights.mantle.client.ModelHelper;

@SideOnly(value=Side.CLIENT)
public final class ClientUtil {
    public static final String TAG_TEXTURE_PATH = "texture_path";
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static Map<ItemMetaKey, Integer> colorCache = new HashMap<ItemMetaKey, Integer>();
    private static Set<Item> unsafe = new HashSet<Item>();

    private ClientUtil() {
    }

    public static int getStackColor(ItemStack stack) {
        return colorCache.computeIfAbsent(new ItemMetaKey(stack), ClientUtil::getStackColor);
    }

    private static Integer getStackColor(ItemMetaKey key) {
        IBakedModel model = mc.func_175599_af().func_184393_a(key.makeItemStack(), null, null);
        if (model == null) {
            return -1;
        }
        TextureAtlasSprite sprite = model.func_177554_e();
        if (sprite == null) {
            return -1;
        }
        int[] pixels = sprite.func_147965_a(0)[0];
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float count = 0.0f;
        float[] hsb = new float[3];
        for (int argb : pixels) {
            int ca = argb >> 24 & 0xFF;
            int cr = argb >> 16 & 0xFF;
            int cg = argb >> 8 & 0xFF;
            int cb = argb & 0xFF;
            if (ca <= 127 || NumberUtils.max((int)cr, (int)cg, (int)cb) <= 31) continue;
            Color.RGBtoHSB(ca, cr, cg, hsb);
            float weight = hsb[1];
            r += (float)cr * weight;
            g += (float)cg * weight;
            b += (float)cb * weight;
            count += weight;
        }
        if (count > 0.0f) {
            r /= count;
            g /= count;
            b /= count;
        }
        return 0xFF000000 | (int)r << 16 | (int)g << 8 | (int)b;
    }

    public static void onResourceReload(IResourceManager manager) {
        colorCache.clear();
    }

    public static TextureAtlasSprite getSprite(ResourceLocation location) {
        TextureMap textureMapBlocks = mc.func_147117_R();
        TextureAtlasSprite sprite = null;
        if (location != null) {
            sprite = textureMapBlocks.getTextureExtry(location.toString());
        }
        if (sprite == null) {
            sprite = textureMapBlocks.func_174944_f();
        }
        return sprite;
    }

    public static void renderFilledSprite(TextureAtlasSprite sprite, int x, int y, int size, int filled) {
        double uMin = sprite.func_94209_e();
        double uMax = sprite.func_94212_f();
        double vMin = sprite.func_94206_g();
        double vMax = sprite.func_94210_h();
        uMax -= (double)(16 - size) / 16.0 * (uMax - uMin);
        vMax -= (double)(16 - filled) / 16.0 * (vMax - vMin);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b((double)x, (double)(y + size), 100.0).func_187315_a(uMin, vMax).func_181675_d();
        bufferBuilder.func_181662_b((double)(x + size), (double)(y + size), 100.0).func_187315_a(uMax, vMax).func_181675_d();
        bufferBuilder.func_181662_b((double)(x + size), (double)(y + size - filled), 100.0).func_187315_a(uMax, vMin).func_181675_d();
        bufferBuilder.func_181662_b((double)x, (double)(y + size - filled), 100.0).func_187315_a(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }

    public static String getTexturePath(TileEntity te) {
        ItemStack stack;
        String texture = te.getTileData().func_74779_i(TAG_TEXTURE_PATH);
        if (texture.isEmpty() && !(stack = new ItemStack(te.getTileData().func_74775_l("texture"))).func_190926_b()) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            texture = ModelHelper.getTextureFromBlock((Block)block, (int)stack.func_77973_b().getMetadata(stack)).func_94215_i();
            te.getTileData().func_74778_a(TAG_TEXTURE_PATH, texture);
        }
        return texture;
    }

    public static IBlockState writeTextureBlockState(IBlockAccess world, BlockPos pos, IBlockState state) {
        String texture;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && !(texture = ClientUtil.getTexturePath(te)).isEmpty()) {
            state = ((IExtendedBlockState)state).withProperty((IUnlistedProperty)TextureBlockUtil.TEXTURE_PROP, (Object)texture);
        }
        return state;
    }

    public static int getStackBlockColorsSafe(ItemStack stack, @Nullable IBlockAccess world, @Nullable BlockPos pos, int index) {
        if (stack.func_190926_b()) {
            return -1;
        }
        Item item = stack.func_77973_b();
        if (!unsafe.contains(item)) {
            try {
                return ClientUtil.getStackBlockColors(stack, world, pos, index);
            }
            catch (Exception e) {
                Inspirations.log.error(String.format("Caught exception getting block colors for %s", item.getRegistryName()), (Throwable)e);
                unsafe.add(item);
            }
        }
        return mc.getItemColors().func_186728_a(stack, index);
    }

    public static int getStackBlockColors(ItemStack stack, @Nullable IBlockAccess world, @Nullable BlockPos pos, int index) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBlock)) {
            return -1;
        }
        ItemBlock item = (ItemBlock)stack.func_77973_b();
        IBlockState iblockstate = item.func_179223_d().func_176203_a(item.getMetadata(stack));
        return mc.func_184125_al().func_186724_a(iblockstate, world, pos, index);
    }
}

