/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.util.ReflectionUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Util {
    public static String resource(String name) {
        return String.format("%s:%s", "inspirations", name.toLowerCase(Locale.US));
    }

    public static String prefix(String name) {
        return String.format("%s.%s", "inspirations", name.toLowerCase(Locale.US));
    }

    public static ResourceLocation getResource(String res) {
        return new ResourceLocation("inspirations", res);
    }

    public static String translate(String key, Object ... pars) {
        return I18n.func_74838_a((String)I18n.func_74838_a((String)String.format(key, pars)).trim()).trim();
    }

    public static String translateFormatted(String key, Object ... pars) {
        return I18n.func_74838_a((String)I18n.func_74837_a((String)key, (Object[])pars).trim()).trim();
    }

    public static Logger getLogger(String type) {
        String log = "inspirations";
        return LogManager.getLogger((String)(log + "-" + type));
    }

    public static boolean clickedAABB(AxisAlignedBB aabb, float hitX, float hitY, float hitZ) {
        return aabb.field_72340_a <= (double)hitX && (double)hitX <= aabb.field_72336_d && aabb.field_72338_b <= (double)hitY && (double)hitY <= aabb.field_72337_e && aabb.field_72339_c <= (double)hitZ && (double)hitZ <= aabb.field_72334_f;
    }

    public static ItemStack getStackFromState(@Nullable IBlockState state) {
        if (state == null) {
            return ItemStack.field_190927_a;
        }
        Block block = state.func_177230_c();
        if (block == Blocks.field_150350_a) {
            return ItemStack.field_190927_a;
        }
        ItemStack drop = ReflectionUtil.invokeGetSilkTouchDrop(block, state);
        if (drop != null) {
            return drop;
        }
        InspirationsRegistry.log.error("Failed to get silk touch drop for {}, using fallback", (Object)state);
        Item item = Item.func_150898_a((Block)block);
        if (item == Items.field_190931_a) {
            return ItemStack.field_190927_a;
        }
        int meta = block.func_180651_a(state);
        return new ItemStack(item, 1, meta);
    }

    @SafeVarargs
    public static <E> NonNullList<E> createNonNullList(E ... elements) {
        NonNullList list = NonNullList.func_191196_a();
        list.addAll(Arrays.asList(elements));
        return list;
    }

    public static int combineColors(int color1, int color2, int scale) {
        if (scale == 0) {
            return color1;
        }
        int a = color1 >> 24 & 0xFF;
        int r = color1 >> 16 & 0xFF;
        int g = color1 >> 8 & 0xFF;
        int b = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        for (int i = 0; i < scale; ++i) {
            a = (int)Math.sqrt(a * a2);
            r = (int)Math.sqrt(r * r2);
            g = (int)Math.sqrt(g * g2);
            b = (int)Math.sqrt(b * b2);
        }
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static float[] getColorComponents(int color) {
        int i = (color & 0xFFFFFF) >> 16;
        int j = (color & 0xFFFF) >> 8;
        int k = color & 0xFF;
        return new float[]{(float)i / 255.0f, (float)j / 255.0f, (float)k / 255.0f};
    }

    public static void addPotionTooltip(PotionType potionType, List<String> lores) {
        List effects = potionType.func_185170_a();
        if (effects.isEmpty()) {
            String s = Util.translate("effect.none", new Object[0]).trim();
            lores.add(TextFormatting.GRAY + s);
            return;
        }
        for (PotionEffect effect : effects) {
            String effectString = Util.translate(effect.func_76453_d(), new Object[0]).trim();
            Potion potion = effect.func_188419_a();
            if (effect.func_76458_c() > 0) {
                effectString = effectString + " " + Util.translate("potion.potency." + effect.func_76458_c(), new Object[0]).trim();
            }
            if (effect.func_76459_b() > 20) {
                effectString = effectString + " (" + Potion.func_188410_a((PotionEffect)effect, (float)1.0f) + ")";
            }
            lores.add((potion.func_76398_f() ? TextFormatting.RED : TextFormatting.BLUE) + effectString);
        }
    }

    public static EnumDyeColor getDyeForColor(int color) {
        for (EnumDyeColor dyeColor : EnumDyeColor.values()) {
            if (dyeColor.field_193351_w != color) continue;
            return dyeColor;
        }
        return null;
    }
}

