/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.block;

import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.mantle.client.CreativeTab;

public class BlockPath
extends EnumBlock<PathType> {
    public static final PropertyEnum<PathType> TYPE = PropertyEnum.func_177709_a((String)"type", PathType.class);
    protected static final AxisAlignedBB BOUNDS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);

    public BlockPath() {
        super(Material.field_151576_e, TYPE, PathType.class);
        this.func_149647_a(CreativeTab.field_78031_c);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.canBlockStay(worldIn, pos);
    }

    private boolean canBlockStay(World world, BlockPos pos) {
        BlockPos down = pos.func_177977_b();
        return world.func_180495_p(down).func_193401_d((IBlockAccess)world, down, EnumFacing.UP) == BlockFaceShape.SOLID;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public static enum PathType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        ROCKS,
        ROUND,
        TILES,
        BRICKS;

        private int meta = this.ordinal();

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

