/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.block;

import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFlower
extends BlockBush
implements IGrowable {
    public static final PropertyEnum<FlowerType> TYPE = PropertyEnum.func_177709_a((String)"type", FlowerType.class);

    public BlockFlower() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)FlowerType.ROSE)));
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)FlowerType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((FlowerType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    public int func_180651_a(IBlockState state) {
        return ((FlowerType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (FlowerType type : FlowerType.values()) {
            items.add((Object)new ItemStack((Block)this, 1, type.getMeta()));
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return super.func_185496_a(state, source, pos).func_191194_a(state.func_191059_e(source, pos));
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return state.func_177229_b(TYPE) != FlowerType.CYAN;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        BlockDoublePlant.EnumPlantType type = ((FlowerType)((Object)state.func_177229_b(TYPE))).getDouble();
        if (type == null) {
            return;
        }
        if (worldIn.func_175623_d(pos.func_177984_a())) {
            Blocks.field_150398_cm.func_176491_a(worldIn, pos, type, 2);
        }
    }

    public static enum FlowerType implements IStringSerializable
    {
        ROSE(BlockDoublePlant.EnumPlantType.ROSE),
        SYRINGA(BlockDoublePlant.EnumPlantType.SYRINGA),
        PAEONIA(BlockDoublePlant.EnumPlantType.PAEONIA),
        CYAN(null);

        private final BlockDoublePlant.EnumPlantType big;
        private final int meta = this.ordinal();

        private FlowerType(BlockDoublePlant.EnumPlantType big) {
            this.big = big;
        }

        public int getMeta() {
            return this.meta;
        }

        public static FlowerType fromMeta(int meta) {
            if (meta < 0 || meta >= FlowerType.values().length) {
                meta = 0;
            }
            return FlowerType.values()[meta];
        }

        @Nullable
        public BlockDoublePlant.EnumPlantType getDouble() {
            return this.big;
        }

        @Nullable
        public static FlowerType fromDouble(@Nonnull BlockDoublePlant.EnumPlantType big) {
            for (FlowerType type : FlowerType.values()) {
                if (big != type.getDouble()) continue;
                return type;
            }
            return null;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

