/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.UUID;
import journeymap.common.network.impl.MessageProcessor;
import journeymap.common.network.impl.Response;
import journeymap.server.JourneymapServer;
import journeymap.server.properties.GlobalProperties;
import journeymap.server.properties.PropertiesManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class GetPlayerLocations
extends MessageProcessor {
    @Override
    protected JsonObject onServer(Response response) {
        GlobalProperties prop = PropertiesManager.getInstance().getGlobalProperties();
        boolean sendToEveryone = prop.playerTrackingEnabled.get();
        boolean sendToOps = prop.opPlayerTrackingEnabled.get();
        EntityPlayerMP player = response.getContext().getServerHandler().field_147369_b;
        if (sendToEveryone || sendToOps && JourneymapServer.isOp((EntityPlayer)player)) {
            return this.getPlayerList(player);
        }
        return null;
    }

    @Override
    protected JsonObject onClient(Response response) {
        return null;
    }

    private JsonObject getPlayerList(EntityPlayerMP entityPlayerMP) {
        int receiverDimension = entityPlayerMP.field_71093_bK;
        boolean receiverOp = JourneymapServer.isOp((EntityPlayer)entityPlayerMP);
        JsonArray playerList = new JsonArray();
        List serverPlayers = null;
        JsonObject players = new JsonObject();
        serverPlayers = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
        if (serverPlayers != null || serverPlayers.size() > 1) {
            for (EntityPlayerMP playerMp : serverPlayers) {
                boolean sneaking = playerMp.func_70093_af();
                int dimension = playerMp.field_71093_bK;
                UUID playerId = playerMp.func_110124_au();
                if (receiverOp) {
                    sneaking = false;
                }
                JsonObject player = new JsonObject();
                player.addProperty("name", playerMp.func_70005_c_());
                player.addProperty("posX", (Number)playerMp.func_180425_c().func_177958_n());
                player.addProperty("posY", (Number)playerMp.func_180425_c().func_177956_o());
                player.addProperty("posZ", (Number)playerMp.func_180425_c().func_177952_p());
                player.addProperty("chunkX", (Number)playerMp.field_70176_ah);
                player.addProperty("chunkY", (Number)playerMp.field_70162_ai);
                player.addProperty("chunkZ", (Number)playerMp.field_70164_aj);
                player.addProperty("rotation", (Number)Float.valueOf(playerMp.field_70759_as));
                player.addProperty("sneaking", Boolean.valueOf(sneaking));
                player.addProperty("playerId", playerId.toString());
                if (entityPlayerMP.func_110124_au().equals(playerId) || sneaking || receiverDimension != dimension) continue;
                playerList.add((JsonElement)player);
            }
        }
        int updateTime = PropertiesManager.getInstance().getGlobalProperties().playerTrackingUpdateTime.get();
        boolean userTrack = PropertiesManager.getInstance().getGlobalProperties().playerTrackingEnabled.get();
        boolean opTrack = PropertiesManager.getInstance().getGlobalProperties().opPlayerTrackingEnabled.get();
        players.addProperty("tracking_time", (Number)updateTime);
        players.addProperty("can_track", Boolean.valueOf(userTrack || receiverOp && opTrack));
        players.add("players", (JsonElement)playerList);
        return players;
    }
}

