/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.thread;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import journeymap.client.thread.PlayerRadarManager;
import journeymap.common.Journeymap;
import journeymap.common.network.GetPlayerLocations;
import journeymap.common.thread.JMThreadFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;

public class GetAllPlayersThread
implements Runnable {
    private static ExecutorService es;
    private int updateTime = 1000;
    private static boolean alive;

    @Override
    public void run() {
        while (Minecraft.func_71410_x() != null) {
            try {
                if (Journeymap.getClient().isJourneyMapServerConnection() && Journeymap.getClient().isPlayerTrackingEnabled() && !Minecraft.func_71410_x().func_71356_B() && Journeymap.getClient().isMapping().booleanValue()) {
                    new GetPlayerLocations().send(result -> {
                        JsonArray playerList = result.getAsJson().get("players").getAsJsonArray();
                        this.updateTime = result.getAsJson().get("tracking_time").getAsInt();
                        Journeymap.getClient().setPlayerTrackingEnabled(result.getAsJson().get("can_track").getAsBoolean());
                        ArrayList entityPlayerList = Lists.newArrayList();
                        for (JsonElement p : playerList) {
                            JsonObject player = p.getAsJsonObject();
                            EntityPlayer entityPlayer = this.buildEntityPlayer(player);
                            if (entityPlayer == null) continue;
                            entityPlayerList.add(entityPlayer);
                        }
                        this.updatePlayerList(entityPlayerList);
                    });
                } else {
                    this.updateTime = 10000;
                }
                Thread.sleep(this.updateTime);
            }
            catch (InterruptedException e) {
                alive = false;
                Thread.currentThread().interrupt();
            }
        }
    }

    private void updatePlayerList(List<EntityPlayer> entityPlayerList) {
        boolean inBothLists;
        for (EntityPlayer player : entityPlayerList) {
            inBothLists = PlayerRadarManager.getInstance().getPlayers().stream().anyMatch(p -> p.func_110124_au().equals(player.func_110124_au()));
            if (inBothLists) continue;
            PlayerRadarManager.getInstance().addPlayer(player);
        }
        Iterator<EntityPlayer> iterator = PlayerRadarManager.getInstance().getPlayers().iterator();
        while (iterator.hasNext()) {
            EntityPlayer player;
            player = iterator.next();
            inBothLists = entityPlayerList.stream().anyMatch(p -> p.func_110124_au().equals(player.func_110124_au()));
            if (inBothLists) {
                EntityPlayer playerMp = entityPlayerList.stream().filter(p -> p.func_110124_au().equals(player.func_110124_au())).findFirst().orElse(null);
                if (playerMp == null) continue;
                player.field_70165_t = playerMp.field_70165_t;
                player.field_70163_u = playerMp.field_70163_u;
                player.field_70161_v = playerMp.field_70161_v;
                player.field_70176_ah = playerMp.field_70176_ah;
                player.field_70162_ai = playerMp.field_70162_ai;
                player.field_70164_aj = playerMp.field_70164_aj;
                player.field_70759_as = playerMp.field_70759_as;
                player.func_70095_a(playerMp.func_70093_af());
                continue;
            }
            iterator.remove();
        }
    }

    private EntityPlayer buildEntityPlayer(JsonObject player) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        UUID playerUUID = UUID.fromString(player.get("playerId").getAsString());
        String playerName = player.get("name").getAsString();
        if (!playerUUID.equals(mc.field_71439_g.func_110124_au())) {
            EntityOtherPlayerMP playerMp = new EntityOtherPlayerMP((World)mc.field_71441_e, new GameProfile(playerUUID, playerName));
            playerMp.field_70165_t = player.get("posX").getAsInt();
            playerMp.field_70163_u = player.get("posY").getAsInt();
            playerMp.field_70161_v = player.get("posZ").getAsInt();
            playerMp.field_70176_ah = player.get("chunkX").getAsInt();
            playerMp.field_70162_ai = player.get("chunkY").getAsInt();
            playerMp.field_70164_aj = player.get("chunkZ").getAsInt();
            playerMp.field_70759_as = player.get("rotation").getAsFloat();
            playerMp.func_70095_a(player.get("sneaking").getAsBoolean());
            playerMp.func_184221_a(playerUUID);
            playerMp.field_70175_ag = true;
            return playerMp;
        }
        return null;
    }

    public static void stop() {
        if (alive) {
            alive = false;
            es.shutdown();
        }
    }

    public static void start() {
        if (!alive) {
            alive = true;
            GetAllPlayersThread runnable = new GetAllPlayersThread();
            JMThreadFactory tf = new JMThreadFactory("player_track");
            es = Executors.newSingleThreadExecutor(tf);
            es.execute(runnable);
            Runtime.getRuntime().addShutdownHook(tf.newThread(() -> {
                alive = false;
                es.shutdown();
            }));
        }
    }

    static {
        alive = false;
    }
}

