/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.items.armor;

import java.util.List;
import javax.annotation.Nullable;
import net.foxmcloud.draconicadditions.DAFeatures;
import net.foxmcloud.draconicadditions.items.armor.ArmorStats;
import net.foxmcloud.draconicadditions.items.armor.PotatoArmor;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InfusedPotatoArmor
extends ItemArmor {
    private static ItemArmor.ArmorMaterial potatoMaterial = EnumHelper.addArmorMaterial((String)"infusedPotatoArmor", (String)"draconicadditions:infused_potato_armor", (int)-1, (int[])new int[]{1, 1, 2, 1}, (int)0, (SoundEvent)SoundEvents.field_187728_s, (float)0.0f);

    public InfusedPotatoArmor(int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(potatoMaterial, renderIndexIn, equipmentSlotIn);
        this.func_77656_e(-1);
    }

    public InfusedPotatoArmor(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
        this.func_77656_e(-1);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (ArmorStats.INFUSED_POTATO_RIGHT_CLICK) {
            return new ActionResult(EnumActionResult.FAIL, (Object)this.transformItem(player, hand, false));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (ArmorStats.INFUSED_POTATO_RIGHT_CLICK) {
            this.transformItem(player, hand, true);
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (ArmorStats.INFUSED_POTATO_RIGHT_CLICK) {
            this.transformItem(player, stack, true);
        }
        return false;
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        if (ArmorStats.INFUSED_POTATO_DROP) {
            this.transformItem(player, stack, true);
            return false;
        }
        return true;
    }

    private ItemStack transformItem(EntityPlayer player, EnumHand hand, boolean replace) {
        ItemStack itemStack = player.func_184586_b(hand);
        return this.transformItem(player, itemStack, replace);
    }

    private ItemStack transformItem(EntityPlayer player, ItemStack stack, boolean replace) {
        PotatoArmor armor;
        ItemArmor item = (ItemArmor)stack.func_77973_b();
        EntityEquipmentSlot slot = item.func_185083_B_();
        if (slot.equals((Object)EntityEquipmentSlot.HEAD)) {
            armor = DAFeatures.potatoHelm;
        } else if (slot.equals((Object)EntityEquipmentSlot.CHEST)) {
            armor = DAFeatures.potatoChest;
        } else if (slot.equals((Object)EntityEquipmentSlot.LEGS)) {
            armor = DAFeatures.potatoLegs;
        } else if (slot.equals((Object)EntityEquipmentSlot.FEET)) {
            armor = DAFeatures.potatoBoots;
        } else {
            throw new Error("Something's wrong with the G-Diffuser!  This doesn't look like a valid Potato Armor...");
        }
        ItemStack armorItem = new ItemStack((Item)armor);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74776_a("Energy", (float)ArmorStats.POTATO_BASE_CAPACITY);
        armorItem.func_77982_d(nbt);
        player.field_71071_by.func_184437_d(stack);
        if (replace) {
            player.func_191521_c(armorItem);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("msg.da.infusedTransformation.smack", new Object[0]), true);
        } else {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("msg.da.infusedTransformation.normal", new Object[0]), true);
        }
        return armorItem;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"item.draconicadditions:infused_potato.lore", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"item.draconicadditions:infused_potato.lore2", (Object[])new Object[0]));
    }
}

