/*
 * Decompiled with CFR 0.152.
 */
package wolforce.registry.client;

import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import wolforce.Main;
import wolforce.Util;
import wolforce.blocks.BlockBox;
import wolforce.blocks.BlockCore;
import wolforce.blocks.tile.TileBranch;
import wolforce.blocks.tile.TileCharger;
import wolforce.blocks.tile.TileGraftingTray;
import wolforce.blocks.tile.TileGritVase;
import wolforce.blocks.tile.TileInertSeed;
import wolforce.blocks.tile.TilePickerHolder;
import wolforce.blocks.tile.TileSeparator;
import wolforce.blocks.tile.TileStatue;
import wolforce.blocks.tile.TileTray;
import wolforce.client.CustomBoxStateMapper;
import wolforce.client.CustomCoreStateMapper;
import wolforce.client.FluidStateMapper;
import wolforce.client.TesrBranch;
import wolforce.client.TesrCharger;
import wolforce.client.TesrGraftingTray;
import wolforce.client.TesrGritVase;
import wolforce.client.TesrInertSeed;
import wolforce.client.TesrPickerHolder;
import wolforce.client.TesrSeparator;
import wolforce.client.TesrStatue;
import wolforce.client.TesrTray;
import wolforce.client.models.power.RenderPower;
import wolforce.entities.EntityPower;

@Mod.EventBusSubscriber(modid="hwell", value={Side.CLIENT})
public class RegisterModels {
    public static void preInit() {
        IRenderFactory<EntityPower> fac = new IRenderFactory<EntityPower>(){

            public Render<? super EntityPower> createRenderFor(RenderManager manager) {
                return new RenderPower(manager, Util.res("textures/entity/power.png"));
            }
        };
        RenderingRegistry.registerEntityRenderingHandler(EntityPower.class, (IRenderFactory)fac);
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (Item item : Main.items) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
        for (Block block : Main.blocks) {
            Item itemBlock = Item.func_150898_a((Block)block);
            ModelLoader.setCustomModelResourceLocation((Item)itemBlock, (int)0, (ModelResourceLocation)new ModelResourceLocation(itemBlock.getRegistryName(), "inventory"));
        }
        for (BlockBox box : Main.boxes) {
            CustomBoxStateMapper mapper = new CustomBoxStateMapper(box.block.getRegistryName(), box.hasAxis, box.isCore(box.block));
            RegisterModels.customRegisterRenders((Block)box, box.block.getRegistryName(), (IStateMapper)mapper);
        }
        for (Map.Entry entry : Main.custom_cores.entrySet()) {
            BlockCore core = (BlockCore)entry.getValue();
            CustomCoreStateMapper mapper = new CustomCoreStateMapper(new ResourceLocation("hwell", "core_custom"));
            RegisterModels.customRegisterRenders(core, new ResourceLocation("hwell", "core_custom"), (IStateMapper)mapper);
            CustomCoreStateMapper mapperGraft = new CustomCoreStateMapper(new ResourceLocation("hwell", "graft_custom"));
            Block graft = Main.custom_grafts.get(core);
            RegisterModels.customRegisterRenders(graft, new ResourceLocation("hwell", "graft_custom"), (IStateMapper)mapperGraft);
        }
        RegisterModels.mapFluidState(Main.liquid_souls_block, Main.liquid_souls);
        ClientRegistry.bindTileEntitySpecialRenderer(TileSeparator.class, (TileEntitySpecialRenderer)new TesrSeparator());
        ClientRegistry.bindTileEntitySpecialRenderer(TileCharger.class, (TileEntitySpecialRenderer)new TesrCharger());
        ClientRegistry.bindTileEntitySpecialRenderer(TilePickerHolder.class, (TileEntitySpecialRenderer)new TesrPickerHolder());
        ClientRegistry.bindTileEntitySpecialRenderer(TileStatue.class, (TileEntitySpecialRenderer)new TesrStatue());
        ClientRegistry.bindTileEntitySpecialRenderer(TileTray.class, (TileEntitySpecialRenderer)new TesrTray());
        ClientRegistry.bindTileEntitySpecialRenderer(TileGritVase.class, (TileEntitySpecialRenderer)new TesrGritVase());
        ClientRegistry.bindTileEntitySpecialRenderer(TileInertSeed.class, (TileEntitySpecialRenderer)new TesrInertSeed());
        ClientRegistry.bindTileEntitySpecialRenderer(TileGraftingTray.class, (TileEntitySpecialRenderer)new TesrGraftingTray());
        ClientRegistry.bindTileEntitySpecialRenderer(TileBranch.class, (TileEntitySpecialRenderer)new TesrBranch());
    }

    private static void customRegisterRenders(Block block, ResourceLocation resourceLocation, IStateMapper mapper) {
        Item itemBlock = Item.func_150898_a((Block)block);
        ModelLoader.setCustomModelResourceLocation((Item)itemBlock, (int)0, (ModelResourceLocation)new ModelResourceLocation(resourceLocation, "inventory"));
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
    }

    private static void mapFluidState(Block block, Fluid fluid) {
        Item item = Item.func_150898_a((Block)block);
        FluidStateMapper mapper = new FluidStateMapper(fluid);
        if (item != Items.field_190931_a) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
        }
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
    }
}

