/*
 * Decompiled with CFR 0.152.
 */
package wolforce.registry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import wolforce.Hwell;
import wolforce.HwellConfig;
import wolforce.Main;
import wolforce.Util;
import wolforce.base.MyBlock;
import wolforce.blocks.BlockCore;
import wolforce.items.ItemLoot;
import wolforce.items.ItemMystDust;
import wolforce.recipes.RecipeCharger;
import wolforce.recipes.RecipeCoring;
import wolforce.recipes.RecipeCrushing;
import wolforce.recipes.RecipeFreezer;
import wolforce.recipes.RecipeGrinding;
import wolforce.recipes.RecipeNetherPortal;
import wolforce.recipes.RecipePowerCrystal;
import wolforce.recipes.RecipePuller;
import wolforce.recipes.RecipeRepairingPaste;
import wolforce.recipes.RecipeSeedOfLife;
import wolforce.recipes.RecipeSeparator;
import wolforce.recipes.RecipeTube;

@Mod.EventBusSubscriber(modid="hwell")
public class RegisterRecipes {
    private static final String INNER_RECIPES_FILE = "recipes.json";
    public static boolean old_version_recipes_file = false;
    public static boolean errored_recipes_file = false;
    public static IRecipe recipePowerCrystal;
    public static String recipenr;

    public static void createNewCores() {
        Main.custom_cores = new HashMap();
        Main.custom_grafts = new HashMap();
        Main.graft_costs = new HashMap();
        Main.graft_costs.put(Main.core_stone, 100);
        Main.graft_costs.put(Main.core_anima, 750);
        Main.graft_costs.put(Main.core_heat, 300);
        Main.graft_costs.put(Main.core_green, 500);
        Main.graft_costs.put(Main.core_sentient, 1000);
        if (!HwellConfig.meta.customRecipesEnabled) {
            return;
        }
        try {
            File recipesFile = new File(HwellConfig.meta.recipeFileLocation);
            if (!recipesFile.exists()) {
                return;
            }
            JsonObject recipeJson = Util.readJson(HwellConfig.meta.recipeFileLocation, new boolean[0]).getAsJsonObject();
            if (!recipeJson.has("coring_recipes")) {
                return;
            }
            for (Map.Entry entry : recipeJson.getAsJsonObject("coring_recipes").entrySet()) {
                String nameid = (String)entry.getKey();
                if (RecipeCoring.getNormalCoreBlock(nameid) != null) continue;
                JsonObject recipes = ((JsonElement)entry.getValue()).getAsJsonObject();
                final String localizedName = recipes.get("name").getAsString();
                String colorString1 = recipes.get("base_color").getAsString();
                String colorString2 = recipes.get("border_color").getAsString();
                int graftCost = recipes.get("graft_cost").getAsInt();
                BlockCore newCore = new BlockCore(nameid, false, colorString1, colorString2){

                    public String func_149732_F() {
                        return localizedName;
                    }
                };
                System.out.println("created new core with registry name <" + nameid + "> and localized name <" + localizedName + ">.");
                Main.custom_cores.put(nameid, newCore);
                String temp = "" + localizedName;
                if (localizedName.endsWith(" Core")) {
                    temp = localizedName.substring(0, localizedName.indexOf(" Core"));
                }
                if (localizedName.endsWith(" core")) {
                    temp = localizedName.substring(0, localizedName.indexOf(" core"));
                }
                temp = temp + " Graft";
                final String graftLoc = "" + temp;
                MyBlock newGraft = new MyBlock("graft_" + nameid, Material.field_151576_e){

                    public String func_149732_F() {
                        return graftLoc;
                    }
                }.setHarvest("pickaxe", -1).setResistance(2.0f).setHardness(2.0f);
                Main.custom_grafts.put(newCore, newGraft);
                Main.graft_costs.put(newCore, graftCost);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        Main.burst_seed_crystal.stack = new ItemStack(Main.crystal_block);
        File recipesFile = new File(HwellConfig.meta.recipeFileLocation);
        if (!recipesFile.exists() && HwellConfig.meta.customRecipesEnabled) {
            try {
                RegisterRecipes.writeRecipesFile(HwellConfig.meta.recipeFileLocation);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not initialise the Recipes File!! Game will crash.");
            }
        }
        if (!HwellConfig.meta.customRecipesEnabled && recipesFile.exists()) {
            recipesFile.delete();
        }
        JsonObject recipes = null;
        JsonObject defaultRecipes = null;
        try {
            if (HwellConfig.meta.customRecipesEnabled) {
                recipes = Util.readJson(HwellConfig.meta.recipeFileLocation, new boolean[0]).getAsJsonObject();
            }
        }
        catch (Exception e) {
            System.err.println("Error while reading the Recipes File! Defaulting all recipes.");
            errored_recipes_file = true;
        }
        try {
            defaultRecipes = Util.readJson("/assets/hwell/recipes.json", true).getAsJsonObject();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (errored_recipes_file || recipes == null || !HwellConfig.meta.customRecipesEnabled) {
            recipes = defaultRecipes;
        }
        if (!recipes.has("version") || !recipes.get("version").getAsString().equals(defaultRecipes.get("version").getAsString())) {
            old_version_recipes_file = true;
        }
        recipenr = defaultRecipes.get("version").getAsString();
        String recipeName = "power_crystal_recipes";
        RecipePowerCrystal.initRecipes((recipes.has(recipeName) ? recipes : defaultRecipes).get(recipeName).getAsJsonObject());
        recipeName = "charger_recipes";
        RecipeCharger.initRecipes((recipes.has(recipeName) ? recipes : defaultRecipes).get(recipeName).getAsJsonArray());
        recipeName = "nether_portal_recipes";
        RecipeNetherPortal.initRecipes((recipes.has(recipeName) ? recipes : defaultRecipes).get(recipeName).getAsJsonArray());
        recipeName = "separator_recipes";
        RecipeSeparator.initRecipes((recipes.has(recipeName) ? recipes : defaultRecipes).get(recipeName).getAsJsonArray());
        recipeName = "freezer_recipes";
        RecipeFreezer.initRecipes((recipes.has(recipeName) ? recipes : defaultRecipes).get(recipeName).getAsJsonArray());
        recipeName = "puller_recipes";
        RecipePuller.initRecipes((recipes.has(recipeName) ? recipes : defaultRecipes).get(recipeName).getAsJsonArray());
        recipeName = "crushing_recipes";
        RecipeCrushing.initRecipes((recipes.has(recipeName) ? recipes : defaultRecipes).get(recipeName).getAsJsonArray());
        recipeName = "tube_recipes";
        RecipeTube.initRecipes((recipes.has(recipeName) ? recipes : defaultRecipes).get(recipeName).getAsJsonArray());
        recipeName = "grinding_recipes";
        RecipeGrinding.initRecipes((recipes.has(recipeName) ? recipes : defaultRecipes).get(recipeName).getAsJsonArray());
        recipeName = "repairing_paste_recipes";
        RecipeRepairingPaste.initRecipes((recipes.has(recipeName) ? recipes : defaultRecipes).get(recipeName).getAsJsonArray());
        recipeName = "coring_recipes";
        RecipeCoring.initRecipes((recipes.has(recipeName) ? recipes : defaultRecipes).get(recipeName).getAsJsonObject());
        recipeName = "seed_of_life_recipes";
        RecipeSeedOfLife.initRecipes((recipes.has(recipeName) ? recipes : defaultRecipes).get(recipeName).getAsJsonArray());
        recipeName = "myst_dust_recipes";
        ItemMystDust.initRecipes();
        Main.initShards();
        ItemLoot.setLootTables();
        GameRegistry.addSmelting((Block)Main.glowstone_ore, (ItemStack)new ItemStack(Items.field_151114_aO), (float)0.5f);
        GameRegistry.addSmelting((Block)Main.quartz_ore, (ItemStack)new ItemStack(Items.field_151128_bU), (float)0.5f);
        GameRegistry.addSmelting((Item)Main.heavy_mesh, (ItemStack)new ItemStack(Main.heavy_ingot, 2), (float)0.5f);
        GameRegistry.addSmelting((Block)Main.dust_block, (ItemStack)new ItemStack(Blocks.field_150359_w, 2), (float)0.0f);
        GameRegistry.addSmelting((Item)Main.leaf_mesh, (ItemStack)new ItemStack(Main.crystal_block, 1), (float)0.5f);
        GameRegistry.addSmelting((Block)Main.compressed_clay, (ItemStack)new ItemStack(Blocks.field_150405_ch, 9), (float)0.0f);
        GameRegistry.addSmelting((Block)Main.scorch_grit, (ItemStack)new ItemStack((Block)Main.scorch_glass), (float)0.0f);
        GameRegistry.addSmelting((Block)Main.gaseous_sand, (ItemStack)new ItemStack((Block)Main.gaseous_glass), (float)0.0f);
        GameRegistry.addSmelting((Block)Main.azurite, (ItemStack)new ItemStack((Block)Main.smooth_azurite), (float)0.0f);
        GameRegistry.addSmelting((Block)Main.citrinic_stone, (ItemStack)new ItemStack((Block)Main.citrinic_sand), (float)0.0f);
        GameRegistry.addSmelting((Block)Main.onyx, (ItemStack)new ItemStack((Block)Main.smooth_onyx), (float)0.0f);
        GameRegistry.addSmelting((Item)Main.raw_mystic_iron, (ItemStack)new ItemStack(Main.mystic_iron_ingot), (float)1.0f);
        GameRegistry.addSmelting((Item)Main.raw_soulsteel, (ItemStack)new ItemStack(Main.soulsteel_ingot), (float)1.0f);
        GameRegistry.addSmelting((Item)Main.raw_repairing_paste, (ItemStack)new ItemStack(Main.repairing_paste), (float)1.0f);
        GameRegistry.addSmelting((Item)Main.wheat_flour, (ItemStack)new ItemStack(Items.field_151025_P), (float)1.0f);
        GameRegistry.addSmelting((Item)Main.hamburger, (ItemStack)new ItemStack(Main.hamburger_cooked), (float)1.0f);
        GameRegistry.addShapedRecipe((ResourceLocation)Util.res("producer." + Main.producer.getRegistryName().func_110623_a()), (ResourceLocation)Util.res("hwell.producer"), (ItemStack)new ItemStack((Block)Main.producer), (Object[])new Object[]{"ABA", "MCM", "MYM", Character.valueOf('B'), FluidUtil.getFilledBucket((FluidStack)new FluidStack(Main.liquid_souls, 1000)), Character.valueOf('A'), Main.smooth_azurite, Character.valueOf('M'), Main.metaldiamond_block, Character.valueOf('C'), Main.asul_machine_case, Character.valueOf('Y'), Main.crystal_block});
        recipePowerCrystal = new RecipePowerCrystal().setRegistryName(Util.res("hwell:recipe_power_crystal"));
        event.getRegistry().register((IForgeRegistryEntry)recipePowerCrystal);
    }

    private static void writeRecipesFile(String destination) throws IOException {
        InputStream inStream = Hwell.class.getResourceAsStream("/assets/hwell/recipes.json");
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream));
        FileWriter outstream = new FileWriter(destination, false);
        BufferedWriter out = new BufferedWriter(outstream);
        String aLine = null;
        while ((aLine = in.readLine()) != null) {
            out.write(aLine);
            out.newLine();
        }
        in.close();
        out.close();
    }

    static {
        recipenr = "unknown";
    }

    public static interface HwellRecipe {
    }
}

