/*
 * Decompiled with CFR 0.152.
 */
package wolforce.registry;

import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import wolforce.Main;
import wolforce.Util;
import wolforce.base.BlockWithDescription;
import wolforce.blocks.BlockBox;
import wolforce.blocks.BlockCore;
import wolforce.blocks.HasCustomItem;
import wolforce.registry.RegisterOreDict;

@Mod.EventBusSubscriber(modid="hwell")
public class RegisterBlocks {
    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : Main.blocks) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        for (BlockBox box : Main.boxes) {
            event.getRegistry().register((IForgeRegistryEntry)box);
        }
        for (Map.Entry entry : Main.custom_cores.entrySet()) {
            BlockCore core = (BlockCore)entry.getValue();
            event.getRegistry().register((IForgeRegistryEntry)core);
            Block graft = Main.custom_grafts.get(core);
            event.getRegistry().register((IForgeRegistryEntry)graft);
        }
    }

    @SubscribeEvent
    public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
        for (Block block : Main.blocks) {
            ItemBlock item = block instanceof HasCustomItem ? ((HasCustomItem)block).getCustomItem() : (!(block instanceof BlockWithDescription) ? new ItemBlock(block) : new ItemBlock(block){

                public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
                    for (String string : ((BlockWithDescription)this.field_150939_a).getDescription()) {
                        tooltip.add(string);
                    }
                }
            });
            item.func_77655_b(Util.res(block.getRegistryName().func_110623_a()).toString());
            item.setRegistryName(Util.res(block.getRegistryName().func_110623_a()));
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (final BlockBox box : Main.boxes) {
            ItemBlock item = new ItemBlock((Block)box){

                public String func_77653_i(ItemStack stack) {
                    return Item.func_150898_a((Block)box.block).func_77653_i(stack) + " Box";
                }

                public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
                    tooltip.add(box.getDescription());
                    super.func_77624_a(stack, worldIn, tooltip, flagIn);
                }
            };
            item.setRegistryName(box.getRegistryName());
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Map.Entry entry : Main.custom_cores.entrySet()) {
            final BlockCore core = (BlockCore)entry.getValue();
            ItemBlock item = new ItemBlock(core){

                public String func_77653_i(ItemStack stack) {
                    return core.func_149732_F();
                }
            };
            item.setRegistryName(core.getRegistryName());
            event.getRegistry().register((IForgeRegistryEntry)item);
            final Block graft = Main.custom_grafts.get(core);
            ItemBlock itemGraft = new ItemBlock(graft){

                public String func_77653_i(ItemStack stack) {
                    return graft.func_149732_F();
                }
            };
            itemGraft.setRegistryName(graft.getRegistryName());
            event.getRegistry().register((IForgeRegistryEntry)itemGraft);
        }
        RegisterOreDict.registerBlocks();
    }
}

