/*
 * Decompiled with CFR 0.152.
 */
package wolforce.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class RecipeTube {
    public static LinkedList<RecipeTube> recipes;
    public final ItemStack in;
    public final ItemStack out;
    public final FluidStack outFluid;

    public static void initRecipes(JsonArray recipesJson) {
        recipes = new LinkedList();
        for (JsonElement e : recipesJson) {
            recipes.add(RecipeTube.readRecipe(e.getAsJsonObject()));
        }
    }

    private static RecipeTube readRecipe(JsonObject o) {
        ItemStack input = ShapedRecipes.func_192405_a((JsonObject)o.get("input").getAsJsonObject(), (boolean)true);
        if (o.has("output_fluid")) {
            FluidStack output = new FluidStack(FluidRegistry.getFluid((String)o.get("output_fluid").getAsString()), 1000);
            return new RecipeTube(input, null, output);
        }
        ItemStack output = ShapedRecipes.func_192405_a((JsonObject)o.get("output").getAsJsonObject(), (boolean)true);
        return new RecipeTube(input, output, null);
    }

    public static void put(ItemStack in, ItemStack out) {
        recipes.add(new RecipeTube(in, out, null));
    }

    public static void put(ItemStack in, FluidStack out) {
        recipes.add(new RecipeTube(in, null, out));
    }

    public static Object getResult(IBlockState blockstate) {
        ItemStack input = new ItemStack(blockstate.func_177230_c(), 1, blockstate.func_177230_c().func_176201_c(blockstate));
        if (input.func_77973_b() == null) {
            return null;
        }
        for (RecipeTube recipeTube : recipes) {
            if (!recipeTube.in.func_77973_b().equals(input.func_77973_b())) continue;
            if (recipeTube.outFluid != null) {
                return recipeTube.outFluid.copy();
            }
            if (recipeTube.out == null) continue;
            return recipeTube.out.func_77946_l();
        }
        return null;
    }

    public RecipeTube(ItemStack in, ItemStack out, FluidStack outf) {
        this.in = in;
        this.out = out;
        this.outFluid = outf;
    }

    public String toString() {
        return "[ " + this.in.func_77977_a() + " -> " + this.out.func_77977_a() + " ]";
    }
}

