/*
 * Decompiled with CFR 0.152.
 */
package wolforce.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import wolforce.recipes.Irio;

public class RecipeSeparator {
    public static HashMap<Irio, RecipeSeparator> recipes;
    public final ItemStack left;
    public final ItemStack right;
    public final ItemStack back;

    public static void initRecipes(JsonArray recipesJson) {
        recipes = new HashMap();
        for (JsonElement e : recipesJson) {
            RecipeSeparator.readAndAddRecipe(e.getAsJsonObject());
        }
    }

    private static void readAndAddRecipe(JsonObject o) {
        ItemStack input = ShapedRecipes.func_192405_a((JsonObject)o.get("input").getAsJsonObject(), (boolean)true);
        ItemStack output1 = ShapedRecipes.func_192405_a((JsonObject)o.get("output1").getAsJsonObject(), (boolean)true);
        ItemStack output2 = ShapedRecipes.func_192405_a((JsonObject)o.get("output2").getAsJsonObject(), (boolean)true);
        if (!o.has("output3")) {
            RecipeSeparator.addRecipe(new Irio(input), new RecipeSeparator(output1, output2));
        } else {
            ItemStack output3 = ShapedRecipes.func_192405_a((JsonObject)o.get("output3").getAsJsonObject(), (boolean)true);
            RecipeSeparator.addRecipe(new Irio(input), new RecipeSeparator(output1, output2, output3));
        }
    }

    public static void addRecipe(ItemStack input, ItemStack output1, ItemStack output2, ItemStack output3) {
        RecipeSeparator.addRecipe(new Irio(input), new RecipeSeparator(output1, output2, output3));
    }

    public static void addRecipe(ItemStack input, ItemStack output1, ItemStack output2) {
        RecipeSeparator.addRecipe(new Irio(input), new RecipeSeparator(output1, output2));
    }

    private static void addRecipe(Irio stack, RecipeSeparator recipeGrinder) {
        recipes.put(stack, recipeGrinder);
    }

    public static Set<Map.Entry<Irio, RecipeSeparator>> getRecipes() {
        return recipes.entrySet();
    }

    public static ItemStack[] getResult(ItemStack itemStack) {
        RecipeSeparator result = recipes.get(new Irio(itemStack.func_77973_b()));
        if (result != null) {
            return new ItemStack[]{result.left.func_77946_l(), result.right.func_77946_l(), result.back.func_77946_l()};
        }
        result = recipes.get(new Irio(itemStack.func_77973_b(), itemStack.func_77960_j()));
        if (result != null) {
            return new ItemStack[]{result.left.func_77946_l(), result.right.func_77946_l(), result.back.func_77946_l()};
        }
        return null;
    }

    public RecipeSeparator(ItemStack left, ItemStack right, ItemStack back) {
        this.left = left;
        this.right = right;
        this.back = back;
    }

    public RecipeSeparator(ItemStack left, ItemStack right) {
        this(left, right, ItemStack.field_190927_a);
    }
}

