/*
 * Decompiled with CFR 0.152.
 */
package wolforce.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import wolforce.HwellConfig;
import wolforce.Util;

public class RecipePuller {
    public static LinkedList<RecipePuller> recipes;
    static HashSet<ItemStack> filters;
    public ItemStack output;
    private double prob;
    private ItemStack filter;

    public static void initRecipes(JsonArray recipesJson) {
        float totalProb = 0.0f;
        for (JsonElement e : recipesJson) {
            totalProb += RecipePuller.getProb(e.getAsJsonObject());
        }
        recipes = new LinkedList();
        filters = new HashSet();
        for (JsonElement e : recipesJson) {
            recipes.add(RecipePuller.readRecipe(e.getAsJsonObject(), totalProb));
        }
    }

    private static float getProb(JsonObject o) {
        return o.get("probability").getAsFloat();
    }

    private static RecipePuller readRecipe(JsonObject o, float totalProb) {
        ItemStack output = ShapedRecipes.func_192405_a((JsonObject)o.get("output").getAsJsonObject(), (boolean)true);
        double prob = o.get("probability").getAsFloat() / totalProb;
        ItemStack filter = ShapedRecipes.func_192405_a((JsonObject)o.get("filter").getAsJsonObject(), (boolean)true);
        filters.add(filter);
        return new RecipePuller(output, prob, filter);
    }

    public static ItemStack getRandomPull(List<ItemStack> stacksInLiquid) {
        if (stacksInLiquid != null && !stacksInLiquid.isEmpty() && Math.random() < HwellConfig.machines.pullerChanceToGetFilteredPull) {
            LinkedList<RecipePuller> preferredRecipes = new LinkedList<RecipePuller>();
            for (ItemStack stackInLiquid : stacksInLiquid) {
                for (RecipePuller recipe : recipes) {
                    if (!Util.equalExceptAmount(recipe.filter, stackInLiquid) || preferredRecipes.contains(recipe)) continue;
                    preferredRecipes.add(recipe);
                }
            }
            if (!preferredRecipes.isEmpty()) {
                ItemStack randomPreferedStack = ((RecipePuller)preferredRecipes.get((int)((int)((double)preferredRecipes.size() * Math.random())))).output.func_77946_l();
                randomPreferedStack.func_190920_e(1 + (int)(Math.random() * 2.0));
                return randomPreferedStack;
            }
        }
        double rand = Math.random();
        for (RecipePuller recipe : recipes) {
            if (!((rand -= recipe.prob) <= 0.0)) continue;
            ItemStack randomStack = recipe.output.func_77946_l();
            randomStack.func_190920_e(1 + (int)(Math.random() * 2.0));
            return randomStack;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isFilter(ItemStack possible) {
        for (ItemStack filter : filters) {
            if (!possible.func_77973_b().equals(filter.func_77973_b()) || possible.func_77960_j() != filter.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    public RecipePuller(ItemStack output, double prob, ItemStack filter) {
        this.output = output;
        this.prob = prob;
        this.filter = filter;
    }
}

