/*
 * Decompiled with CFR 0.152.
 */
package wolforce.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import wolforce.HwellConfig;
import wolforce.Main;
import wolforce.Util;
import wolforce.items.ItemPowerCrystal;

public class RecipePowerCrystal
implements IRecipe {
    private ResourceLocation name;
    public static LinkedList<ItemAndVals> nucleousRecipes;
    public static LinkedList<ItemAndVals> relayRecipes;
    public static LinkedList<ItemAndVals> screenRecipes;
    private static boolean innited;

    public static boolean isInnited() {
        return innited;
    }

    public static void initRecipes(JsonObject recipesJson) {
        ItemAndVals rec;
        nucleousRecipes = new LinkedList();
        for (JsonElement e : recipesJson.get("nucleous").getAsJsonArray()) {
            rec = RecipePowerCrystal.readRecipe(e.getAsJsonObject());
            nucleousRecipes.add(rec);
        }
        relayRecipes = new LinkedList();
        for (JsonElement e : recipesJson.get("relay").getAsJsonArray()) {
            rec = RecipePowerCrystal.readRecipe(e.getAsJsonObject());
            relayRecipes.add(rec);
        }
        screenRecipes = new LinkedList();
        for (JsonElement e : recipesJson.get("screen").getAsJsonArray()) {
            rec = RecipePowerCrystal.readRecipe(e.getAsJsonObject());
            screenRecipes.add(rec);
        }
        innited = true;
    }

    private static ItemAndVals readRecipe(JsonObject o) {
        ItemStack item = ShapedRecipes.func_192405_a((JsonObject)o.getAsJsonObject("item"), (boolean)false);
        String name = o.get("name").getAsString();
        int power = o.get("power").getAsInt();
        int range = o.get("range").getAsInt();
        float purity = o.get("purity").getAsFloat();
        return new ItemAndVals(item, name, power, range, purity);
    }

    public IRecipe setRegistryName(ResourceLocation name) {
        this.name = name;
        return this;
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public Class<IRecipe> getRegistryType() {
        return IRecipe.class;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return this.isScreen(inv.func_70301_a(0)) && this.isRelay(inv.func_70301_a(1)) && this.isScreen(inv.func_70301_a(2)) && this.isScreen(inv.func_70301_a(3)) && this.isNucleous(inv.func_70301_a(4)) && this.isScreen(inv.func_70301_a(5)) && this.isScreen(inv.func_70301_a(6)) && this.isRelay(inv.func_70301_a(7)) && this.isScreen(inv.func_70301_a(8)) && this.areSame(inv, 1, 7) && this.areSame(inv, 0, 2, 3, 5, 6, 8);
    }

    private boolean areSame(InventoryCrafting inv, int ... ints) {
        Item item = inv.func_70301_a(ints[0]).func_77973_b();
        for (int i : ints) {
            if (item == inv.func_70301_a(i).func_77973_b()) continue;
            return false;
        }
        return true;
    }

    private boolean isNucleous(ItemStack stack) {
        for (ItemAndVals itemAndVals : nucleousRecipes) {
            if (!Util.equalExceptAmount(itemAndVals.stack, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean isRelay(ItemStack stack) {
        for (ItemAndVals itemAndVals : relayRecipes) {
            if (!Util.equalExceptAmount(itemAndVals.stack, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean isScreen(ItemStack stack) {
        for (ItemAndVals itemAndVals : screenRecipes) {
            if (!Util.equalExceptAmount(itemAndVals.stack, stack)) continue;
            return true;
        }
        return false;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public ItemStack func_77571_b() {
        ItemStack newstack = new ItemStack((Item)Main.power_crystal);
        if (!newstack.func_77942_o()) {
            newstack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = new NBTTagCompound();
        ItemPowerCrystal.setHwellNBT(nbt, 2, 2, 2);
        newstack.func_77978_p().func_74782_a("hwell", (NBTBase)nbt);
        return newstack;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack newstack = new ItemStack((Item)Main.power_crystal);
        if (!newstack.func_77942_o()) {
            newstack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = new NBTTagCompound();
        ItemPowerCrystal.setHwellNBT(nbt, this.getNucIndex(inv), this.getRelayIndex(inv), this.getScreenIndex(inv));
        newstack.func_77978_p().func_74782_a("hwell", (NBTBase)nbt);
        return newstack;
    }

    private int getNucIndex(InventoryCrafting inv) {
        ItemStack stack = inv.func_70301_a(4);
        int i = 0;
        for (ItemAndVals itemAndVals : nucleousRecipes) {
            if (Util.equalExceptAmount(itemAndVals.stack, stack)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private int getRelayIndex(InventoryCrafting inv) {
        ItemStack stack = inv.func_70301_a(1);
        int i = 0;
        for (ItemAndVals itemAndVals : relayRecipes) {
            if (Util.equalExceptAmount(itemAndVals.stack, stack)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private int getScreenIndex(InventoryCrafting inv) {
        ItemStack stack = inv.func_70301_a(0);
        int i = 0;
        for (ItemAndVals itemAndVals : screenRecipes) {
            if (Util.equalExceptAmount(itemAndVals.stack, stack)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static ItemAndVals getNucleous(int nucleousIndex) {
        int i = 0;
        for (ItemAndVals itemAndVals : nucleousRecipes) {
            if (i == nucleousIndex) {
                return itemAndVals;
            }
            ++i;
        }
        return ItemAndVals.invalid;
    }

    public static ItemAndVals getRelay(int relayIndex) {
        int i = 0;
        for (ItemAndVals itemAndVals : relayRecipes) {
            if (i == relayIndex) {
                return itemAndVals;
            }
            ++i;
        }
        return ItemAndVals.invalid;
    }

    public static ItemAndVals getScreen(int screenIndex) {
        int i = 0;
        for (ItemAndVals itemAndVals : screenRecipes) {
            if (i == screenIndex) {
                return itemAndVals;
            }
            ++i;
        }
        return ItemAndVals.invalid;
    }

    public static int calcMaxPower(int nucleousIndex, int relayIndex, int screenIndex) {
        ItemAndVals nucleous = RecipePowerCrystal.getNucleous(nucleousIndex);
        ItemAndVals relay = RecipePowerCrystal.getRelay(relayIndex);
        ItemAndVals screen = RecipePowerCrystal.getScreen(screenIndex);
        return nucleous.power + relay.power + screen.power;
    }

    public static int calcPower(int maxpower) {
        return Math.max(maxpower / 4, Math.min(maxpower, 100));
    }

    public static int calcRange(int nucleousIndex, int relayIndex, int screenIndex) {
        ItemAndVals nucleous = RecipePowerCrystal.getNucleous(nucleousIndex);
        ItemAndVals relay = RecipePowerCrystal.getRelay(relayIndex);
        ItemAndVals screen = RecipePowerCrystal.getScreen(screenIndex);
        return Math.min(HwellConfig.power.powerMaxRange, nucleous.range + relay.range + screen.range);
    }

    public static float calcPurity(int nucleousIndex, int relayIndex, int screenIndex) {
        ItemAndVals nucleous = RecipePowerCrystal.getNucleous(nucleousIndex);
        ItemAndVals relay = RecipePowerCrystal.getRelay(relayIndex);
        ItemAndVals screen = RecipePowerCrystal.getScreen(screenIndex);
        return nucleous.purity * relay.purity * screen.purity;
    }

    static {
        innited = false;
    }

    public static class ItemAndVals {
        public static final ItemAndVals invalid = new ItemAndVals(Blocks.field_150350_a, "invalid", 0, 0, 0.0f);
        public ItemStack stack;
        public int power;
        public int range;
        public float purity;
        public String name;

        public ItemAndVals(Block block, String name, int power, int range, float purity) {
            this(new ItemStack(block), name, power, range, purity);
        }

        public ItemAndVals(Item item, String name, int power, int range, float purity) {
            this(new ItemStack(item), name, power, range, purity);
        }

        public ItemAndVals(ItemStack item, String name, int power, int range, float purity) {
            this.stack = item;
            this.name = name;
            this.power = power;
            this.range = range;
            this.purity = purity;
        }
    }
}

