/*
 * Decompiled with CFR 0.152.
 */
package wolforce.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import wolforce.Main;
import wolforce.Util;
import wolforce.items.ItemGrindingWheel;
import wolforce.recipes.Irio;

public class RecipeGrinding {
    public static HashMap<Irio, RecipeGrinding> recipes;
    public final ItemStack result;
    public final ItemGrindingWheel[] levels;

    public static void initRecipes(JsonArray recipesJson) {
        recipes = new HashMap();
        for (JsonElement e : recipesJson) {
            recipes.put(Util.readJsonIrio(e.getAsJsonObject().get("input").getAsJsonObject()), RecipeGrinding.readRecipe(e.getAsJsonObject()));
        }
    }

    private static RecipeGrinding readRecipe(JsonObject o) {
        JsonArray wheelsArray = o.get("wheels").getAsJsonArray();
        ItemGrindingWheel[] wheels = new ItemGrindingWheel[wheelsArray.size()];
        for (int i = 0; i < wheels.length; ++i) {
            wheels[i] = RecipeGrinding.getWheelOf(wheelsArray.get(i).getAsString());
        }
        ItemStack output = ShapedRecipes.func_192405_a((JsonObject)o.get("output").getAsJsonObject(), (boolean)true);
        return new RecipeGrinding(output, wheels);
    }

    public static ItemGrindingWheel getWheelOf(String wheelString) {
        switch (wheelString) {
            case "iron": {
                return Main.grinding_wheel_iron;
            }
            case "diamond": {
                return Main.grinding_wheel_diamond;
            }
            case "crystal": {
                return Main.grinding_wheel_crystal;
            }
        }
        return null;
    }

    private static void put(Irio stack, RecipeGrinding recipeGrinder) {
        recipes.put(stack, recipeGrinder);
    }

    public static ItemStack getResult(ItemGrindingWheel gwheel, ItemStack itemStack) {
        RecipeGrinding result = recipes.get(new Irio(itemStack.func_77973_b()));
        if (result != null && Arrays.asList(result.levels).contains((Object)gwheel)) {
            return result.result.func_77946_l();
        }
        result = recipes.get(new Irio(itemStack.func_77973_b(), itemStack.func_77960_j()));
        if (result != null && Arrays.asList(result.levels).contains((Object)gwheel)) {
            return result.result.func_77946_l();
        }
        return null;
    }

    public RecipeGrinding(ItemStack result, ItemGrindingWheel ... levels) {
        this.levels = levels;
        this.result = result;
    }

    public static Set<Map.Entry<Irio, RecipeGrinding>> getRecipeList() {
        return recipes.entrySet();
    }
}

