/*
 * Decompiled with CFR 0.152.
 */
package wolforce.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class RecipeFreezer {
    public static LinkedList<RecipeFreezer> recipes;
    public FluidStack fluidIn;
    public ItemStack[] blocksOut;

    public static void initRecipes(JsonArray recipesJson) {
        recipes = new LinkedList();
        for (JsonElement e : recipesJson) {
            recipes.add(RecipeFreezer.readRecipe(e.getAsJsonObject()));
        }
    }

    private static RecipeFreezer readRecipe(JsonObject o) {
        FluidStack input = new FluidStack(FluidRegistry.getFluid((String)o.get("input").getAsString()), 1000);
        JsonArray outputArray = o.get("outputs").getAsJsonArray();
        ItemStack[] outputs = new ItemStack[outputArray.size()];
        for (int i = 0; i < outputArray.size(); ++i) {
            JsonObject output = outputArray.get(i).getAsJsonObject();
            outputs[i] = ShapedRecipes.func_192405_a((JsonObject)output, (boolean)true);
        }
        return new RecipeFreezer(input, outputs);
    }

    public static Block getResult(World world, BlockPos pos, IBlockState state) {
        if (state == null || !RecipeFreezer.hasResult(world, pos, state)) {
            return null;
        }
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)state.func_177230_c());
        for (RecipeFreezer r : recipes) {
            if (!r.fluidIn.getFluid().equals(fluid)) continue;
            return Block.func_149634_a((Item)r.blocksOut[(int)(Math.random() * (double)r.blocksOut.length)].func_77973_b());
        }
        return null;
    }

    public static boolean hasResult(World world, BlockPos pos, IBlockState state) {
        for (RecipeFreezer r : recipes) {
            Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)state.func_177230_c());
            if (!r.fluidIn.getFluid().equals(fluid)) continue;
            Block block = fluid.getBlock();
            if (block instanceof BlockFluidClassic && ((BlockFluidClassic)block).isSourceBlock((IBlockAccess)world, pos)) {
                return true;
            }
            if (!state.func_177228_b().containsKey((Object)BlockFluidBase.LEVEL) || (Integer)state.func_177229_b((IProperty)BlockFluidBase.LEVEL) != 0) continue;
            return true;
        }
        return false;
    }

    public RecipeFreezer(FluidStack fluid, ItemStack[] blocks) {
        this.fluidIn = fluid;
        this.blocksOut = blocks;
    }
}

