/*
 * Decompiled with CFR 0.152.
 */
package wolforce.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import wolforce.Util;
import wolforce.recipes.Irio;

public class RecipeCrushing {
    public static HashMap<Irio, RecipeCrushing[]> recipes;
    public final ItemStack stack;
    public final double probability;

    public static void initRecipes(JsonArray recipesJson) {
        recipes = new HashMap();
        for (JsonElement e : recipesJson) {
            recipes.put(Util.readJsonIrio(e.getAsJsonObject().get("input").getAsJsonObject()), RecipeCrushing.readRecipe(e.getAsJsonObject().get("possible_outputs").getAsJsonArray()));
        }
    }

    private static RecipeCrushing[] readRecipe(JsonArray array) {
        RecipeCrushing[] possibleOutputs = new RecipeCrushing[array.size()];
        for (int i = 0; i < possibleOutputs.length; ++i) {
            JsonObject o = array.get(i).getAsJsonObject();
            possibleOutputs[i] = RecipeCrushing.readPossible(o);
        }
        return possibleOutputs;
    }

    private static RecipeCrushing readPossible(JsonObject o) {
        ItemStack out = ShapedRecipes.func_192405_a((JsonObject)o.get("out").getAsJsonObject(), (boolean)true);
        double prob = o.has("probability") ? o.get("probability").getAsDouble() : 1.0;
        return new RecipeCrushing(out, prob);
    }

    private static void putRecipe(Irio irio, RecipeCrushing ... recipeArray) {
        recipes.put(irio, recipeArray);
    }

    public static Iterable<ItemStack> getResult(ItemStack itemstack) {
        RecipeCrushing[] possible = RecipeCrushing.getRecipeOf(itemstack);
        if (possible != null) {
            LinkedList<ItemStack> list = new LinkedList<ItemStack>();
            for (int i = 0; i < itemstack.func_190916_E(); ++i) {
                for (ItemStack singleresult : RecipeCrushing.getSingleResult(possible)) {
                    list.add(singleresult.func_77946_l());
                }
            }
            return list;
        }
        return null;
    }

    private static RecipeCrushing[] getRecipeOf(ItemStack itemstack) {
        for (Map.Entry<Irio, RecipeCrushing[]> recipe : recipes.entrySet()) {
            if (!recipe.getKey().equals(new Irio(itemstack))) continue;
            return recipe.getValue();
        }
        return null;
    }

    private static ItemStack[] getSingleResult(RecipeCrushing[] possible) {
        double d = Math.random();
        int i = 0;
        while (i < possible.length) {
            if (d < possible[i].probability) {
                return new ItemStack[]{possible[i].stack.func_77946_l()};
            }
            d -= possible[i].probability;
            ++i;
        }
        return new ItemStack[0];
    }

    public RecipeCrushing(ItemStack stack, double probability) {
        this.stack = stack;
        this.probability = probability;
    }

    private RecipeCrushing(Item item) {
        this(new ItemStack(item, 1), 1.0);
    }

    private RecipeCrushing(Item item, int n) {
        this(new ItemStack(item, n), 1.0);
    }

    private RecipeCrushing(Item item, int n, double prob) {
        this(new ItemStack(item, n), prob);
    }

    private RecipeCrushing(Block block) {
        this(new ItemStack(block, 1), 1.0);
    }

    public static Set<Map.Entry<Irio, RecipeCrushing[]>> getRecipeList() {
        return recipes.entrySet();
    }
}

