/*
 * Decompiled with CFR 0.152.
 */
package wolforce.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import wolforce.Main;
import wolforce.Util;
import wolforce.blocks.BlockCore;
import wolforce.items.ItemShard;
import wolforce.recipes.Irio;

public class RecipeCoring {
    private static final HashMap<Block, HashMap<Item, RecipeCoring>> recipeLists = new HashMap();
    private static Block stone;
    private static Block heat;
    private static Block green;
    private static Block senti;
    public final ItemStack result;
    public final Irio[] consumes;

    public static void initRecipes(JsonObject recipesJson) {
        RecipeCoring.initCoreRecipes(Main.core_stone, recipesJson.get("core_stone").getAsJsonObject());
        RecipeCoring.initCoreRecipes(Main.core_anima, recipesJson.get("core_anima").getAsJsonObject());
        RecipeCoring.initCoreRecipes(Main.core_heat, recipesJson.get("core_heat").getAsJsonObject());
        RecipeCoring.initCoreRecipes(Main.core_green, recipesJson.get("core_green").getAsJsonObject());
        RecipeCoring.initCoreRecipes(Main.core_sentient, recipesJson.get("core_sentient").getAsJsonObject());
        for (Map.Entry entry : recipesJson.entrySet()) {
            String nameid = (String)entry.getKey();
            if (RecipeCoring.getNormalCoreBlock(nameid) != null) continue;
            BlockCore core = Main.custom_cores.get(nameid);
            RecipeCoring.initCoreRecipes(core, recipesJson.getAsJsonObject(nameid));
        }
    }

    public static BlockCore getNormalCoreBlock(String nameid) {
        switch (nameid) {
            case "core_stone": {
                return Main.core_stone;
            }
            case "core_anima": {
                return Main.core_anima;
            }
            case "core_heat": {
                return Main.core_heat;
            }
            case "core_green": {
                return Main.core_green;
            }
            case "core_sentient": {
                return Main.core_sentient;
            }
        }
        return null;
    }

    private static void initCoreRecipes(BlockCore core, JsonObject recipesJson) {
        HashMap<ItemShard, RecipeCoring> map = new HashMap<ItemShard, RecipeCoring>();
        String[] shardsS = new String[]{"shard_c", "shard_fe", "shard_au", "shard_h", "shard_o", "shard_ca", "shard_p", "shard_n"};
        ItemShard[] shardsI = new ItemShard[]{Main.shard_c, Main.shard_fe, Main.shard_au, Main.shard_h, Main.shard_o, Main.shard_ca, Main.shard_p, Main.shard_n};
        for (int i = 0; i < shardsS.length; ++i) {
            if (!recipesJson.has(shardsS[i])) continue;
            JsonObject shard = recipesJson.get(shardsS[i]).getAsJsonObject();
            map.put(shardsI[i], new RecipeCoring(RecipeCoring.readOutput(shard.get("output").getAsJsonObject()), RecipeCoring.readBlocks(shard.get("inputs").getAsJsonArray())));
        }
        recipeLists.put(core, map);
    }

    private static ItemStack readOutput(JsonObject output) {
        return ShapedRecipes.func_192405_a((JsonObject)output, (boolean)true);
    }

    private static Irio[] readBlocks(JsonArray array) {
        Irio[] blocks = new Irio[array.size()];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = Util.readJsonIrio(array.get(i).getAsJsonObject());
        }
        return blocks;
    }

    public static RecipeCoring getResult(Block coreBlock, Item shard) {
        return recipeLists.get(coreBlock).get(shard);
    }

    private RecipeCoring(ItemStack _result, Irio ... _consumes) {
        if (_result == null) {
            throw new RuntimeException("RESULT OF CORING IS NULL");
        }
        this.result = _result;
        if (_consumes.length == 1 && _consumes[0].item == Items.field_190931_a) {
            this.consumes = new Irio[]{new Irio(Blocks.field_150350_a)};
        } else {
            this.consumes = new Irio[_consumes.length + 1];
            for (int i = 0; i < _consumes.length; ++i) {
                this.consumes[i] = _consumes[i];
            }
            this.consumes[_consumes.length] = new Irio(this.result);
        }
    }

    private Irio i(Block block) {
        return new Irio(block);
    }

    private Irio i(Block block, int meta) {
        return new Irio(block, meta);
    }

    public static Set<Map.Entry<Item, RecipeCoring>> getRecipeList(BlockCore coreBlock) {
        return recipeLists.get(coreBlock).entrySet();
    }
}

