/*
 * Decompiled with CFR 0.152.
 */
package wolforce.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import wolforce.Main;
import wolforce.Util;

public class RecipeCharger {
    public static LinkedList<RecipeCharger> recipes;
    public final ItemStack input;
    public final ItemStack output;
    public final int power;

    public static void initRecipes(JsonArray recipesJson) {
        recipes = new LinkedList();
        for (JsonElement e : recipesJson) {
            RecipeCharger rec = RecipeCharger.readRecipe(e.getAsJsonObject());
            if (rec == null) continue;
            recipes.add(rec);
            System.out.println(rec);
        }
    }

    private static RecipeCharger readRecipe(JsonObject o) {
        if (o.has("special_liquid_souls_bucket_recipe")) {
            if (o.get("special_liquid_souls_bucket_recipe").getAsBoolean()) {
                return new RecipeCharger(FluidUtil.getFilledBucket((FluidStack)new FluidStack(Main.liquid_souls, 1000)), new ItemStack(Items.field_151133_ar), o.get("power").getAsInt());
            }
            return null;
        }
        ItemStack input = ShapedRecipes.func_192405_a((JsonObject)o.getAsJsonObject("input"), (boolean)false);
        ItemStack output = o.has("output") ? ShapedRecipes.func_192405_a((JsonObject)o.getAsJsonObject("output"), (boolean)false) : null;
        int power = o.get("power").getAsInt();
        return new RecipeCharger(input, output, power);
    }

    public static int getResult(ItemStack stack) {
        for (RecipeCharger recipeCharger : recipes) {
            if (!Util.equalExceptAmount(stack, recipeCharger.input)) continue;
            return recipeCharger.power;
        }
        return 0;
    }

    public static ItemStack getSpit(ItemStack stack) {
        for (RecipeCharger recipeCharger : recipes) {
            if (!Util.equalExceptAmount(stack, recipeCharger.input)) continue;
            return recipeCharger.output != null ? recipeCharger.output.func_77946_l() : null;
        }
        return null;
    }

    public RecipeCharger(ItemStack input, ItemStack output, int power) {
        this.input = input;
        this.output = output;
        this.power = power;
    }

    public String toString() {
        return "(" + this.power + ")" + this.input + " -> " + this.output;
    }
}

