/*
 * Decompiled with CFR 0.152.
 */
package wolforce.items.tools;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import wolforce.Main;
import wolforce.Util;
import wolforce.base.MyItem;

public class ItemDisplacer
extends MyItem {
    private boolean powered;

    public ItemDisplacer(String name, boolean powered, String ... lore) {
        super(name, lore);
        this.powered = powered;
        this.func_77625_d(1);
        this.func_77656_e(64);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        if (this.powered && !Util.hasEnchantment(stack, Enchantments.field_185306_r)) {
            stack.func_77966_a(Enchantments.field_185306_r, 1);
        }
        return super.initCapabilities(stack, nbt);
    }

    public boolean isRepairable() {
        return true;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == Main.heavy_ingot || repair.func_77973_b() == Main.soulsteel_ingot;
    }

    public int func_77626_a(ItemStack stack) {
        return 20;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        RayTraceResult raytraceresult = this.func_77621_a(world, player, true);
        if (raytraceresult == null || raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        BlockPos pos = raytraceresult.func_178782_a();
        if (!world.func_175660_a(player, pos)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (this.canDisplace(world, player, pos)) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (!(entityLiving instanceof EntityPlayer)) {
            return stack;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        RayTraceResult raytraceresult = this.func_77621_a(world, player, true);
        if (raytraceresult == null || raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return stack;
        }
        BlockPos pos = raytraceresult.func_178782_a();
        if (!world.func_175660_a(player, pos)) {
            return stack;
        }
        IBlockState state = world.func_180495_p(pos);
        if (this.canDisplace(world, player, pos)) {
            player.func_184185_a(SoundEvents.field_187662_cZ, 1.0f, 1.0f);
            if (state.func_177230_c() instanceof IShearable && ((IShearable)state.func_177230_c()).isShearable(stack, (IBlockAccess)world, pos)) {
                for (ItemStack a : ((IShearable)state.func_177230_c()).onSheared(stack, (IBlockAccess)world, pos, 0)) {
                    if (world.field_72995_K) continue;
                    Util.spawnItem(world, pos, a, new double[0]);
                }
            } else if (this.powered) {
                state.func_177230_c().func_180657_a(world, player, pos, state, null, stack);
            } else if (!world.field_72995_K) {
                Util.spawnItem(world, pos, new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)), new double[0]);
            }
            world.func_175655_b(pos, false);
            stack.func_77972_a(1, (EntityLivingBase)player);
            player.func_71024_bL().func_75122_a(-1, -1.0f);
        }
        return stack;
    }

    private boolean canDisplace(World world, EntityPlayer player, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().equals(Blocks.field_150343_Z) || state.func_177230_c().equals(Blocks.field_150359_w) || state.func_177230_c().equals(Blocks.field_150410_aZ) || state.func_177230_c().equals(Blocks.field_150399_cn) || state.func_177230_c().equals(Blocks.field_150397_co) || state.func_177230_c().equals(Blocks.field_150432_aD) || state.func_177230_c().equals(Blocks.field_185778_de) || state.func_177230_c().equals(Blocks.field_150403_cj) || this.powered && (state.func_177230_c().canSilkHarvest(world, pos, world.func_180495_p(pos), player) || state.func_177230_c() instanceof IShearable);
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return false;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return false;
    }
}

