/*
 * Decompiled with CFR 0.152.
 */
package wolforce.items;

import net.minecraft.block.Block;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import wolforce.Main;
import wolforce.base.MyItem;
import wolforce.recipes.RecipeSeedOfLife;

public class ItemSeedOfLife
extends MyItem {
    final int seedIndex;
    public static final int[] radius = new int[]{3, 10, 5};
    static IBlockState[] center_block;
    static IBlockState[] center_top_block;
    static IBlockState[] probable_block;
    static IBlockState[][] less_probable_blocks;
    static IBlockState[][] top_blocks;

    public ItemSeedOfLife(String name, String lore, int seedIndex) {
        super(name, lore + " Radius: " + radius[seedIndex]);
        this.func_77625_d(1);
        this.seedIndex = seedIndex;
    }

    public int func_77626_a(ItemStack stack) {
        return 20;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        RayTraceResult raytraceresult = this.func_77621_a(world, player, true);
        if (raytraceresult == null || raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        BlockPos pos = raytraceresult.func_178782_a();
        Block block = world.func_180495_p(pos).func_177230_c();
        if (world.func_175660_a(player, pos) && this.canTransform(world, pos)) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (!(entityLiving instanceof EntityPlayer)) {
            return stack;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        RayTraceResult raytraceresult = this.func_77621_a(world, player, true);
        if (raytraceresult == null || raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return stack;
        }
        BlockPos pos = raytraceresult.func_178782_a();
        if (!world.func_175660_a(player, pos)) {
            return stack;
        }
        if (!world.func_175623_d(pos.func_177984_a()) || !this.canTransform(world, pos)) {
            return stack;
        }
        world.func_175656_a(pos, center_block[this.seedIndex]);
        world.func_175656_a(pos.func_177984_a(), center_top_block[this.seedIndex]);
        world.func_184133_a(null, entityLiving.func_180425_c(), SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!world.field_72995_K) {
            int r = radius[this.seedIndex];
            for (int dx = -r; dx <= r; ++dx) {
                for (int dz = -r; dz <= r; ++dz) {
                    float dist = 1.0f - (float)Math.hypot(dx, dz) / ((float)r * 1.333f);
                    BlockPos dpos = pos.func_177982_a(dx, 0, dz);
                    if (!world.func_175623_d(dpos)) {
                        if (world.func_175623_d(dpos.func_177984_a())) {
                            this.transform(world, dpos, dist, dist);
                            continue;
                        }
                        if (!world.func_175623_d(dpos.func_177984_a().func_177984_a())) continue;
                        this.transform(world, dpos.func_177984_a(), dist, dist);
                        continue;
                    }
                    if (!world.func_175623_d(dpos.func_177977_b())) {
                        this.transform(world, dpos.func_177977_b(), dist, dist);
                        continue;
                    }
                    if (world.func_175623_d(dpos.func_177977_b().func_177977_b())) continue;
                    this.transform(world, dpos.func_177977_b().func_177977_b(), dist, dist);
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    private boolean canTransform(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return RecipeSeedOfLife.getResult(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
    }

    private void transform(World world, BlockPos pos, float prob, float grassProbability) {
        if (Math.random() < (double)prob && this.canTransform(world, pos)) {
            IBlockState other_block = less_probable_blocks[this.seedIndex][(int)((double)less_probable_blocks[this.seedIndex].length * Math.random())];
            world.func_175656_a(pos, Math.random() < (double)grassProbability ? probable_block[this.seedIndex] : other_block);
            if (Math.random() < 0.5) {
                IBlockState top_block = top_blocks[this.seedIndex][(int)((double)top_blocks[this.seedIndex].length * Math.random())];
                world.func_175656_a(pos.func_177984_a(), top_block);
            }
        }
    }

    public static void init() {
        center_block = new IBlockState[]{Main.fertile_soil.func_176223_P(), Main.crystal_nether_block.func_176223_P(), Blocks.field_150377_bs.func_176223_P()};
        center_top_block = new IBlockState[]{Blocks.field_150345_g.func_176223_P(), Blocks.field_150350_a.func_176223_P(), Blocks.field_185766_cS.func_176223_P()};
        probable_block = new IBlockState[]{Blocks.field_150349_c.func_176223_P(), Blocks.field_150424_aL.func_176223_P(), Blocks.field_150377_bs.func_176223_P()};
        less_probable_blocks = new IBlockState[][]{{Blocks.field_150346_d.func_176223_P()}, {Main.scorch_grit.func_176223_P(), Blocks.field_150351_n.func_176223_P()}, {Blocks.field_185767_cT.func_176223_P(), Main.moonstone.func_176223_P()}};
        IBlockState[][] iBlockStateArrayArray = new IBlockState[3][];
        IBlockState[] iBlockStateArray = new IBlockState[2];
        iBlockStateArray[0] = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.FERN);
        iBlockStateArray[1] = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS);
        iBlockStateArrayArray[0] = iBlockStateArray;
        iBlockStateArrayArray[1] = new IBlockState[]{Blocks.field_150426_aN.func_176223_P(), Blocks.field_150488_af.func_176223_P(), Blocks.field_150480_ab.func_176223_P()};
        iBlockStateArrayArray[2] = new IBlockState[]{Blocks.field_150350_a.func_176223_P()};
        top_blocks = iBlockStateArrayArray;
    }
}

