/*
 * Decompiled with CFR 0.152.
 */
package wolforce.items;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import wolforce.Main;
import wolforce.base.MyItem;
import wolforce.entities.EntityPower;
import wolforce.recipes.RecipePowerCrystal;

public class ItemPowerCrystal
extends MyItem {
    public static final String nucleous = "power_nucleous";
    public static final String relay = "power_relay";
    public static final String screen = "power_screen";
    public static final String power = "power_power";
    public static final String max_power = "power_max_power";
    public static final String range = "power_range";
    public static final String purity = "power_purity";

    public ItemPowerCrystal(String name) {
        super(name, new String[0]);
        this.func_77625_d(1);
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (RecipePowerCrystal.isInnited() && stack.func_77942_o() && stack.func_77978_p().func_74764_b("hwell")) {
            NBTTagCompound nbt = stack.func_179543_a("hwell");
            int nuc = ItemPowerCrystal.getNucleous(nbt);
            int rel = ItemPowerCrystal.getRelay(nbt);
            int scr = ItemPowerCrystal.getScreen(nbt);
            tooltip.add("Nucleous: " + RecipePowerCrystal.getNucleous((int)nuc).name);
            tooltip.add("Relay: " + RecipePowerCrystal.getRelay((int)rel).name);
            tooltip.add("Screen: " + RecipePowerCrystal.getScreen((int)scr).name);
            int pow = ItemPowerCrystal.getPower(nbt);
            int max = ItemPowerCrystal.getMaxPower(nbt);
            int rng = ItemPowerCrystal.getRange(nbt);
            float pur = ItemPowerCrystal.getPurity(nbt);
            tooltip.add("Power: " + pow + "/" + max);
            tooltip.add("Range: " + rng);
            if (pur == 1.0f) {
                tooltip.add("Purity: 100%");
            } else {
                tooltip.add("Purity: " + (pur + "").substring(2, Math.min(4, (pur + "").length())) + "%");
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer p, EnumHand handIn) {
        RayTraceResult raytraceresult;
        if (!p.func_70093_af() && (raytraceresult = this.func_77621_a(worldIn, p, false)) != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK && worldIn.func_180495_p(raytraceresult.func_178782_a()).func_177230_c() == Main.charger) {
            return new ActionResult(EnumActionResult.PASS, (Object)p.func_184586_b(handIn));
        }
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)ItemStack.field_190927_a);
        }
        Vec3d v = p.func_70040_Z();
        EntityPower e = new EntityPower(worldIn, p.field_70165_t + v.field_72450_a, p.field_70163_u + 0.5, p.field_70161_v + v.field_72449_c);
        e.setLateEntityNBT(p.func_184586_b(handIn).func_77978_p());
        p.func_130014_f_().func_72838_d((Entity)e);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)ItemStack.field_190927_a);
    }

    public static void setHwellNBT(NBTTagCompound nbt, int nuc, int rel, int scr) {
        int max = RecipePowerCrystal.calcMaxPower(nuc, rel, scr);
        int pow = RecipePowerCrystal.calcPower(max);
        int rng = RecipePowerCrystal.calcRange(nuc, rel, scr);
        float pur = RecipePowerCrystal.calcPurity(nuc, rel, scr);
        ItemPowerCrystal.setNBT(nbt, nuc, rel, scr, pow, max, rng, pur);
    }

    public static void setNBT(NBTTagCompound nbt, int nuc, int rel, int scr, int pow, int max, int rng, float pur) {
        nbt.func_74774_a(nucleous, (byte)nuc);
        nbt.func_74774_a(relay, (byte)rel);
        nbt.func_74774_a(screen, (byte)scr);
        nbt.func_74768_a(power, pow);
        nbt.func_74768_a(max_power, max);
        nbt.func_74768_a(range, rng);
        nbt.func_74776_a(purity, pur);
    }

    public static int getNucleous(NBTTagCompound nbt) {
        return nbt.func_74771_c(nucleous);
    }

    public static int getRelay(NBTTagCompound nbt) {
        return nbt.func_74771_c(relay);
    }

    public static int getScreen(NBTTagCompound nbt) {
        return nbt.func_74771_c(screen);
    }

    public static int getPower(NBTTagCompound nbt) {
        return nbt.func_74762_e(power);
    }

    public static int getMaxPower(NBTTagCompound nbt) {
        return nbt.func_74762_e(max_power);
    }

    public static int getRange(NBTTagCompound nbt) {
        return nbt.func_74762_e(range);
    }

    public static float getPurity(NBTTagCompound nbt) {
        return nbt.func_74760_g(purity);
    }

    public static void setPower(NBTTagCompound nbt, int newPower) {
        nbt.func_74768_a(power, newPower);
    }
}

