/*
 * Decompiled with CFR 0.152.
 */
package wolforce.items;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wolforce.HwellConfig;
import wolforce.Main;
import wolforce.Util;
import wolforce.base.MyItem;

public class ItemMystFertilizer
extends MyItem {
    private static final double SMALLNESS = 3.0;

    public ItemMystFertilizer(String name, String ... lore) {
        super(name, lore);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Block block;
        ItemStack heldItem = player.func_184586_b(hand);
        if (!world.field_72995_K && (block = world.func_180495_p(pos).func_177230_c()) == Blocks.field_150345_g && Util.isValid(heldItem) && heldItem.func_77973_b() == Main.myst_fertilizer) {
            if (!player.field_71075_bZ.field_75098_d) {
                heldItem.func_190918_g(1);
            }
            if (Math.random() < 0.3 && this.canMakeTree(world, pos)) {
                int treeHeight = (int)(4.0 + Math.random() * 4.0);
                for (int i = 0; i < treeHeight; ++i) {
                    world.func_175656_a(pos.func_177982_a(0, i, 0), i == treeHeight - 1 ? Main.myst_leaves.func_176223_P() : Main.myst_log.func_176223_P());
                    if (i <= 1) continue;
                    this.makeLeavesPlane(world, pos.func_177982_a(0, i, 0), Math.abs((double)(treeHeight - 2) / 2.0 - (double)(i - 2)));
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private void makeLeavesPlane(World world, BlockPos c, double smallness) {
        IBlockState leaves = Main.myst_leaves.func_176223_P();
        double radius = 3.0 - smallness;
        System.out.println(radius);
        for (int x = -4; x < 4; ++x) {
            for (int z = -4; z < 4; ++z) {
                BlockPos pos = c.func_177982_a(x, 0, z);
                if (!world.func_175623_d(pos) || !(Math.hypot(x, z) < radius)) continue;
                world.func_175656_a(pos, leaves);
            }
        }
    }

    private boolean canMakeTree(World world, BlockPos pos) {
        return world.func_175678_i(pos) || !HwellConfig.other.mystSaplingRequireSky;
    }
}

