/*
 * Decompiled with CFR 0.152.
 */
package wolforce.items;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import wolforce.HwellConfig;
import wolforce.Util;
import wolforce.base.MyItem;

public class ItemLoot
extends MyItem {
    private static ResourceLocation[] easyLootTables;
    private static ResourceLocation[] lootTables;
    private final int lootTableIndex;

    public ItemLoot(String name, int lootTableIndex, String ... lore) {
        super(name, lore);
        this.lootTableIndex = lootTableIndex;
        this.func_77625_d(1);
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return HwellConfig.machines.producerTimeToHatch;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)ItemStack.field_190927_a);
        }
        for (ItemStack itemstack : this.getLoot(worldIn, (Entity)playerIn)) {
            playerIn.func_71019_a(itemstack, false);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)ItemStack.field_190927_a);
    }

    public static void entityItemExpired(ItemExpireEvent event) {
        EntityItem entity = event.getEntityItem();
        if (!entity.field_70170_p.field_72995_K) {
            entity.field_70170_p.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 1.0f, 1.0f);
            for (ItemStack itemstack : ((ItemLoot)entity.func_92059_d().func_77973_b()).getLoot(entity.field_70170_p, (Entity)entity)) {
                Util.spawnItem(entity.field_70170_p, entity.func_174791_d(), itemstack, Math.random() * 0.2 - 0.1, Math.random() * 0.1, Math.random() * 0.2 - 0.1);
            }
        }
    }

    private List<ItemStack> getLoot(World world, Entity location) {
        LootContext.Builder lootcontext;
        if (world.field_72995_K) {
            return null;
        }
        Random rand = new Random();
        LootContext.Builder builder = lootcontext = location instanceof EntityPlayer ? new LootContext.Builder((WorldServer)world).func_186470_a((EntityPlayer)location) : new LootContext.Builder((WorldServer)world).func_186470_a((EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world)));
        if (this.lootTableIndex < 0) {
            if (rand.nextDouble() < 0.75) {
                ResourceLocation lootTable = easyLootTables[(int)(Math.random() * (double)easyLootTables.length)];
                LootTable loottable = world.func_184146_ak().func_186521_a(lootTable);
                List lootList = loottable.func_186462_a(rand, lootcontext.func_186471_a());
                return lootList;
            }
            ResourceLocation lootTable = lootTables[(int)(Math.random() * (double)lootTables.length)];
            LootTable loottable = world.func_184146_ak().func_186521_a(lootTable);
            List lootList = loottable.func_186462_a(rand, lootcontext.func_186471_a());
            return lootList;
        }
        ResourceLocation lootTable = lootTables[this.lootTableIndex];
        LootTable loottable = world.func_184146_ak().func_186521_a(lootTable);
        List lootList = loottable.func_186462_a(rand, lootcontext.func_186471_a());
        lootList.addAll(loottable.func_186462_a(rand, lootcontext.func_186471_a()));
        lootList.addAll(loottable.func_186462_a(rand, lootcontext.func_186471_a()));
        lootList.addAll(loottable.func_186462_a(rand, lootcontext.func_186471_a()));
        return lootList;
    }

    public static void setLootTables() {
        lootTables = new ResourceLocation[]{LootTableList.field_186433_o, LootTableList.field_186434_p, LootTableList.field_186439_u, LootTableList.field_186380_ae, LootTableList.field_186442_x, LootTableList.field_186385_aj, LootTableList.field_186378_ac, LootTableList.field_186435_q, LootTableList.field_186432_n, LootTableList.field_186386_ak, LootTableList.field_186383_ah, LootTableList.field_186440_v};
        easyLootTables = new ResourceLocation[]{LootTableList.field_186383_ah, LootTableList.field_186383_ah, LootTableList.field_186383_ah, LootTableList.field_186383_ah, LootTableList.field_186385_aj, LootTableList.field_186385_aj, LootTableList.field_186385_aj, LootTableList.field_186385_aj, LootTableList.field_186434_p, LootTableList.field_186434_p, LootTableList.field_186434_p, LootTableList.field_186434_p, LootTableList.field_186435_q, LootTableList.field_186435_q, LootTableList.field_186435_q, LootTableList.field_186435_q, LootTableList.field_186439_u};
    }
}

