/*
 * Decompiled with CFR 0.152.
 */
package wolforce.items;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import wolforce.Main;
import wolforce.base.MyItem;

public class ItemEmptyRod
extends MyItem {
    private final Item nextItem;
    private RodType type;

    public ItemEmptyRod(String name, RodType type, Item nextItem, String ... lore) {
        super(name, lore);
        this.nextItem = nextItem;
        this.type = type;
        this.func_77625_d(1);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 20;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (hand.equals((Object)EnumHand.OFF_HAND)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
        }
        ItemStack hand1 = player.func_184614_ca();
        ItemStack hand2 = player.func_184592_cb();
        if (hand1.func_77973_b() instanceof ItemEmptyRod) {
            player.func_184598_c(EnumHand.MAIN_HAND);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)hand1);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (!(entityLiving instanceof EntityPlayer)) {
            return stack;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        ItemStack hand1 = player.func_184614_ca();
        ItemStack hand2 = player.func_184592_cb();
        if (hand1.func_77973_b() instanceof ItemEmptyRod) {
            return this.type.onItemUseFinish(player, stack, hand2, this.nextItem);
        }
        return stack;
    }

    public static enum RodType {
        EMPTY(null){

            @Override
            public ItemStack onItemUseFinish(EntityPlayer player, ItemStack stack, ItemStack hand2, Item nextItem) {
                if (hand2.func_77973_b().equals(BLAZE.consumes)) {
                    return BLAZE.onItemUseFinish(player, stack, hand2, Main.rod_blaze_1);
                }
                if (hand2.func_77973_b().equals(Main.myst_dust)) {
                    hand2.func_190918_g(1);
                    return MYST.onItemUseFinish(player, stack, hand2, Main.myst_rod);
                }
                return MYST.onItemUseFinish(player, stack, hand2, Main.rod_myst_1);
            }
        }
        ,
        MYST(null){

            @Override
            public ItemStack onItemUseFinish(EntityPlayer player, ItemStack stack, ItemStack hand2, Item nextItem) {
                player.func_184185_a(SoundEvents.field_187922_gv, 1.0f, 1.0f);
                player.func_70097_a(DamageSource.field_76376_m, 1.0f);
                return new ItemStack(nextItem);
            }
        }
        ,
        BLAZE(Items.field_151065_br){

            @Override
            public ItemStack onItemUseFinish(EntityPlayer player, ItemStack stack, ItemStack hand2, Item nextItem) {
                if (hand2.func_77973_b().equals(BLAZE.consumes)) {
                    hand2.func_190918_g(1);
                    player.func_184185_a(SoundEvents.field_187541_bC, 1.0f, 1.0f);
                    return new ItemStack(nextItem);
                }
                return stack;
            }
        };

        private Item consumes;

        private RodType(Item consumes) {
            this.consumes = consumes;
        }

        public abstract ItemStack onItemUseFinish(EntityPlayer var1, ItemStack var2, ItemStack var3, Item var4);
    }
}

