/*
 * Decompiled with CFR 0.152.
 */
package wolforce.items;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wolforce.Main;
import wolforce.blocks.tile.TileBranch;

public class ItemBranch
extends ItemBlock {
    public static final String branch_time = "branch_time";
    private String[] lore;

    public ItemBranch(Block block, String name, String ... lore) {
        super(block);
        this.lore = lore;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        boolean ret = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        if (ret) {
            TileBranch tile = (TileBranch)world.func_175625_s(pos);
            tile.time = ItemBranch.getTime(stack.func_77978_p());
        }
        return ret;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (ItemBranch.hasLifeTag(stack)) {
            long life = ItemBranch.getLife(stack);
            if (life > 0L) {
                tooltip.add("Liveliness remaining: " + (int)(life / 100L));
            } else {
                tooltip.add("Lifeless");
            }
        } else {
            tooltip.add("Lifeless");
        }
    }

    private static boolean hasLifeTag(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(branch_time);
    }

    private static boolean hasLifeTag(NBTTagCompound nbt) {
        return nbt != null && nbt.func_74764_b(branch_time);
    }

    public static long getLife(ItemStack stack) {
        return ItemBranch.getLife(stack.func_77978_p());
    }

    private static long getLife(NBTTagCompound nbt) {
        if (ItemBranch.hasLifeTag(nbt)) {
            return ItemBranch.getLife(nbt.func_74763_f(branch_time));
        }
        return -1L;
    }

    public static long getLife(long time) {
        return time + 100000L - System.currentTimeMillis();
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        NBTTagCompound nbt = stack.func_77978_p();
        if (ItemBranch.hasLifeTag(nbt) && ItemBranch.getLife(nbt) <= 0L) {
            stack.func_77982_d(null);
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return ItemBranch.getLife(stack) > 0L;
    }

    public static ItemStack createNewStack(int n) {
        ItemStack stack = new ItemStack(Main.branch, n);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        ItemBranch.setNBT(stack.func_77978_p(), System.currentTimeMillis());
        return stack;
    }

    public static void setNBT(NBTTagCompound nbt, long time) {
        nbt.func_74772_a(branch_time, time);
    }

    public static long getTime(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b(branch_time)) {
            return nbtTagCompound.func_74763_f(branch_time);
        }
        return -1L;
    }
}

