/*
 * Decompiled with CFR 0.152.
 */
package wolforce.entities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import wolforce.HwellConfig;
import wolforce.Main;
import wolforce.Util;
import wolforce.items.ItemPowerCrystal;

public class EntityPower
extends Entity {
    private static final AxisAlignedBB colbox = new AxisAlignedBB(0.0, -1.0, 0.0, 1.0, 1.0, 1.0);
    private static final DataParameter<Integer> POWER = EntityDataManager.func_187226_a(EntityPower.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MAX_POWER = EntityDataManager.func_187226_a(EntityPower.class, (DataSerializer)DataSerializers.field_187192_b);
    int nucleous;
    int relay;
    int screen;
    int range;
    float purity;
    private String customName = "";
    int power;
    int maxPower;

    public EntityPower(World worldIn) {
        super(worldIn);
    }

    public EntityPower(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    protected void func_70088_a() {
        this.field_70130_N = 0.5f;
        this.field_70131_O = 1.5f;
    }

    public boolean hasEnergy(int _energy, float erange) {
        if (erange > (float)this.range) {
            return false;
        }
        return this.getPower() >= this.calcEnergy(_energy, erange);
    }

    public boolean tryConsume(int _energy, float erange) {
        if (erange > (float)this.range) {
            return false;
        }
        int energy = this.calcEnergy(_energy, erange);
        if (this.getPower() >= energy) {
            this.decreasePower(energy);
            return true;
        }
        return false;
    }

    private int calcEnergy(int _energy, float erange) {
        float lossTotal = (float)_energy / this.purity;
        float lossPerRange = (lossTotal - (float)_energy) / (float)HwellConfig.power.powerMaxRange;
        return _energy + (int)(lossPerRange * erange);
    }

    public void func_70030_z() {
        this.field_70170_p.field_72984_F.func_76320_a("entityBaseTick");
        this.field_70141_P = this.field_70140_Q;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.field_70148_d = false;
        this.field_70170_p.field_72984_F.func_76319_b();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.getPower() <= 0 && HwellConfig.power.powerCrystalDropsWhenEmpty && !this.field_70128_L) {
            this.pop();
        }
        this.func_96094_a(this.customName + this.getPower());
    }

    public int getPower() {
        return (Integer)this.func_184212_Q().func_187225_a(POWER);
    }

    public int getMaxPower() {
        return (Integer)this.func_184212_Q().func_187225_a(MAX_POWER);
    }

    public void setPower(int power, int maxPower) {
        this.func_184212_Q().func_187227_b(POWER, (Object)power);
        this.func_184212_Q().func_187227_b(MAX_POWER, (Object)maxPower);
    }

    private void decreasePower(int power) {
        if (this.getPower() >= power) {
            this.func_184212_Q().func_187227_b(POWER, (Object)(this.getPower() - power));
        }
    }

    private void pop() {
        ItemStack newstack = new ItemStack((Item)Main.power_crystal);
        if (!newstack.func_77942_o()) {
            newstack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = new NBTTagCompound();
        ItemPowerCrystal.setNBT(nbt, this.nucleous, this.relay, this.screen, this.getPower(), this.getMaxPower(), this.range, this.purity);
        newstack.func_77978_p().func_74782_a("hwell", (NBTBase)nbt);
        Util.spawnItem(this.field_70170_p, new Vec3d(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v), newstack, 10, 0.0, 0.2, 0.0);
        this.func_70106_y();
        this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        if (this.field_70170_p.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        this.pop();
        return EnumActionResult.SUCCESS;
    }

    public AxisAlignedBB func_70046_E() {
        return colbox;
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return colbox;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70075_an() {
        return false;
    }

    public void setLateEntityNBT(NBTTagCompound __nbt) {
        NBTTagCompound nbt;
        NBTTagCompound _nbt;
        NBTTagCompound nBTTagCompound = _nbt = __nbt == null ? new NBTTagCompound() : __nbt;
        if (_nbt.func_74764_b("hwell")) {
            nbt = _nbt.func_74775_l("hwell");
        } else {
            nbt = new NBTTagCompound();
            _nbt.func_74782_a("hwell", (NBTBase)nbt);
        }
        this.nucleous = ItemPowerCrystal.getNucleous(nbt);
        this.relay = ItemPowerCrystal.getRelay(nbt);
        this.screen = ItemPowerCrystal.getScreen(nbt);
        int power = ItemPowerCrystal.getPower(nbt);
        int maxPower = ItemPowerCrystal.getMaxPower(nbt);
        this.func_184212_Q().func_187214_a(POWER, (Object)power);
        this.func_184212_Q().func_187214_a(MAX_POWER, (Object)maxPower);
        this.range = ItemPowerCrystal.getRange(nbt);
        this.purity = ItemPowerCrystal.getPurity(nbt);
    }

    public void func_70037_a(NBTTagCompound _nbt) {
        this.setLateEntityNBT(_nbt);
    }

    public void func_70014_b(NBTTagCompound rootnbt) {
        if (!rootnbt.func_74764_b("hwell")) {
            rootnbt.func_74782_a("hwell", (NBTBase)new NBTTagCompound());
        }
        ItemPowerCrystal.setNBT(rootnbt.func_74775_l("hwell"), this.nucleous, this.relay, this.screen, this.getPower(), this.getMaxPower(), this.range, this.purity);
    }

    public boolean func_174833_aM() {
        return true;
    }
}

